//   $Id: kvi_int.h,v 1.3 1998/09/28 13:55:50 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_INTERFACE_H_INCLUDED_
#define _KVI_INTERFACE_H_INCLUDED_

#include <qcolor.h>
#include <qpixmap.h>
#include <qfont.h>

class KviInterface{
public:
	KviInterface();
	~KviInterface();
public:
	QColor	clr_bk_mdi;
	QPixmap	pix_bk_mdi;
	QString str_bk_mdi;
	//Labels (captions)
	QColor	clr_bk_act_caption;
	QColor	clr_bk_ina_caption;
	QColor	clr_fr_act_caption;
	QColor	clr_fr_ina_caption;
	QFont	fnt_caption;
	QPixmap	pix_bk_caption;
	QString	str_bk_caption;
	//Input box
	QColor	clr_bk_input;
	QColor	clr_fr_input;
	QColor	clr_bk_sel_input;
	QColor	clr_fr_sel_input;
	QColor  clr_cursor_input;
	QFont	fnt_input;
	QPixmap	pix_bk_input;
	QString	str_bk_input;
	//Output box
	QColor	clr_bk_output;
	QColor	clr_bk_sel_output;
	QColor	clr_fr_sel_output;
	QFont	fnt_output;
	QPixmap	pix_bk_output;
	QString	str_bk_output;
	//List box
	QColor	clr_bk_listbox;
	QColor	clr_fr_normal_listbox;
	QColor	clr_fr_op_listbox;
	QColor	clr_fr_voice_listbox;
	QColor	clr_bk_sel_listbox;
	QColor	clr_fr_sel_listbox;
	QPixmap	pix_bk_listbox;
	QString	str_bk_listbox;
	QFont	fnt_listbox;
	//Chan Labels
	QColor	clr_bk_chanlabels;
	QColor	clr_fr_chanlabels;
	QColor  clr_fr_act_chanlabels;
	QPixmap	pix_bk_chanlabels;
	QString str_bk_chanlabels;
	QFont	fnt_chanlabels;
	//Script editor
	QColor  clr_edit_back;
	QColor  clr_edit_fore;
	QColor  clr_edit_cursor;
	QColor  clr_edit_comment;
	QColor  clr_edit_command;
	QColor  clr_edit_variable;
	QColor  clr_edit_brace;
	QColor  clr_edit_operator;
	QColor  clr_edit_channel;
public:
	void readSettings();
	void saveSettings();
};

#endif //_KVI_INTERFACE_H_INCLUDED_
