//   $Id: kvi_ident.h,v 1.2 1998/09/20 20:22:49 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_IDENT_H_INCLUDED_
#define _KVI_IDENT_H_INCLUDED_

#include "kvi_types.h"

#include <qdialog.h>
#include <qmultilinedit.h>
#include <qlabel.h>

class KviFrame;
class KviIrcSocket;
class KviStatusWnd;
class KviMdiManager;
class KviGlobals;
class KviOptions;
class KviChanWnd;

class KviInputBox:public QDialog{
	Q_OBJECT
public:
	KviInputBox(QWidget *parent,QString szText,QString *pRet);
	~KviInputBox();
private:
	QPushButton    *lpOk;
	QPushButton    *lpCancel;
	QLabel         *lpTxt;
	QMultiLineEdit *lpEdit;
	QString        *lpRet;
protected:
	virtual void resizeEvent(QResizeEvent *);
private slots:
	void okClicked();
};
class KviIdentifiers{
public:
	KviIdentifiers(KviFrame *lpFrame,KviUserParser *lpParser);
	~KviIdentifiers();
public:
	KviUserParser		*m_lpPar;
	KviFrame			*m_lpFrm;
	KviIrcSocket		*m_lpSock;
	KviStatusWnd		*m_lpCons;
	KviMdiManager		*m_lpMdi;
	KviGlobals			*m_lpGlb;
	KviOptions			*m_lpOpt;
	QList<KviVariable>	*m_lpVarList;
//	QDict<char>         *m_lpCache;
public:
	void substitute(KviMdiChild *lpC,QString &szData,KviAliasParams *pP);
private:
	bool getReplacement(KviMdiChild *lpC,QString &szIdn,QString &szPar,QString &szRepl,KviAliasParams *pP);
	KviChanWnd * getChanWnd(const char *szName);
};

#endif //_KVI_IDENT_H_INCLUDED_
