//   $Id: kvi_help.h,v 1.3 1998/10/01 00:48:53 pragma Exp $
//
//   This file is part of the KVIrc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_HELP_H_INCLUDED_
#define _KVI_HELP_H_INCLUDED_

#include "kvi_child.h"

class KviHelp;

typedef void (KviHelp::*helpProc) (KviMdiChild *);

typedef struct helpCmdTabTag{
	const char *szName;
	int lenName;
	helpProc proc;
} helpCmdTable;

class KviHelp{
public:
	KviHelp();
	~KviHelp();
public:
	static helpCmdTable hlpTab[];
public:
	void doHelp(KviMdiChild *lpC,QString &szHlp);
	void doHelpOnAway(     KviMdiChild *lpC);
	void doHelpOnHelp(     KviMdiChild *lpC);
	void doHelpIndex(      KviMdiChild *lpC);
	void doHelpOnCommands( KviMdiChild *lpC);
	void doHelpOnDefs(     KviMdiChild *lpC);
	void doHelpOnJoin(     KviMdiChild *lpC);
	void doHelpOnPart(     KviMdiChild *lpC);
	void doHelpOnOpDeop(   KviMdiChild *lpC);
	void doHelpOnKick(     KviMdiChild *lpC);
	void doHelpOnWhois(    KviMdiChild *lpC);
	void doHelpOnSet(      KviMdiChild *lpC);
	void doHelpOnUnset(    KviMdiChild *lpC);
	void doHelpOnCtcp(     KviMdiChild *lpC);
	void doHelpOnQuery(    KviMdiChild *lpC);
	void doHelpOnChat(     KviMdiChild *lpC);
	void doHelpOnIf(       KviMdiChild *lpC);
	void doHelpOnEcho(     KviMdiChild *lpC);
	void doHelpOnRaw(      KviMdiChild *lpC);
	void doHelpOnSend(     KviMdiChild *lpC);
	void doHelpOnKban(     KviMdiChild *lpC);
	void doHelpOnMode(     KviMdiChild *lpC);
	void doHelpOnUserlist( KviMdiChild *lpC);
	void doHelpOnVariables(KviMdiChild *lpC);
	void doHelpOnMy(       KviMdiChild *lpC);
	void doHelpOnCh(       KviMdiChild *lpC);
	void doHelpOnFl(       KviMdiChild *lpC);
	void doHelpOnClonescan(KviMdiChild *lpC);
	void doHelpOnIdent(    KviMdiChild *lpC);
	void doHelpOnChn(      KviMdiChild *lpC);
	void doHelpOnNk(       KviMdiChild *lpC);
	void doHelpOnBox(      KviMdiChild *lpC);
	void doHelpOnMe(       KviMdiChild *lpC);
	void doHelpOnIs(       KviMdiChild *lpC);
	void doHelpOnTimer(    KviMdiChild *lpC);
	void doHelpOnProc(     KviMdiChild *lpC);
	void doHelpOnPlay(     KviMdiChild *lpC);
	void doHelpOnHalt(     KviMdiChild *lpC);
	void doHelpOnSay(      KviMdiChild *lpC);
	void doHelpOnServer(   KviMdiChild *lpC);
	void doHelpOnStr(      KviMdiChild *lpC);
	void doHelpOnNotice(   KviMdiChild *lpC);
	void doHelpOnWindow(   KviMdiChild *lpC);
	void doHelpOnForeach(  KviMdiChild *lpC);
	void doHelpOnDns(      KviMdiChild *lpC);
	void doHelpOnLst(      KviMdiChild *lpC);
	void doHelpOnDir(      KviMdiChild *lpC);
	void doHelpOnAscii(    KviMdiChild *lpC);
	void doHelpOnCache(    KviMdiChild *lpC);
	void doHelpOnReturn(   KviMdiChild *lpC);
	void doHelpOnExt(      KviMdiChild *lpC);
	void doHelpOnCmp(      KviMdiChild *lpC);
	void doHelpOnInc(      KviMdiChild *lpC);
	void doHelpOnCal(      KviMdiChild *lpC);
	void doHelpOnSound(    KviMdiChild *lpC);
	void doHelpOnFile(     KviMdiChild *lpC);
	void doHelpOnFio(      KviMdiChild *lpC);
	void doHelpOnAlias(    KviMdiChild *lpC);
	void doHelpOnTalk(     KviMdiChild *lpC);
	void doHelpOnList(     KviMdiChild *lpC);
	void doHelpOnConnstats(KviMdiChild *lpC);
};

#endif //_KVI_HELP_H_INCLUDED_
