//   $Id: kvi_help.cpp,v 1.5 1998/10/06 14:42:22 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_defs.h"
#include "kvi_help.h"
#include "kvi_debug.h"
#include "kvi_child.h"

#include <kapp.h>

KviHelp::KviHelp(){};
KviHelp::~KviHelp(){};

helpCmdTable KviHelp::hlpTab[]={
	{ "HELP"         , 4  , &KviHelp::doHelpOnHelp      },{ "INDEX"        , 5  , &KviHelp::doHelpIndex       },
	{ "COMMANDS"     , 8  , &KviHelp::doHelpOnCommands  },{ "DEFINITIONS"  , 11 , &KviHelp::doHelpOnDefs      },
	{ "JOIN"         , 4  , &KviHelp::doHelpOnJoin      },{ "PART"         , 4  , &KviHelp::doHelpOnPart      },
	{ "OP"           , 2  , &KviHelp::doHelpOnOpDeop    },{ "DEOP"         , 4  , &KviHelp::doHelpOnOpDeop    },
	{ "VOICE"        , 5  , &KviHelp::doHelpOnOpDeop    },{ "DEVOICE"      , 7  , &KviHelp::doHelpOnOpDeop    },
	{ "BAN"          , 3  , &KviHelp::doHelpOnOpDeop    },{ "UNBAN"        , 5  , &KviHelp::doHelpOnOpDeop    },
	{ "KICK"         , 4  , &KviHelp::doHelpOnKick      },{ "SET"          , 3  , &KviHelp::doHelpOnSet       },
	{ "UNSET"        , 5  , &KviHelp::doHelpOnUnset     },{ "CTCP"         , 4  , &KviHelp::doHelpOnCtcp      },
	{ "QUERY"        , 5  , &KviHelp::doHelpOnQuery     },{ "CHAT"         , 4  , &KviHelp::doHelpOnChat      },
	{ "IF"           , 2  , &KviHelp::doHelpOnIf        },{ "ECHO"         , 4  , &KviHelp::doHelpOnEcho      },
	{ "RAW"          , 3  , &KviHelp::doHelpOnRaw       },{ "SEND"         , 4  , &KviHelp::doHelpOnSend      },
	{ "WHOIS"        , 5  , &KviHelp::doHelpOnWhois     },{ "KBAN"         , 4  , &KviHelp::doHelpOnKban      },
	{ "MODE"         , 4  , &KviHelp::doHelpOnMode      },{ "WHOWAS"       , 6  , &KviHelp::doHelpOnWhois     },
	{ "USERLIST"     , 8  , &KviHelp::doHelpOnUserlist  },{ "VARIABLES"    , 9  , &KviHelp::doHelpOnVariables },
	{ "$_mynick"     , 8  , &KviHelp::doHelpOnMy        },{ "$_myserver"   , 10 , &KviHelp::doHelpOnMy        },
	{ "$_myip"       , 6  , &KviHelp::doHelpOnMy        },{ "$_myserverip" , 12 , &KviHelp::doHelpOnMy        },
	{ "$_mynetwork"  , 11 , &KviHelp::doHelpOnMy        },{ "$_myrealname" , 12 , &KviHelp::doHelpOnMy        },
	{ "$_myusername" , 12 , &KviHelp::doHelpOnMy        },{ "$_myport"     , 8  , &KviHelp::doHelpOnMy        },
	{ "$_mymask"     , 8  , &KviHelp::doHelpOnMy        },{ "$_chan"       , 6  , &KviHelp::doHelpOnCh        },
	{ "$_window"     , 8  , &KviHelp::doHelpOnCh        },{ "$_status"     , 8  , &KviHelp::doHelpOnCh        },
	{ "$_allchans"   , 10 , &KviHelp::doHelpOnCh        },{ "$_false"      , 7  , &KviHelp::doHelpOnFl        },
	{ "$_true"       , 6  , &KviHelp::doHelpOnFl        },{ "$_null"       , 6  , &KviHelp::doHelpOnFl        },
	{ "CLONESCAN"    , 9  , &KviHelp::doHelpOnClonescan },{ "FUNCTIONS"    , 9  , &KviHelp::doHelpOnIdent     },
	{ "$%chn_opcount" , 13, &KviHelp::doHelpOnChn       },{ "$%chn_voicecount",16,&KviHelp::doHelpOnChn       },
	{ "$%chn_count"   , 11, &KviHelp::doHelpOnChn       },{ "$%chn_nopcount", 14 ,&KviHelp::doHelpOnChn       },
	{ "$%chn_allonchan",15, &KviHelp::doHelpOnChn       },{ "$%chn_oponchan", 14 ,&KviHelp::doHelpOnChn       },
	{ "$%chn_voiceonchan",17,&KviHelp::doHelpOnChn      },{ "$%chn_noponchan",15 ,&KviHelp::doHelpOnChn       },
	{ "$%chn_topic"   , 11, &KviHelp::doHelpOnChn       },{ "$%chn_mode"   , 10 , &KviHelp::doHelpOnChn       },
	{ "$%nck_maskX"  , 11 , &KviHelp::doHelpOnNk        },{ "$%nck_ison"   , 10 , &KviHelp::doHelpOnNk        },
	{ "$%nck_isop"   , 10 , &KviHelp::doHelpOnNk        },{ "$%nck_address", 13 , &KviHelp::doHelpOnNk        },
	{ "$%nck_isvoice", 13 , &KviHelp::doHelpOnNk        },{ "$%box_yesno"  , 11 , &KviHelp::doHelpOnBox       },
	{ "ME"           , 2  , &KviHelp::doHelpOnMe        },{ "$%wnd_ischan" , 12 , &KviHelp::doHelpOnIs        },
	{ "$%nck_isme"   , 10 , &KviHelp::doHelpOnNk        },{ "$_selected"   , 10 , &KviHelp::doHelpOnCh        },
	{ "$_target"     , 8  , &KviHelp::doHelpOnCh        },{ "$_allchats"   , 10 , &KviHelp::doHelpOnCh        },
	{ "$_allqueries" , 12 , &KviHelp::doHelpOnCh        },{ "$_myaddress"  , 11 , &KviHelp::doHelpOnMy        },
	{ "$_allchattargets",16,&KviHelp::doHelpOnCh        },{ "$%str_isin"   , 10 , &KviHelp::doHelpOnStr       },
	{ "$%wnd_ischat" , 12 , &KviHelp::doHelpOnIs        },{ "$%wnd_isstatus",14 , &KviHelp::doHelpOnIs        },
	{ "$%wnd_isquery", 13 , &KviHelp::doHelpOnIs        },{ "$%wnd_issend" , 12 , &KviHelp::doHelpOnIs        },
	{ "TIMER"        , 5  , &KviHelp::doHelpOnTimer     },{ "$%box_input"  , 11 , &KviHelp::doHelpOnBox       },
	{ "EXEC"         , 4  , &KviHelp::doHelpOnProc      },{ "RUN"          , 3  , &KviHelp::doHelpOnProc      },
	{ "KILLPROC"     , 8  , &KviHelp::doHelpOnProc      },{ "WRITEPROC"    , 9  , &KviHelp::doHelpOnProc      },
	{ "PROCLIST"     , 8  , &KviHelp::doHelpOnProc      },{ "WHILE"        , 5  , &KviHelp::doHelpOnIf        },
	{ "PLAY"         , 4  , &KviHelp::doHelpOnPlay      },{ "HALT"         , 4  , &KviHelp::doHelpOnHalt      },
	{ "SAY"          , 3  , &KviHelp::doHelpOnSay       },{ "SERVER"       , 6  , &KviHelp::doHelpOnServer    },
	{ "$%str_length" , 12 , &KviHelp::doHelpOnStr       },{ "$%str_equal"  , 11 , &KviHelp::doHelpOnStr       },
	{ "$%str_nequal" , 12 , &KviHelp::doHelpOnStr       },{ "$%str_lower"  , 11 , &KviHelp::doHelpOnStr       },
	{ "$%str_upper"  , 11 , &KviHelp::doHelpOnStr       },{ "$%str_find"   , 10 , &KviHelp::doHelpOnStr       },
	{ "$%str_left"   , 10 , &KviHelp::doHelpOnStr       },{ "$%str_right"  , 11 , &KviHelp::doHelpOnStr       },
	{ "$%str_isnum"  , 11 , &KviHelp::doHelpOnStr       },{ "TALK"         , 4  , &KviHelp::doHelpOnTalk      },
	{ "NOTICE"       , 6  , &KviHelp::doHelpOnNotice    },{ "AWAY"         , 4  , &KviHelp::doHelpOnAway      },
	{ "BACK"         , 4  , &KviHelp::doHelpOnAway      },{ "MSG"          , 3  , &KviHelp::doHelpOnSay       },
	{ "WINDOW"       , 6  , &KviHelp::doHelpOnWindow    },{ "$%wnd_isuserwnd",15, &KviHelp::doHelpOnIs        },
	{ "FOREACH"      , 7  , &KviHelp::doHelpOnForeach   },{ "DNS"          , 3  , &KviHelp::doHelpOnDns       },
	{ "$%lst_append" , 12 , &KviHelp::doHelpOnLst       },{ "$%lst_remove" , 12 , &KviHelp::doHelpOnLst       },
	{ "$%lst_prepend", 13 , &KviHelp::doHelpOnLst       },{ "$%lst_count"  , 11 , &KviHelp::doHelpOnLst       },
	{ "$%lst_item"   , 10 , &KviHelp::doHelpOnLst       },{ "$%lst_find"   , 10 , &KviHelp::doHelpOnLst       },
	{ "$_dirhome"    , 9  , &KviHelp::doHelpOnDir       },{ "$_dirkvirc"   , 10 , &KviHelp::doHelpOnDir       },
	{ "ASCII"        , 5  , &KviHelp::doHelpOnAscii     },{ "$%box_openfile", 14, &KviHelp::doHelpOnBox       },
	{ "$%box_savefile",14 , &KviHelp::doHelpOnBox       },{ "CACHE"        , 5  , &KviHelp::doHelpOnCache     },
	{ "RETURN"       , 6  , &KviHelp::doHelpOnReturn    },{ "$%ext_alias"  , 10 , &KviHelp::doHelpOnExt       },
	{ "$%cmp_gt"     , 8  , &KviHelp::doHelpOnCmp       },{ "$%cmp_lt"     , 8  , &KviHelp::doHelpOnCmp       },
	{ "$%cmp_eq"     , 8  , &KviHelp::doHelpOnCmp       },{ "$%cmp_elt"    , 9  , &KviHelp::doHelpOnCmp       },
	{ "$%cmp_egt"    , 9  , &KviHelp::doHelpOnCmp       },{ "$%ext_dynamic", 13 , &KviHelp::doHelpOnExt       }, 
	{ "INC"          , 3  , &KviHelp::doHelpOnInc       },{ "DEC"          , 3  , &KviHelp::doHelpOnInc       },
	{ "$%cal_add"    , 9  , &KviHelp::doHelpOnCal       },{ "$%cal_sub"    , 9  , &KviHelp::doHelpOnCal       },
	{ "$%cal_mul"    , 9  , &KviHelp::doHelpOnCal       },{ "$%cal_div"    , 9  , &KviHelp::doHelpOnCal       },
	{ "$%cal_mod"    , 9  , &KviHelp::doHelpOnCal       },{ "$%cal_not"    , 9  , &KviHelp::doHelpOnCal       },
	{ "$%cal_or"     , 8  , &KviHelp::doHelpOnCal       },{ "$%cal_and"    , 9  , &KviHelp::doHelpOnCal       },
	{ "$%cal_xor"    , 9  , &KviHelp::doHelpOnCal       },{ "$%cal_shl"    , 9  , &KviHelp::doHelpOnCal       },
	{ "$%cal_shl"    , 9  , &KviHelp::doHelpOnCal       },{ "$%ext_isset"  , 11 , &KviHelp::doHelpOnExt       },
	{ "$%str_chr"    , 9  , &KviHelp::doHelpOnStr       },{ "$%nck_match"  , 11 , &KviHelp::doHelpOnNk        },
	{ "$%lst_contains", 14, &KviHelp::doHelpOnLst       },{ "$%ext_ismeop" , 12 , &KviHelp::doHelpOnExt       },
	{ "SOUND"        , 5  , &KviHelp::doHelpOnSound     },{ "$%box_ok"     , 8  , &KviHelp::doHelpOnBox       },
	{ "$%ext_istimer", 13 , &KviHelp::doHelpOnExt       },{ "FILE"         , 4  , &KviHelp::doHelpOnFile      },
	{ "$%fio_isopen" , 12 , &KviHelp::doHelpOnFio       },{ "$%fio_readln" , 12 , &KviHelp::doHelpOnFio       },
	{ "$%fio_randln" , 12 , &KviHelp::doHelpOnFio       },{ "$%fio_writeln", 13 , &KviHelp::doHelpOnFio       },
	{ "ALIAS"        , 5  , &KviHelp::doHelpOnAlias     },{ "LIST"         , 4  , &KviHelp::doHelpOnList      },
	{ "CONNSTATS"    , 9  , &KviHelp::doHelpOnConnstats },
	{ 0              , 0  , 0                           }
};

void KviHelp::doHelp(KviMdiChild *lpC,QString &szHlp){
	int nLen=szHlp.length();
	for (int i=0;hlpTab[i].szName!=0;i++){
		if(nLen==hlpTab[i].lenName){
			if (!strncasecmp(szHlp.data(),hlpTab[i].szName,hlpTab[i].lenName)){
		 		(this->*(hlpTab[i].proc))(lpC);
				return;
			}
		}
	}
	//Not found
	doHelpOnHelp(lpC);
}

#define _cmd(__str) lpC->doFmtOutput(KVI_OUT_HELP,"%c%c%s%c%c",KVI_TEXT_REVERSE,KVI_TEXT_UNDERLINE,__str,KVI_TEXT_UNDERLINE,KVI_TEXT_REVERSE);
#define _syn(__str) lpC->doFmtOutput(KVI_OUT_HELP,"  %cSyntax      : %s%c",KVI_TEXT_BOLD,__str,KVI_TEXT_BOLD);
#define _des lpC->doFmtOutput(KVI_OUT_HELP,i18n("  %cDescription :%c"),KVI_TEXT_BOLD,KVI_TEXT_BOLD);
#define _hlp(__str) lpC->doFmtOutput(KVI_OUT_HELP,"    %s",__str);
#define _see(__str) lpC->doFmtOutput(KVI_OUT_HELP,i18n("  %cSee also    : %s%c"),KVI_TEXT_BOLD,__str,KVI_TEXT_BOLD);
#define _exa(__str) lpC->doFmtOutput(KVI_OUT_HELP,i18n("  %cExample     :%c %s"),KVI_TEXT_BOLD,KVI_TEXT_BOLD,__str);

//============ doHelpOnHelp ============//

void KviHelp::doHelpOnHelp(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnHelp");
	_cmd("HELP");
	_syn("HELP <argument>");
	_des;
	_hlp(i18n("Provides help for user commands."));
	_hlp(i18n("See /help index for a list of arguments."));
	_hlp(i18n("WARNING : From this version the /HELP command"));
	_hlp(i18n("is no longer mantained. Only syntax of commands is updated."));
	_hlp(i18n("This help has to be used only as a quick reference to commands,"));
	_hlp(i18n("the full reference is available in the html documentation."));
	_see("INDEX"); 
	_debug_leavetrace("doHelpOnHelp");
}

//============ doHelpOnServer ============//

void KviHelp::doHelpOnServer(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnServer");
	_cmd("SERVER");
	_syn("SERVER <server-name> [port]");
	_des;
	_hlp(i18n("Attempts connection to a server."));
	_hlp(i18n("If there is already another connection,KVIrc disconnects first."));
	_hlp(i18n("KVIrc looks for the <server-name> in the list of available servers."));
	_hlp(i18n("If an entry is found,that entry is brought to top of the list."));
	_hlp(i18n("If a port is specified,the port replaces the default entry port."));
	_hlp(i18n("If there is no entry with that name,a new entry is created on top"));
	_hlp(i18n("of the list. KVIrc then attempts connecting to the first server in"));
	_hlp(i18n("in the list (just like pressing the 'Connect' button)."));
	_debug_leavetrace("doHelpOnServer");
}
//============ doHelpOnInc ============//
void KviHelp::doHelpOnInc(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnInc");
	_cmd("INC DEC");
	_syn("INC <variable-name>");
	_syn("DEC <variable-name>");
	_hlp(i18n("INC : Increases the value of a variable by 1."));
	_hlp(i18n("DEC : Decreases the value of a variable by 2."));
	_hlp(i18n("These two functions are useful for loops."));
	_hlp(i18n("If the <variable> does not contain a number , "));
	_hlp(i18n("these function will do nothing."));
	_debug_leavetrace("doHelpOnInc");
}
//============ doHelpOnList ============//
void KviHelp::doHelpOnList(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnList");
	_cmd("LIST");
	_syn("LIST [list-parameters]");
	_hlp(i18n("Requests a list of channels from the server."));
	_hlp(i18n("The list-parameters are server dependant,"));
	_hlp(i18n("ask in a channel like #help , for the parameters"));
	_hlp(i18n("supported by your server."));
	_hlp(i18n("Common options are 'min/max number of users',"));
	_hlp(i18n("'topic pattern'..."));
	_debug_leavetrace("doHelpOnList");
}
//============ doHelpOnCache ============//
void KviHelp::doHelpOnCache(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnCache");
	_cmd("CACHE");
	_syn("CACHE (load|store|clear|remove|flush) [section] [key] [ <string-value> | <variable> ]");
	_des;
	_hlp(i18n("The cache command is used to save string data bewtween kvirc sessions."));
	_hlp(i18n("The data is stored on disk in the $HOME/kvirc/Config/kvi.cache.conf file."));
	_hlp(i18n("The data is oragnized in sections and localized by keys."));
	_hlp(i18n("CACHE load <section> <key> <variable>"));
	_hlp(i18n("   This will load the string referenced by <key> in the <section> to the <variable>."));
	_hlp(i18n("   If the key or section can not be found the variable is set to $_null"));
	_exa("CACHE load auto.op.lists chan.kaos.list $op.list");
	_hlp(i18n("CACHE store <section> <key> <string-value>"));
	_hlp(i18n("   This will store the data in the cache under the specified <key> and <section>")); 
	_exa("CACHE store RevengeSection LastNickThatBannedMe $last.me.banner");
	_hlp(i18n("CACHE clear"));
	_hlp(i18n("   This will crear the cache in memory."));
	_hlp(i18n("CACHE remove <section> [key]"));
	_hlp(i18n("   This will remove a specified key in a section , or the entire section if the key"));
	_hlp(i18n("   is not provided."));
	_hlp(i18n("CACHE flush"));
	_hlp(i18n("   This will store the cache on disk.The cache is automatically flushed when"));
	_hlp(i18n("   kvirc terminates."));
	_see("SET UNSET");
	_debug_leavetrace("doHelpOnCache");
}
//============ doHelpOnAlias ============//
void KviHelp::doHelpOnAlias(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnAlias");
	_cmd("ALIAS");
	_syn("ALIAS [-r] <alias-name> [alias-implementation]");
	_des;
	_hlp(i18n("Creates or removes an alias."));
	_hlp(i18n("The syntax used to create the alias is : "));
	_hlp(i18n(" ALIAS <alias-name> <alias-implementation>"));
	_hlp(i18n("If an alias with that name already exists , "));
	_hlp(i18n("it will be replaced by the new implementation."));
	_hlp(i18n("To remove an existing alias :"));
	_hlp(i18n(" ALIAS -r <alias-name>"));
	_exa("ALIAS J /Join $1");
	_exa("ALIAS HOP /if ($1)<part $1 ; join $1; >");
	_debug_leavetrace("doHelpOnAlias");
}
//============ doHelpOnAscii ============//
void KviHelp::doHelpOnAscii(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnAscii");
	_cmd("ASCII");
	_syn("ASCII  [ [-stop] | [filename [ window [timeout]]] ]");
	_des;
	_hlp(i18n("The ascii command is used to 'play' ascii files to a channel,query or chat,"));
	_hlp(i18n("Useful to displaying images or reading files."));
	_hlp(i18n("Parameters:"));
	_hlp(i18n("-stop    : This will stop all the currently playing files."));
	_hlp(i18n("filename : Filename to play.If the filename contains a '/' it is"));
	_hlp(i18n("           assumed to be an absolute path , otherwise kvirc looks"));
	_hlp(i18n("           for the file in the $HOME/kvirc/Ascii and $HOME/kvirc/Scripts/Ascii"));
	_hlp(i18n("           directories."));
	_hlp(i18n("window   : The target window to play the file.If not specified,"));
	_hlp(i18n("           the current window is assumed to be the target."));
	_hlp(i18n("           KVirc behaviour depends on the type of the target window."));
	_hlp(i18n("           In a channel,query or DCC chat window,the text is sent to "));
	_hlp(i18n("           the relative target."));
	_hlp(i18n("           In all other windows the file is 'echoed' only."));
	_hlp(i18n("timeout  : Time to wait between sending lines (default 1 sec) in millisec."));
	_exa("/ASCII beer.txt $_chan 2000");
	_debug_leavetrace("doHelpOnAscii");
}
//============ doHelpOnWindow ============//
void KviHelp::doHelpOnWindow(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnWindow");
	_cmd("WINDOW");
	_syn("WINDOW <operation> <[*]window-name> [open-parameters] [image-file]");
	_syn("<operation> ::= (hide|show|open|close|maximize|restore|setimage)");
	_syn("special case : WINDOW tile [horz|vert|anodine|pragma]");
	_syn("special case : WINDOW cascade");
	_des;
	_hlp(i18n("Creates , closes , (un)hides ...an user window."));
	_hlp(i18n("For the close and open operations the window-name MUST begin with a '*'"));
	_hlp(i18n("The [open-paramaters] are valid for the 'open' operation."));
	_hlp(i18n("<open-parameters> :"));
	_hlp(i18n("  noinput             = Creates a window without the input box"));
	_hlp(i18n("  noclose             = Creates a window with the close button disabled"));
	_hlp(i18n("  hidden              = Creates a hidden window"));
	_hlp(i18n("  size=x,y,w,h        = Creates a window with the specified width,height and position"));
	_hlp(i18n("                        the x,y,w,h parameters must be specified in pixels"));
	_hlp(i18n("                        referring to the view of the main kvirc window."));
	_hlp(i18n("  timestamp=(true|false) = overrides the default timestamp setting."));
	_hlp(i18n("  images=(true|false) = overrides the default 'show-mssage-images' setting."));
	_hlp(i18n("  background=filename = Creates a window with the specified background image"));
	_hlp(i18n("                        The filename param can be either a full path to a file"));
	_hlp(i18n("                        or a simple file name."));
	_hlp(i18n("                        If a file name is specified, then kvirc searches for that file in"));
	_hlp(i18n("                        $HOME/kvirc/Images and in $KDEDIR/share/apps/kvirc"));
	_hlp(i18n("                        If the file can not be found , the default background is used."));
	_hlp(i18n(" font=fontname[,size] = Creates a window with a specified font."));
	_hlp(i18n("If the 'noinput' is not provided, the window will have an input box."));
	_hlp(i18n("You will be able to type commands in."));
	_hlp(i18n("All the text typed that doesn't form a command , will be passed to the"));
	_hlp(i18n("Event_OnUserWndInput event (if enabled)."));
	_hlp(i18n("The 'setimage' operation , sets the <image-file> as bacground for that window."));
	_hlp(i18n("The [image-file] name follow the same rules as for 'open' background="));
	_exa("/WINDOW open *test noclose noinput size=10,10,200,300");
	_debug_leavetrace("doHelpOnWindow");
}
//============ doHelpOnSay ============//
void KviHelp::doHelpOnSay(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnSay");
	_cmd("SAY MSG");
	_syn("SAY <window/target> <text>");
	_des;
	_hlp(i18n("Sends text to the specified window/target."));
	_hlp(i18n("If the <window/target> parameter is a window name"));
	_hlp(i18n("(eg. a channel,query or chat window with that name exists),"));
	_hlp(i18n("the effect of this command is the same"));
	_hlp(i18n("as typing <text> in that window."));
	_exa("/SAY $_status PRIVMSG #kaos : Byez");
	_exa("/SAY $_chan /RAW PRIVMSG #kaos : Byez");
	_hlp(i18n("The examples above will send the same raw data to the server."));
	_hlp(i18n("If the window can not be found (or it is NOT a channel,query or chat)"));
	_hlp(i18n("The <text> will be sent to the server as"));
	_hlp(i18n("MSG is an alias for this command"));
	_hlp(i18n("PRIVMSG <window/target> :<text>."));
	_debug_leavetrace("doHelpOnSay");
}
//============ doHelpOnAway ============//
void KviHelp::doHelpOnAway(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnAway");
	_cmd("AWAY BACK");
	_syn("AWAY [away-message]");
	_des;
	_hlp(i18n("Sets the away state.If no away-message is provided, the default one is used."));
	_syn("BACK");
	_des;
	_hlp(i18n("Removes the away state"));
	_debug_leavetrace("doHelpOnAway");
}
//============ doHelpOnTalk ============//
void KviHelp::doHelpOnTalk(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnTalk");
	_cmd("TALK");
	_syn("TALK <nickname>");
	_des;
	_hlp("Talk is an experimental DCC VOICE system.");
	_hlp("You can use it to talk with other KVirc users , ");
	_hlp("assuming that you have a soundcard and a microphone.");
	_hlp("Give it a try...and send some feedback to kvirc@tin.it.");
	_debug_leavetrace("doHelpOnTalk");
}
//============ doHelpOnNotice ============//
void KviHelp::doHelpOnNotice(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnNotice");
	_cmd("NOTICE");
	_syn("NOTICE <target-list> <text>");
	_des;
	_hlp(i18n("Sends the text to the specified targets in the NOTICE format."));
	_exa("/NOTICE Pragma You are added to my oplist now.");
	_exa("/NOTICE #kaos,Pragma,Drosha Please stop nuking me!"); 
	_see("SAY ME");
	_debug_leavetrace("doHelpOnNotice");
}
//============ doHelpOnHalt ============//
void KviHelp::doHelpOnHalt(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnHalt");
	_cmd("HALT");
	_syn("HALT");
	_des;
	_hlp(i18n("Stops the execution of a command (event or alias)."));
	_debug_leavetrace("doHelpOnHalt");
}
//============ doHelpOnConnstats ============//
void KviHelp::doHelpOnConnstats(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnConnstats");
	_cmd("CONNSTATS");
	_syn("CONNSTATS");
	_des;
	_hlp(i18n("Shows informations about the latset irc connection."));
	_debug_leavetrace("doHelpOnConnstats");
}
//============ doHelpOnReturn ============//

void KviHelp::doHelpOnReturn(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnReturn");
	_cmd("RETURN");
	_syn("RETURN <string data>");
	_hlp(i18n("This command can be executed only from an alias."));
	_hlp(i18n("It is used to return data to the caller function by means"));
	_hlp(i18n("of $%ext_alias[]."));
	_hlp(i18n("It will NOT block the execution of the command, it will"));
	_hlp(i18n("simply assign the current return value to the alias."));
	_hlp(i18n("In this way you can call it more than once in one alias."));
	_exa("if ($%str_find[$_mynick,$list.of.nicks])return $_true");
	_see("$%ext_alias");
	_debug_leavetrace("doHelpOnReturn");
}


//============ doHelpIndex ============//
void KviHelp::doHelpIndex(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpIndex");
	_cmd("INDEX");
	_hlp(i18n("This is a subset of topics available using the /HELP command"));
	_hlp(i18n("----------------- General informations-------------------"));
	_hlp("INDEX       COMMANDS    DEFINITIONS VARIABLES   FUNCTIONS");
	_hlp(i18n("------------------------Commands-------------------------"));
	_hlp("JOIN        PART        OP          DEOP        VOICE");
	_hlp("DEVOICE     BAN         UNBAN       KICK        SET");
	_hlp("UNSET       CTCP        CHAT        QUERY       IF");
	_hlp("WHILE       RAW         SEND        WHOIS       MODE");
	_hlp("USERLIST    CLONESCAN   ME          TIMER       EXEC");
	_hlp("RUN         KILLPROC    WRITEPROC   PROCLIST    ECHO");
	_hlp("PLAY        HALT        SAY         SERVER      NOTICE");
	_hlp("KBAN        WHOWAS      MSG         WINDOW      FOREACH");
	_hlp("DNS         ASCII       CACHE       MSG         AWAY");
	_hlp("BACK        RETURN      INC         DEC         SOUND");
	_hlp("FILE        ALIAS       TALK        LIST        CONNSTATS");
	_debug_leavetrace("doHelpIndex");
}
//============ doHelpOnFio ============//
void KviHelp::doHelpOnFio(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnFio");
	_cmd("$%fio_* FAMILY FUNCTIONS");
	_hlp(i18n("These functions will read or write data to a file previously open with the FILE command."));
	_hlp(i18n("$%fio_isopen[<file-identifier>] : returns $_true if the file referenced by"));
	_hlp(i18n("           the file identifier is open."));
	_hlp(i18n("$%fio_readln[<file-identifier>] : Reads the 'next' line from a file."));
	_hlp(i18n("$%fio_randln[<file-identifier>] : Reads a random line from the first 100 lines of a file."));
	_hlp(i18n("$%fio_writeln[<file-ident>,<data>] : Writes a line of data to a file."));
	_debug_leavetrace("doHelpOnFio");
}
//============ doHelpOnFile ============//
void KviHelp::doHelpOnFile(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnFile");
	_cmd("FILE");
	_syn("FILE [open|close|show] [file-identifer] [filename] [flags]");
	_des;
	_hlp(i18n("Performs operation on external files."));
	_hlp(i18n("FILE open [file-identifer] [filename] [ [read [circular]]| [write [truncate]]]"));
	_hlp(i18n("This will open an external file and assign it to the file identifer."));
	_hlp(i18n("That identifer must be used for next operations."));
	_hlp(i18n("You can check if the operation was succesfull using the $%fio_isopen function."));
	_hlp(i18n("flags:"));
	_hlp(i18n("read : will open the file in read only mode (default)."));
	_hlp(i18n("       Additionally 'circular' may be specifed to "));
	_hlp(i18n("       make possible circular reading : when you reach rhe end"));
	_hlp(i18n("       you start from the beginning."));
	_hlp(i18n("write: will open the file in write only mode."));
	_hlp(i18n("       If the file doesn't exist , it is created."));
	_hlp(i18n("       Additionally 'truncate' may be specified to truncate to zero length"));
	_hlp(i18n("       an existing file before writing."));
	_hlp(i18n("FILE close [file-identifier]"));
	_hlp(i18n("This will close a file."));
	_hlp(i18n("FILE show"));
	_hlp(i18n("This will print a list of currently open files."));
	_hlp(i18n("It is not a good idea to keep a file open for a long time."));
	_hlp(i18n("KVirc will automatically close the files that are not used "));
	_hlp(i18n("for longer than 5 minutes (however the file may be closed also "));
	_hlp(i18n("after 10 minutes if the internal timers doesn't match."));
	_debug_leavetrace("doHelpOnFile");
}
//============ doHelpOnSound ============//
void KviHelp::doHelpOnSound(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnSound");
	_cmd("SOUND");
	_syn("SOUND [target [soundfilename]]");
	_des;
	_hlp(i18n("Plays a sound to the given target (channel or nick)"));
	_hlp(i18n("Equivalent to sending CTCP SOUND <target>"));
	_debug_leavetrace("doHelpOnSound");
}
//============ doHelpOnDns ============//
void KviHelp::doHelpOnDns(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnDns");
	_cmd("DNS");
	_syn("DNS ( <hostname> | <ip> )");
	_des;
	_hlp(i18n("Performs a DNS query for the specified host or ip address."));
	_hlp(i18n("KVirc uses an external program (kvidns) to make the query."));
	_debug_leavetrace("doHelpOnDns");
}
//============ doHelpOnProc ============//
void KviHelp::doHelpOnProc(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnProc");
	_cmd("EXEC RUN KILLPROC WRITEPROC PROCLIST");
	_syn("EXEC      <commandline>");
	_syn("RUN       <commandline>");
	_syn("KILLPROC  ( all | <process-pid> )");
	_syn("WRITEPROC <process-pid>");
	_syn("PROCLIST");
	_des;
	_hlp(i18n("These functions will start|stop|or communicate with child processes."));
	_hlp(i18n("RUN       : Starts an EXTERNAL process. Once started the process lives its own life."));
	_exa("/RUN kedit README.txt");
	_hlp(i18n("EXEC      : Starts a CHILD process. The process runs 'with' KVIrc,"));
	_hlp(i18n("            and it will be terminated when KVIrc exits."));
	_hlp(i18n("            If the process outputs something to stdout or stderr, you will"));
	_hlp(i18n("            see it like in a shell."));
	_hlp(i18n("            It's also possible to write to stdin of this process."));
	_exa("/EXEC /bin/bash");
	_hlp(i18n("KILLPROC  : Kills a proces with a specified process id,"));
	_hlp(i18n("            or all processes if 'all' is specified instead of a pid."));
	_hlp(i18n("WRITEPROC : Writes to a process with the specified pid."));
	_hlp(i18n("            A <LF> character is appended to the input buffer."));
	_hlp(i18n("PROCLIST  : Lists all running child processes."));
	_hlp(i18n("Here is a short example of use of all these functions:"));
	_exa("/EXEC telnet localhost");
	_exa("# Starting process 'telnet localhost' with pid 7999");
	_exa("# [stdout 7999] : Trying 127.0.0.1...");
	_exa("# [stdout 7999] : Connected to localhost,escape character is....");
	_exa("# [stdout 7999] : Login :");
	_exa("/WRITEPROC 7999 root");
	_exa("# [stdin  7999] : root");
	_exa("# [stdout 7999] : Password :");
	_exa("/WRITEPROC 7999 mypassword");
	_exa("# [stdin  7999] : mypassword");
	_exa("# [stdout 7999] : Last login on tty4 on 12.4.2007 ...");
	_exa("# [stdout 7999] : [root@localhost root]");
	_exa("/PROCLIST");
	_exa("# Pid :7999 Commandline :telnet localhost");
	_exa("/KILLPROC 7999");
	_exa("# Process 7999 Killed.");
	_debug_leavetrace("doHelpOnProc");
}
//============ doHelpOnTimer ============//
void KviHelp::doHelpOnTimer(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnTimer");
	_cmd("TIMER");
	_syn("TIMER (start|stop|kill|list|shot) [name] [timeout] [command]");
	_des;
	_hlp(i18n("This command manages internal timers."));
	_hlp(i18n("START:"));
	_hlp(i18n("  Syntax: TIMER start <timer-name> <timeout-in-msec> <command>"));
	_hlp(i18n("  The start option will start an internal timer."));
	_hlp(i18n("  If a timer with the same name is already running it will be replaced."));
	_hlp(i18n("  The timeout must be specified in milliseconds , and the lower"));
	_hlp(i18n("  limit for that parameter is 100 msec."));
	_hlp(i18n("  Please note that many timers (or 2-3 timers with a short timeout)"));
	_hlp(i18n("  may slow down kvirc,especially if the command executed outputs"));
	_hlp(i18n("  text using the echo command."));
	_hlp(i18n("  The command parameter specifies the command to be executed when"));
	_hlp(i18n("  the timer 'fires'."));
	_exa("  TIMER start test_timer 10000 /echo $_window Timeout!!!");
	_hlp(i18n("  In this example the command will be created a timer with name"));
	_hlp(i18n("  test_timer and 10 seconds timeout."));
	_hlp(i18n("  NOTE : The identifiers in the command are parsed when the timer is created!"));
	_hlp(i18n("  The timer is 'connected' to the window where it is started."));
	_hlp(i18n("  If you start a timer in the #channel window (or start it in a command"));
	_hlp(i18n("  that is running 'in that window',each call to $_window or $_chan will"));
	_hlp(i18n("  return #channel."));
	_hlp(i18n("  If the window can not be found when the timer 'fires',"));
	_hlp(i18n("  the timer is automatically removed."));
	_hlp(i18n("SHOT:"))
	_hlp(i18n("  Syntax: TIMER shot <timeout> <command>"));
	_hlp(i18n("  This will create a timer that fires only once with the specified timeout."));
	_hlp(i18n("  Useful for example to perform temporaneous bans from popups : "));
	_hlp(i18n("  Popup command:"));
	_hlp(i18n("  kban $_selected 10 seconds ban!; timer shot 10000 /unban $_selected"));
	_hlp(i18n("STOP:"));
	_hlp(i18n("  Syntax: TIMER stop <timer-name>"));
	_hlp(i18n("  The stop option will remove an internal timer."));
	_hlp(i18n("  If the timer is not running,it will do nothing."));
	_exa("  TIMER stop test_timer");
	_hlp(i18n("LIST:"));
	_hlp(i18n("  Syntax: TIMER list"));
	_hlp(i18n("  This will print a list of currently active timers."));
	_hlp(i18n("KILL:"));
	_hlp(i18n("  Syntax: TIMER kill"));
	_hlp(i18n("  This will stop ALL the active timers."));
	_debug_leavetrace("doHelpOnTimer");
}
//============ doHelpOnMe ============//
void KviHelp::doHelpOnMe(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnMe");
	_cmd("ME");
	_syn("ME <text>");
	_des;
	_hlp(i18n("This command is used to describe an action/feeling to the channel."));
	_hlp(i18n("It can be used in channel , query or DCC Chat windows."));
	_hlp(i18n("Equivalent to /CTCP ACTION #channel <text>."));
	_see("CTCP"); 
	_debug_leavetrace("doHelpOnMe");
}
//============ doHelpOnCommands ============//
void KviHelp::doHelpOnCommands(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnCommands");
	_cmd("COMMANDS");
	_hlp(i18n("KVirc treates as a <command> any sequence of characters that you type in"));
	_hlp(i18n("the commandline box of a <child> window, and that starts with a '/'"));
	_hlp(i18n("Everything else is treated in the following way:"));
	_hlp(i18n("- All the <non-commands> typed in the status cosole window are sent to"));
	_hlp(i18n("  the current server,exactly as they are...(In RAW format)"));
	_hlp(i18n("- All the <non-commands> typed in a channel window are sent to"));
	_hlp(i18n("  the server as 'privmsg #channel <non-command>' (talk to channel)"));
	_hlp(i18n("- All the <non-commands> typed in a query window are sent to"));
	_hlp(i18n("  the server as 'privmsg <query-nickname>' (talk to the query)"));
	_hlp(i18n("- All the <non-commands> typed in a chat window are sent through"));
	_hlp(i18n("  the corresponding DCC connection (if any)"));
	_hlp(i18n("- All the <non-commands> typed in a user created window are handled by"));
	_hlp(i18n("  the Event_OnUserWndInput event."));
	_hlp(i18n("General command syntax:"));
	_hlp(i18n("KVirc uses an extended commandline syntax, that allows you to execute"));
	_hlp(i18n("more commands in sequence (pipe)."));
	_hlp(i18n("- A sequence of commands MUST start with a '/' (as described above)"));
	_hlp(i18n("- The commands are separated by a ';'"));
	_hlp(i18n("- The last command may not contain the trailing ';'"));
	_hlp(i18n("- The commands are NOT case sensitive"));
	_hlp(i18n("Here are some examples of simple valid commandlines:"));
	_exa("/JOIN #channel");
	_exa("/JOIN #channel;");
	_exa("/jOiN #channel;PART #channel");
	_exa("/join #channel,#channel2,#channel3;SAY #channel2 What's on?;PART #channel3");
	_hlp(i18n("- The commands can be grouped by block separators ('<' and '>'),"));
	_hlp(i18n("  and the closing block separator must be followed by a ';',"));
	_hlp(i18n("  as a normal command."));
	_exa("/JOIN #channel;< Part #channel; >");
	_exa("/< join &errors;PART &servers; >;JOIN &debug");
	_see("DEFINITIONS");
	_debug_leavetrace("doHelpOnCommands");
}
//============ doHelpOnDefs ============//
void KviHelp::doHelpOnDefs(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnDefs");
	_cmd("DEFINITIONS");
	_hlp(i18n("This topic describes some parts of the grammar used by KVirc"));
	_hlp(i18n("You will find it useful when reading syntax of commands."));
	_hlp(i18n("---General rules---"));
	_hlp(i18n("The grammar productions are described using the following syntax:"));
	_hlp(i18n("<left-part>    ::= 'right-part' | 'alternative' | ..."));
	_hlp(i18n("the one above means that the non-terminal symbol <left-part>"));
	_hlp(i18n("is replaced  by 'right-part' (that can be terminal or not...)"));
	_hlp(i18n("or by the 'alternative'."));
	_hlp(i18n("<left-part>    ::= c[ x ] | d( a | b )"));
	_hlp(i18n("the one above means that <left-part> can be replaced by"));
	_hlp(i18n("'c' that CAN be followed by a 'x' ,"));
	_hlp(i18n("or by a 'd' that MUST be followed by a 'a' or a 'b'."));
	_hlp(i18n("--------------------"));
	_hlp(i18n("<string>        ::= any non empty sequence of characters without spaces"));
	_hlp(i18n("<channel>       ::= ( # | & )<string>"));
	_hlp(i18n("<nick>          ::= <string>"));
	_hlp(i18n("<channel-list>  ::= <channel>[,<channel-list>]"));
	_hlp(i18n("<nick-list>     ::= <nick>[,<nick>]"));
	_hlp(i18n("<variable>      ::= $<string>"));
	_hlp(i18n("<sys-variable>  ::= $_<string>"));
	_hlp(i18n("<sys_identifier>::= $%<prefix>_<string>"));
	_debug_leavetrace("doHelpOnDefs");
}
//============ doHelpOnJoin ============//
void KviHelp::doHelpOnJoin(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnJoin");
	_cmd("JOIN");
	_syn("JOIN <channel-list>");
	_des;
	_hlp(i18n("Joins channel(s)."));
	_exa("JOIN #kaos,#linux,#kvirc");
	_see("PART");
	_debug_leavetrace("doHelpOnJoin");
}
//============ doHelpOnPlay ============//
void KviHelp::doHelpOnPlay(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnPlay");
	_cmd("PLAY");
	_syn("PLAY [file-name]");
	_des;
	_hlp(i18n("This command plays a sound file."));
	_hlp(i18n("If <file-name> is specified,"));
	_hlp(i18n("if it contains a '/' it is assumed to be"));
	_hlp(i18n("an absolute path , else KVIrc will look for that file"));
	_hlp(i18n("in the $HOME/kvirc/Audio directory and after in $HOME/kvirc/Scripts/Audio."));
	_debug_leavetrace("doHelpOnPlay");
}
//============ doHelpOnPart ============//
void KviHelp::doHelpOnPart(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnPart");
	_cmd("PART");
	_syn("PART <channel-list> <part-message-text>");
	_des;
	_hlp(i18n("Leaves channel(s) sending the specified part message."));
	_hlp(i18n("If no message is specified, the default message is used."));
	_exa("PART #kaos,#linux,#kvirc Byez people!");
	_exa("PART $_allchans $_version");
	_see("JOIN");
	_debug_leavetrace("doHelpOnPart");
}
//============ doHelpOnOpDeop ============//
void KviHelp::doHelpOnOpDeop(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnOpDeop");
	_cmd("OP DEOP VOICE DEVOICE BAN UNBAN");
	_syn("OP    [channel] <nick-list>     DEOP    [channel] <nick-list>");
	_syn("VOICE [channel] <nick-list>     DEVOICE [channel] <nick-list>");
	_syn("BAN   [channel] <mask-list>     UNBAN   [channel] <mask-list>");
	_des;
	_hlp(i18n("Changes mode on a specified channel."));
	_hlp(i18n("Op sets mode +o for each nick in the nick list"));
	_hlp(i18n("Deop sets mode -o,voice and devoice : +v and -v"));
	_hlp(i18n("Ban and unban sets modes +b and -b for each mask in the mask-list"));
	_hlp(i18n("The channel parameter is optional when the command is executed in"));
	_hlp(i18n("a channel window."));
	_hlp(i18n("These six commands are optimized for speed and efficience:"));
	_hlp(i18n("when more than one nicks (or masks) are provided,KVIrc will use"));
	_hlp(i18n("the extended MODE command syntax, using multiple mode changes in"));
	_hlp(i18n("one message to server.(up to three)"));
	_exa("OP #kaos Pragma,Ventur,Mixo   <---Ops three nicks : One message to server");
	_exa("BAN Ventur!*@*,turk187!*@*,Mixo!*@*,Diabl0!*@* <---Bans 4 masks on the current");
	_exa("                                                   channel. Two messages");
	_debug_leavetrace("doHelpOnOpDeop");
}
//============ doHelpOnKick ============//
void KviHelp::doHelpOnKick(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnKick");
	_cmd("KICK");
	_syn("KICK [channel] <nick-list> [kick-reason]");
	_des;
	_hlp(i18n("Kicks user(s) from a channel using the specified reason."));
	_hlp(i18n("If no reason is specified, the default one is used."));
	_hlp(i18n("The channel parameter is optional when executed from a channel window."));
	_exa("KICK $_chan Ventur,Diabl0 Go sit in a corner...");
	_debug_leavetrace("doHelpOnKick");
}
//============ doHelpOnSet ============//
void KviHelp::doHelpOnSet(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnSet");
	_cmd("SET");
	_syn("SET <variable> <value>");
	_des;
	_hlp(i18n("Sets a variable value. Note that the <value> is treated as a string."));
	_see("DEFINITIONS UNSET");
	_debug_leavetrace("doHelpOnSet");
}
//============ doHelpOnUnset ============//
void KviHelp::doHelpOnUnset(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnUnset");
	_cmd("UNSET");
	_syn("UNSET <variable>");
	_des;
	_hlp(i18n("Unsets a variable.If the variable was not set,this command does nothing."));
	_see("DEFINITIONS SET");
	_debug_leavetrace("doHelpOnUnset");
}
//============ doHelpOnCtcp ============//
void KviHelp::doHelpOnCtcp(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnCtcp");
	_cmd("CTCP");
	_syn("CTCP <type> <target-list> [ctcp-arguments]");
	_des;
	_hlp(i18n("Sends a specified CTCP type to the specified user(s)."));
	_hlp(i18n("CTCP Types:"));
	_hlp(i18n("PING       : pings a user in order to have his response time."));
	_hlp(i18n("VERSION    : requests user's client version."));
	_hlp(i18n("TIME       : requests user's local time."));
	_hlp(i18n("CLIENTINFO : requests user's client informations."));
	_hlp(i18n("USERIFON   : requests user's informations."));
	_hlp(i18n("FINGER     : requests user's finger."));
	_hlp(i18n("ACTION     : describes an action."));
	_hlp(i18n("SOURCE     : requests informationf on where to find the user's client."));
	_hlp(i18n("These are the known CTCP types , but if you want you can"));
	_hlp(i18n("use any CTCP type name."));
	_hlp(i18n("CTCP CIAO Nick is a valid CTCP, but maybe you will receive no response :)"));
	_hlp(i18n("A target may be a either a nick or a channel."));
	_hlp(i18n("The ctcp arguments are intended for the extended ctcp's..."));
	_hlp(i18n("You can send a '/ctcp cdcc list' to someone by typing:"));
	_exa("/ctcp cdcc target_nickname list");
	_see("CHAT SEND");
	_debug_leavetrace("doHelpOnCtcp");
}
//============ doHelpOnQuery ============//
void KviHelp::doHelpOnQuery(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnQuery");
	_cmd("QUERY");
	_syn("QUERY <nick-list>");
	_des;
	_hlp(i18n("Opens a query window for the specified user(s)."));
	_see("CHAT");
	_debug_leavetrace("doHelpOnQuery");
}
//============ doHelpOnChat ============//
void KviHelp::doHelpOnChat(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnChat");
	_cmd("CHAT");
	_syn("CHAT <nick-list>");
	_des;
	_hlp(i18n("Requests a DCC CHAT from the specified user(s)."));
	_see("QUERY SEND");
	_debug_leavetrace("doHelpOnChat");
}
//============ doHelpOnIf ============//
void KviHelp::doHelpOnIf(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnIf");
	_cmd("IF WHILE");
	_syn("IF    (<boolean-expression>) <command1>; [else <command2> ;]");
	_syn("WHILE (<boolean-expression>) <command>");
	_des;
	_hlp(i18n("IF :Conditional expression."));
	_hlp(i18n("If <boolean-expression> evaluates to 'true' (see below) the <command1>"));
	_hlp(i18n("is executed , otherwise (if given) command2 is executed."));
	_hlp(i18n("The <boolean-expression> is assumed to be 'false' if the result"));
	_hlp(i18n("of 'calculations' in that expression is 0 , $_false , $_null or an empty string"));
	_hlp(i18n("Every other result evaluates to 'true'."));
	_exa("if ( $_true ) echo $_window Evaluates to true.");
	_exa("if ( $_null ) echo $_window Never executed ; else echo $_window Evaluates to false.");
	_exa("if ( test   ) echo $_window Evaluates to true.");
	_hlp(i18n("The boolean expression can contain boolean operators: ! , & , |"));
	_hlp(i18n("! = LOGICAL UNARY NOT    & = LOGICAL BINARY AND  | = LOGICAL BINARY OR"));
	_exa("if ( !$_null ) echo $_window Evaluates to true.");
	_exa("if ( $_true | $_false ) echo $_window Evaluates to true.");
	_exa("if ( !$_false & $_true ) echo $_window Evaluates to true.");
	_hlp(i18n("Complex boolean expressions MUST be enclosed in parenthesis."));
	_exa("if ( ( $_false | true ) & !$_false) echo $_windwo Evaluates to true."); 
	_hlp(i18n("NOTE That there MUST be a <SPACE> between the if command and the parenthesis."));
	_hlp(i18n("WHILE :Conditional iteration."));
	_hlp(i18n("While <boolean-expression> evaluates to true the <command> is executed."));
	_hlp(i18n("Apply the same rules as the if command."));
	_exa("/WHILE ($%box_yesno[Continue?]) echo $_window Continuing...;"); 
	_debug_leavetrace("doHelpOnIf");
}
//============ doHelpOnForeach ============//
void KviHelp::doHelpOnForeach(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnForeach");
	_cmd("FOREACH");
	_syn("FOREACH (<variable>,<string-list>) <command>");
	_des;
	_hlp(i18n("Foreach si a loop similar to while , but has no conditional expression."));
	_hlp(i18n("It is used to perform repeated commands on a list of arguments."));
	_exa("/FOREACH ($name,John,Ronnie,Marta,Sammy) echo $_window $name is hungry");
	_hlp(i18n("The above example will repeat the 'echo' command 4 times,"));
	_hlp(i18n("one time 'for each' name in the list."));
	_hlp(i18n("The <string-list> can be also a variable."));
	_hlp(i18n("You will find it useful when writing aliases and popups."));
	_hlp(i18n("In a popup you can have multiple selections that are returned"));
	_hlp(i18n("by $_selected in a from of a comma-separated list."));
	_exa("...In a popup handler : Mass Bye");
	_exa("/foreach ($nickname,$_selected) say $_nickname Bye!,I'm going sleep");
	_hlp(i18n("This will say 'Bye!,I'm going sleep' to each nickname selected in the nick list."));
	_hlp(i18n("$nickname in this case is a VARIABLE that is set when the command begins,"));
	_hlp(i18n("updated each time the loop is repeated and unset when the command finishes."));
	_hlp(i18n("WARNING : The variables are always unique to kvirc, that means that is"));
	_hlp(i18n("you call a function in <command> that uses a variable with a similar name"));
	_hlp(i18n("and changes its contents or unsets it,the remaining part of the <command>"));
	_hlp(i18n("Will see the changed variable!"));
	_hlp(i18n("This may be dangerous , when using recursive functions. Be careful with that."));
	_see("SET UNSET");
	_debug_leavetrace("doHelpOnForeach");
}
//============ doHelpOnEcho ============//
void KviHelp::doHelpOnEcho(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnEcho");
	_cmd("ECHO");
	_syn("ECHO <window-name> <text>");
	_des;
	_hlp(i18n("Outputs th <text> to the specified window."));
	_debug_leavetrace("doHelpOnEcho");
}
//============ doHelpOnRaw ============//
void KviHelp::doHelpOnRaw(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnRaw");
	_cmd("RAW");
	_syn("RAW [-s] <command>");
	_des;
	_hlp(i18n("Sends a raw command to the server."));
	_hlp(i18n("You may use if to perform commands that are not implemented yet in kvirc"));
	_hlp(i18n("The -s switch will cause kvirc to not display the text sent to server."));
	_exa("RAW KILL Gregor :Stop flooding!");
	_debug_leavetrace("doHelpOnRaw");
}
//============ doHelpOnSend ============//
void KviHelp::doHelpOnSend(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnSend");
	_cmd("SEND");
	_syn("SEND <nick-list> [file-name]");
	_des;
	_hlp(i18n("Requests a DCC SEND to the specified user(s)."));
	_hlp(i18n("If the file name is not provided, a file dialog will popup."));
	_see("CHAT");
	_debug_leavetrace("doHelpOnSend");
}
//============ doHelpOnWhois ============//
void KviHelp::doHelpOnWhois(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnWhois");
	_cmd("WHOIS WHOWAS");
	_syn("WHOIS [[server]|[-i]] <nick-list>");
	_syn("WHOWAS <nick-list> [ count [server] ]");
	_des;
	_hlp(i18n("Requests informations on the specified user(s)."));
	_hlp(i18n("If the server parameter is provided, the request is"));
	_hlp(i18n("redirected to that server.(Useful to know the idle time)"));
	_hlp(i18n("If you don't know the server that nick is connected to"));
	_hlp(i18n("You can pass the -i flag that will be substituted"));
	_hlp(i18n("by the server that is used by the first nick in the <nick-list>"));
	_hlp(i18n("In the whowas command the count param describes the number of"));
	_hlp(i18n("matching records that the server may return."));
	_exa("WHOIS irc.stealth.net Gizmo");
	_exa("WHOWAS Gizmo 3 irc.stealth.net");
	_debug_leavetrace("doHelpOnWhois");
}
//============ doHelpOnKban ============//
void KviHelp::doHelpOnKban(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnKban");
	_cmd("KBAN");
	_syn("KBAN [channel] <nick-list> [kick-reason]");
	_des;
	_hlp(i18n("Kicks and bans the specified user(s) from a channel."));
	_hlp(i18n("This command is provided for convenience (just to be fast..."));
	_hlp(i18n("The channel parameters is optional when executed from a channel window."));
	_hlp(i18n("KVIrc uses no ban-mask in this case:the commands sent"));
	_hlp(i18n("to server for each nick are:"));
	_hlp(i18n("  KICK <channel> <nick> <reason>"));
	_hlp(i18n("  MODE <channel> +b <nick>"));
	_hlp(i18n("On most irc server this results in a nick!*@* ban."));
	_hlp(i18n("If no reason is provided , the default one is used."));
	_see("KICK MODE BAN");
	_debug_leavetrace("doHelpOnKban");
}
//============ doHelpOnMode ============//
void KviHelp::doHelpOnMode(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnMode");
	_cmd("MODE");
	_syn("MODE ( <channel>|<nick> ) <mode> [mode-params]");
	_des;
	_hlp(i18n("This is just the RFC1459 mode command implementation."));
	_see("OP VOICE BAN");
	_debug_leavetrace("doHelpOnMode");
}
//============ doHelpOnUserlist ============//
void KviHelp::doHelpOnUserlist(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnUserlist");
	_cmd("USERLIST");
	_syn("USERLIST [channel] [nick-list]");
	_des;
	_hlp(i18n("Shows internal channel user list entries for the specified user(s)."));
	_hlp(i18n("The channel parameter is optional when executed from a channel window."));
	_hlp(i18n("If no nick-list is provided,the entire userlist is shown.")); 
	_debug_leavetrace("doHelpOnUserlist");
}
//============ doHelpOnClonscan ============//
void KviHelp::doHelpOnClonescan(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnClonescan");
	_cmd("CLONESCAN");
	_syn("CLONESCAN [channel] [nick-list]");
	_des;
	_hlp(i18n("Searches for clones of the specified user(s) on a channel."));
	_hlp(i18n("The channel parameter is optional when executed from a channel window."));
	_hlp(i18n("If no nick-list is provided,a global clonescan is done.")); 
	_hlp(i18n("Note that CLONE means : a user with the same host address."));
	_debug_leavetrace("doHelpOnClonescan");
}
//============ doHelpOnIdent ============//
void KviHelp::doHelpOnIdent(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnIdent");
	_cmd("FUNCTIONS");
	_hlp(i18n("The fuctions are a kind of <internal-identifiers>."));
	_hlp(i18n("A function is always prefixed with '$%'"));
	_hlp(i18n("and has the first three letters identyfying a function group"));
	_hlp(i18n("<function> ::= $%<name>'['<parameter list>']"));
	_hlp(i18n("INTERNAL FUNCTIONS LIST"));
	_hlp(i18n("Channel functions"));
	_hlp(i18n("$%chn_allonchan $%chn_oponchan   $%chn_voiceonchan $%chn_noponchan"));
	_hlp(i18n("$%chn_count     $%chn_opcount    $%chn_nopcount    $%chn_voicecount"));
	_hlp(i18n("$%chn_topic     $%chn_mode"));
	_hlp(i18n("Nick functions"));
	_hlp(i18n("$%nck_maskX     $%nck_ison       $%nck_isop        $%nck_address"));
	_hlp(i18n("$%nck_isvoice   $%nck_isme       $%nck_match"));
	_hlp(i18n("Dialog boxes (user input functions)"));
	_hlp(i18n("$%box_yesno     $%box_input      $%box_openfile    $%box_savefile"));
	_hlp(i18n("$%box_ok"));
	_hlp(i18n("Window functions"));
	_hlp(i18n("$%wnd_ischan    $%wnd_ischat     $%wnd_isquery     $%wnd_isstatus"));
	_hlp(i18n("$%wnd_issend    $%wnd_isuserwnd"));
	_hlp(i18n("String functions"));
	_hlp(i18n("$%str_nequal    $%str_length     $%str_upper       $%str_lower"));
	_hlp(i18n("$%str_isin      $%str_find       $%str_left        $%str_right"));
	_hlp(i18n("$%str_equal     $%str_chr        $%str_isnum"));
	_hlp(i18n("List managing functions"));
	_hlp(i18n("$%lst_prepend   $%lst_append      $%lst_count      $%lst_remove"));
	_hlp(i18n("$%lst_item      $%lst_find        $%lst_contains"));
	_hlp(i18n("Numeric comparison functions"));
	_hlp(i18n("$%cmp_gt        $%cmp_lt         $%cmp_elt         $%cmp_eq"));
	_hlp(i18n("$%cmp_egt"));
	_hlp(i18n("Calculus functions"));
	_hlp(i18n("$%cal_add       $%cal_sub        $%cal_mul         $%cal_div"));
	_hlp(i18n("$%cal_and       $%cal_or         $%cal_xor         $%cal_mod"));
	_hlp(i18n("$%cal_not       $%cal_shl        $%cal_shr"));
	_hlp(i18n("File I/O functions"));
	_hlp(i18n("$%fio_isopen    $%fio_readln     $%fio_randln      $%fio_writeln"));
	_hlp(i18n("Other functions"));
	_hlp(i18n("$%ext_alias     $%ext_dynamic    $%ext_isset       $%ext_ismeop"));
	_hlp(i18n("$%ext_istimer"));
	_see("VARIABLES IF ECHO");
	_debug_leavetrace("doHelpOnIdent");
}
//============ doHelpOnCal ============//
void KviHelp::doHelpOnCal(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnCal");
	_cmd("$%cal_* FAMILY FUNCTIONS");
	_hlp(i18n("Used to perform calculations on INTEGER numbers"));
	_hlp(i18n("The maximum (and minimum) number interpretable depends on the size"));
	_hlp(i18n("in bits of the long type on your machine."));
	_hlp(i18n("These functions will always return $_null if the operands are not numbers,"));
	_hlp(i18n("or one of the operands is not in the valid range."));
	_hlp(i18n("$%cal_add[n1,n2] : returns the result of n1+n2"));
	_hlp(i18n("$%cal_sub[n1,n2] : returns the result of n1-n2"));
	_hlp(i18n("$%cal_mul[n1,n1] : returns the result of n1*n2"));
	_hlp(i18n("$%cal_div[n1,n2] : returns the result of n1/n2 , or 0 if n2=0"));
	_hlp(i18n("$%cal_mod[n1,n2] : returns the result of n1 mod n2"));
	_hlp(i18n("$%cal_and[n1,n2] : returns the result of (bitwise) n1 and n2"));
	_hlp(i18n("$%cal_or[ n1,n2] : returns the result of (bitwise) n1 or n2"));
	_hlp(i18n("$%cal_not[n1]    : returns the result of (bitwise) not n1"));
	_hlp(i18n("$%cal_xor[n1,n2] : returns the result of (bitwise) n1 xor n2"));
	_hlp(i18n("$%cal_shl[n1,n2] : returns the result of n1 shift left n2"));
	_hlp(i18n("$%cal_shr[n1,n2] : returns the result of n1 shift right n2"));
	_hlp(i18n("Some of these functions may be unuseful for a script..like shl or xor.."));
	_hlp(i18n("I've implemented it just for fun."));
	_debug_leavetrace("doHelpOnCal");
}
//============ doHelpOnCmp ============//
void KviHelp::doHelpOnCmp(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnCmp");
	_cmd("$%cmp_* FAMILY FUNCTIONS");
	_hlp(i18n("The cmp family functions perform comparisons between numbers"));
	_syn(i18n("$%cmp_comparisontype[number1,number2]"));
	_des;
	_hlp(i18n("$%cmp_gt[num1,num2]  : Returns true if num1  > num2."));
	_hlp(i18n("$%cmp_lt[num1,num2]  : Returns true if num1  < num2."));
	_hlp(i18n("$%cmp_eq[num1,num2]  : Returns true if num1  = num2."));
	_hlp(i18n("$%cmp_egt[num1,num2] : Returns true if num1 >= num2."));
	_hlp(i18n("$%cmp_elt[num1,num2] : Returns true if num1 <= num2."));
	_hlp(i18n("Note that if num1 or num2 are NOT numbers (after variable evaluation)"));
	_hlp(i18n("these functions will return $_null that is a correct boolean"));
	_hlp(i18n("operand : always false , but if you want "));
	_hlp(i18n("you can check for errors in this way."));
	_hlp(i18n("Note also that $_null is NOT a number in KVirc."));
	_debug_leavetrace("doHelpOnCmp");
}


//============ doHelpOnLst ============//
void KviHelp::doHelpOnLst(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnLst");
	_cmd("$%lst_* FAMILY FUNCTIONS");
	_hlp(i18n("The $%lst_* functions perform operation on comma separated lists"));
	_des;
	_syn("$%lst_count[<string-list>]");
	_hlp(i18n("  Returns the number of items in the list."));
	_hlp(i18n("  There are not items when the string is equal to $_null"));
	_syn("$%lst_prepend[<string>,<string-list>]");
	_hlp(i18n("  Inserts the <string> as the first item of the list."));
	_syn("$%lst_append[<string>,<string-list>]");
	_hlp(i18n("  Inserts the <string> as the last item of the list."));
	_syn("$%lst_remove[<string-item>,<string-list>]");
	_hlp(i18n("  Removes the first occurence of <string-item> in the list."));
	_syn("$%lst_item[<index>,<string-list>]");
	_hlp(i18n("  Returns the item in the string-list at position <index>"));
	_hlp(i18n("  or $_null if the index is out of range."));
	_hlp(i18n("  Note that <index> is zero based."));
	_syn("$%lst_find[<item>,<string-list>]");
	_hlp(i18n("  Returns the zero-based index of the <item> in the <string-list>"));
	_hlp(i18n("  or $_null if the <item> can not be found"));
	_syn("$%lst_contains[<item>,<string-list>]");
	_hlp(i18n("  Returns $_true if the <item> is in the <string-list>,"));
	_hlp(i18n("  $_false otherwise"));
	_debug_leavetrace("doHelpOnLst");
}
//============ doHelpOnStr ============//
void KviHelp::doHelpOnStr(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnStr");
	_cmd("$%str_* FAMILY FUNCTIONS");
	_hlp(i18n("The $%str_* functions return informations about strings."));
	_des;
	_syn("$%str_equal[<string1>,<string2>]");
	_hlp(i18n("  Compares two strings ignoring case.Returns $_true if the strings are equal."));
	_syn("$%str_nequal[<string1>,<string2>]");
	_hlp(i18n("  Same as above but returns $_false if the strings are equal."));
	_syn("$%str_length[<string>]");
	_hlp(i18n("  Returns the length of the string."));
	_syn("$%str_upper[<string>]");
	_syn("$%str_lower[<string>]");
	_hlp(i18n("  Transform string to upper or lower case."));
	_syn("$%str_isin[<substring>,<string>]");
	_hlp(i18n("  Returns true if <substring> is found in <string>"));
	_syn("$%str_find[<substring>,<string>]");
	_hlp(i18n("  Returns the index (zero based) of the first <substring>"));
	_hlp(i18n("  found in string. Returns $_null if the <substring> is not found."));
	_syn("$%str_left[<length>,<string>]");
	_syn("$%str_right[<length>,<string>]");
	_hlp(i18n("  Returns a substring of <string> formed by the <length> characters"));
	_hlp(i18n("  of the left (or right) part of the string."));
	_syn("$%str_chr[<number>,<number>,....]");
	_hlp(i18n("  Returns a string composed by the ascii characters referred by <ascii-number>"));
	_hlp(i18n("  $%str_chr[67,65,83,65] will return 'CASA'"));
	_hlp(i18n("  $%str_chr[L,105,110,ux is, ,103,114,eat] will return 'Linux is great'"));
	_syn("$%str_isnum[<string>]");
	_hlp(i18n("  Returns $_true if the <string> is a valid number."));
	_hlp(i18n("  $%str_isnum[100] will return $_true."));
	_hlp(i18n("  $%str_isnum[290g] will return $_false."));
	_debug_leavetrace("doHelpOnStr");
}
//============ doHelpOnIs ============//
void KviHelp::doHelpOnIs(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnIs");
	_cmd("$%wnd_* FAMILY FUNCTIONS");
	_hlp(i18n("The $%wnd_* functions will return informations on the window names."));
	_syn("$%wnd_functionname[<window name>]");
	_des;
	_hlp(i18n("$%wnd_ischan   : Returns $_true if <window> is a channel window"));
	_hlp(i18n("                 $_false otherwise."));
	_hlp(i18n("$%wnd_ischat   : Returns $_true if <window> is a DCC Chat window."));
	_hlp(i18n("$%wnd_isquery  : Same as above but for query windows."));
	_hlp(i18n("$%wnd_issend   : Same as above but for DCC SEND/GET windows."));
	_hlp(i18n("$%wnd_isstatus : Same as above but for the Status window."));
	_hlp(i18n("$%wnd_isuserwnd: Same as above but for User created windows."));
	_hlp(i18n("Note that all these functions will return $_null if the window can not be found."));
	_debug_leavetrace("doHelpOnIs");
}
//============ doHelpOnCh ============//
void KviHelp::doHelpOnChn(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnCh");
	_cmd("$%chn_* FAMILY FUNCTIONS");
	_hlp(i18n("The $%chn_* functions will return informations on a channel."));
	_syn("$%chn_functionname[<channel>]");
	_des;
	_hlp(i18n("$%chn_opcount    : Returns the number of operators on the channel."));
	_hlp(i18n("$%chn_voicecount : Returns the number of voiced users on the channel."));
	_hlp(i18n("$%chn_count      : Returns the total number of users on the channel."));
	_hlp(i18n("$%chn_nopcount   : Returns the number of non-operators on the channel."));
	_hlp(i18n("$%chn_allonchan  : Returns a list of nicknames that are on the channel."));
	_hlp(i18n("$%chn_oponchan   : Returns a list of operators that are on the channel."));
	_hlp(i18n("$%chn_voicechan  : Returns a list of voiced users..."));
	_hlp(i18n("$%chn_noponchan  : Returns a list of non-operators..."));
	_hlp(i18n("$%chn_topic      : Returns the current channel topic"));
	_hlp(i18n("$%chn_mode       : Returns a string containing the current channel mode."));

	_hlp(i18n("Note : the functions returning a list of strings are limited to 400 characters."));
	_hlp(i18n("All the functions will return $_null if you are NOT on the channel specified."));
	_debug_leavetrace("doHelpOnCh");
}
//============ doHelpOnNk ============//
void KviHelp::doHelpOnNk(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnNk");
	_cmd("$%nck_* FAMILY FUNCTIONS AND RELATED");
	_hlp(i18n("The $%nck_* functions will return informations on a user that is on a specified channel."));
	_syn("$%nck_functionname[<channel>,<nick>]");
	_syn("Special case : $%nck_isme[<nickname or mask>]");
	_syn("             : $%nck_match[<channel>,<mask>]");
	_des;
	_hlp(i18n("$%nck_address    : Returns the nick address that is stored in the INTERNAL ADDRESS LIST"));
	_hlp(i18n("                   Note that if the list is not complete (or not enabled) the result will"));
	_hlp(i18n("                   be $_null."));
	_hlp(i18n("$%nck_ison       : Returns $_true if the nick is on the channel."));
	_hlp(i18n("$%nck_isop       : Returns $_true if the nick is an operator on the channel."));
	_hlp(i18n("$%nck_isvoice    : Returns $_true if the nick have the +v flag."));
	_hlp(i18n("$%nck_maskX      : Return the mask (of type X) of the nick."));
	_hlp(i18n("                   Currently masks from 0 to 8 are allowed."));
	_hlp(i18n("mask types:"));
	_hlp(i18n("0  : Nick!User@host.domain.top"));
	_hlp(i18n("1  : User@host.domain.top"));
	_hlp(i18n("2  : Nick!*@host.domain.top"));
	_hlp(i18n("3  : *!User@host.domain.top"));
	_hlp(i18n("4  : Nick!*@*"));
	_hlp(i18n("5  : *!*@*.domain.top       (or *!*@xxx.xxx.xxx.*)"));
	_hlp(i18n("6  : *!User@*.domain.top    (or *!User@xxx.xxx.xxx.*)"));
	_hlp(i18n("7  : Nick!User@*.domain.top (or Nick!User@xxx.xxx.xxx.*)"));
	_hlp(i18n("8  : Nick!*@*.domain.top    (or Nick!*@xxx.xxx.xxx.*)"));
	_exa("if ($%nck_ison[#kaos,turk187]) ban $%nck_mask7[#kaos,turk187]");
	_hlp(i18n("Note1 : the nck_isop and nk_isvoice functions will return $_null if the nick"));
	_hlp(i18n("        is NOT on the channel."));
	_hlp(i18n("Note2 : the nck_maskX,like nck_address, uses the Internal Address List,"));
	_hlp(i18n("        If the list is not complete for the channel requested, the result may be"));
	_hlp(i18n("        something as Nick!$_null@$_null..."));
	_hlp(i18n("        Note also that if a user is on two channels and in the second one the user list"));
	_hlp(i18n("        is not complete, nck_maskX on the first channel will return the full mask"));
	_hlp(i18n("        and on the second channel will return some $_null strings.."));
	_hlp(i18n("$%nck_isme  : Evaluates to true if the nick is your current nick"));
	_hlp(i18n("          or the mask matches your mask."));
	_hlp(i18n("$%nck_match : Returns a list of nicks that match the <mask>"));
	_debug_leavetrace("doHelpOnNk");
}
//============ doHelpOnExt ============//
void KviHelp::doHelpOnExt(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnExt");
	_cmd("$%ext_* FAMILY FUNCTIONS");
	_hlp(i18n("These functions are used in advanced kvirc script programming."));
	_hlp(i18n("You may find it useful in complex scripts.(Be careful using it:)"));
	_syn("$%ext_alias[<alias name> [alias parameters]]");
	_hlp(i18n("This function executes a specified alias, and"));
	_hlp(i18n("gives back its return value (assigned by the RETURN command)."));
	_hlp(i18n("If the alias not uses the RETURN command,"));
	_hlp(i18n("the return value will be $_null."));
	_hlp(i18n("If the alias can not be found, a waring message will"));
	_hlp(i18n("be displayed (without breaking the execution)"));
	_hlp(i18n("and the return value will be set to $_null."));
	_syn("$%ext_dynamic[<complex-variable>]");
	_hlp(i18n("This function is used to create complex variables,such as"));
	_hlp(i18n("$Section.$Key , where $Section is the name of the variable"));
	_hlp(i18n("and $Key is another variable that 'dynamically' changes the"));
	_hlp(i18n("name of the first one."));
	_hlp(i18n("Example:Event_OnMeOp - $1 contains the channel name (ex: #kaos),"));
	_hlp(i18n("$2 contains the nick that 'oped' us.(ex: infected)"));
	_hlp(i18n("set $%ext_dynamic[$LastOpedMeOnChannel.$1] $2"));
	_hlp(i18n("The line above sets a variable named '$LastOpedMeOnChannel.#kaos'"));
	_hlp(i18n("to the value 'infected'."));
	_hlp(i18n("Try to execute the line below and see the result."));
	_hlp(i18n("/set $var test; set $%ext_dynamic[$$var]; echo $_window $test"));
	_syn("$%ext_isset[<global-variable-name>]");
	_hlp(i18n("Ths function will return true if the <global variable> is set,"));
	_hlp(i18n("false otherwise."));
	_hlp(i18n("Please note that $0,$1...$9 are NOT global variables , and are"));
	_hlp(i18n("always set in aliases and events , and never set in commandline"));
	_syn("$%ext_ismeop[<channel>]");
	_hlp(i18n("Returns $_true if you are op on <channel>, $_false if you are not op"));
	_hlp(i18n("or $_null if you are not on that channel at all."));
	_syn("$%ext_istimer[<timer-name>]");
	_hlp(i18n("Returns $_true if the <timer> is running , $_false otherwise"));
	_see("RETURN");
	_debug_leavetrace("doHelpOnExt");
}
//============ doHelpOnBox ============//
void KviHelp::doHelpOnBox(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnBox");
	_cmd("$%box_* FAMILY FUNCTIONS");
	_hlp(i18n("The $%box_* functions can make your scripts more interactive."));
	_hlp(i18n("Every function of this family will show/ask user something"));
	_hlp(i18n("and then return you the result.")); 
	_des;
	_hlp(i18n("$%box_yesno[<message text>]   : Shows a 'question' message-box.The user can answer"));
	_hlp(i18n("                                'yes' or 'not'.If the user selects 'yes' the function"));
	_hlp(i18n("                                will return $_true , $_false otherwise."));
	_hlp(i18n("$%box_input[<message text>]   : Shows an 'input' box, where the user can insert some text."));
	_hlp(i18n("                                The function will return the text if the user selects 'Ok'"));
	_hlp(i18n("                                or $_null if the user selects 'Cancel'"));
	_hlp(i18n("$%box_openfile[<initial dir>] : Asks user for a file to open."));
	_hlp(i18n("                                The function will return an absolute path to a file if the"));
	_hlp(i18n("                                selects an EXISTING file , $_null otherwise"));
	_hlp(i18n("                                Pass $_null as initial dir if you dont need to preset it."));
	_hlp(i18n("$%box_savefile[<preset file>] : Asks user for a file name to save."));
	_hlp(i18n("                                The function will return an absolute path to a file or"));
	_hlp(i18n("                                $_null if the user selects 'Cancel'"));
	_hlp(i18n("                                Pass $_null as parameter if you don't need a preset filename."));
	_hlp(i18n("$%box_ok[<message>] : This will only show a message box with an OK button .Returns always true."));
	_exa("if ($%box_yesno[Do you like KVirc ?]) echo $_window Great! :);else echo $_window :((((");  
	_debug_leavetrace("doHelpOnBox");
}
//============ doHelpOnVariables ============//
void KviHelp::doHelpOnVariables(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnVariables");
	_cmd("VARIABLES");
	_hlp(i18n("KVIrc allows you to set and unset variables."));
	_hlp(i18n("A variable identifier MUST start with a '$'."));
	_hlp(i18n("The variables are always evaluated before executing a command"));
	_hlp(i18n("or sending text to server."));
	_exa("/SET $string Some funny text;ECHO $_window $string")
	_hlp(i18n("The example above will produce an output in the current window."));
	_hlp(i18n("You can also write text on channel using variables,"));
	_exa("/SET $string Gray");
	_exa("Type in a channel : My shirt is $string");
	_hlp(i18n("The example above will send to the channel : My shirt is Gray"));
	_hlp(i18n("KVIrc has a number of internal variables that you can use."));
	_hlp(i18n("The internal variables always begin with a '$_'."));
	_hlp(i18n("INTERNAL VARIABLES LIST (type /help <variable-name>)"));
	_hlp(i18n("$_chan       $_window     $_mynick   $_myserver   $_myport"));
	_hlp(i18n("$_myusername $_myrealname $_myip     $_myserverip $_mynetwork"));
	_hlp(i18n("$_mymask     $_version    $_status   $_false      $_true"));
	_hlp(i18n("$_null       $_date       $_time     $_allchans   $_$"));
	_hlp(i18n("$_[          $_]          $_:        $_K          $_R"));
	_hlp(i18n("$0           $_O          $_U        $_B          $_myaddress"));
	_hlp(i18n("$_selected   $_target     $_allchats $_allqueries $_allchattargets"));
	_hlp(i18n("$_dirhome    $_dirkvirc"));
	_hlp(i18n("Variables allow you to insert 'variable' commands in your scripts"));
	_exa("/set $cmd echo; $cmd $_window Ciao");
	_hlp(i18n("The example above will 'echo' the string Ciao to the current window."));
	_see("SET UNSET ECHO");
	_debug_leavetrace("doHelpOnVariables");
}
//============ doHelpOnDir ============//
void KviHelp::doHelpOnDir(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnDir");
	_cmd("$_dir* FAMILY VARIABLES");
	_hlp(i18n("The $_dir* variabled contain directory names"));
	_des;
	_hlp(i18n("$_dirhome  : Returns your home directory path"));
	_hlp(i18n("$_dirkvirc : Returns your kvirc directory path.(Usually equal to $HOME/kvirc"));
	_debug_leavetrace("doHelpOnDir");
}
//============ doHelpOnMy ============//
void KviHelp::doHelpOnMy(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnMy");
	_cmd("$_my* FAMILY VARIABLES");
	_hlp(i18n("The $_my* variables contain informations about you."));
	_hlp(i18n("When you are not connected, they will always evaluate to $_null"));
	_des;
	_hlp(i18n("$_mynick     : Contains your current nick."));
	_hlp(i18n("$_myserver   : Contains your current server name."));
	_hlp(i18n("$_myserverip : Contains your current server IP address."));
	_hlp(i18n("$_myport     : Contains the port number that you're connected to."));
	_hlp(i18n("$_myusername : Contains your current username."));
	_hlp(i18n("$_myrealname : Contains your current real name."));
	_hlp(i18n("$_myip       : Contains your IP address."));
	_hlp(i18n("$_mynetwork  : Contains the name of the network that you ae connected to."));
	_hlp(i18n("$_myaddress  : Contains your address ah the server knows it."));
	_hlp(i18n("$_mymask     : Contains your extended mask."));
	_debug_leavetrace("doHelpOnMy");
}
//============ doHelpOnCh ============//
void KviHelp::doHelpOnCh(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnCh");
	_cmd("WINDOW RELATED VARIABLES");
	_hlp(i18n("$_chan $_window $_status $_allchans"));
	_des;
	_hlp(i18n("$_window     : Contains the current window name."));
	_hlp(i18n("               (i.e. the window from where the command is executed)."));
	_hlp(i18n("$_chan       : Contains the current channel name."));
	_hlp(i18n("               (like $_window but evaluates to $_null if"));
	_hlp(i18n("                the current window is not a channel"));
	_hlp(i18n("$_status     : Contains the status console name."));
	_hlp(i18n("               Useful for the ECHO command"));
	_hlp(i18n("$_allchans   : Contains the comma separated list of all channels"));
	_hlp(i18n("               that you are on.(or $_null)"));
	_hlp(i18n("$_allchats   : Same as above but for chat window names"));
	_hlp(i18n("$_allqueries : Same as above but for query windows."));
	_hlp(i18n("$_allchattargets : Same as above but for the DCC chat remote nicks."));
	_hlp(i18n("$_target     : Contains the remote end name of the window."));
	_hlp(i18n("               On a channel is equivalent to $_chan"));
	_hlp(i18n("               On a query or chat window contains the remote nick."));
	_hlp(i18n("$_selected   : Contains the selection for the current channel"));
	_hlp(i18n("               $_selected should be used ONLY from channel popups."));
	_exa("ECHO $_status I execute this command from $_window;IF (! $_chan) ECHO $_window You're not on a channel;");
	_debug_leavetrace("doHelpOnCh");
}

//============ doHelpOnFl ============//

void KviHelp::doHelpOnFl(KviMdiChild *lpC)
{
	_debug_entertrace("doHelpOnFl");
	_cmd("CONTROL VARIABLES");
	_hlp(i18n("$_false $_true $_null"));
	_des;
	_hlp(i18n("These three variables are useful only for scripting."));
	_hlp(i18n("In fact are particular STRINGS.(see below)"));
	_exa("IF ( $_null ) echo $_status You will newer see this message;");
	_hlp(KVI_STR_FALSE);
	_hlp(KVI_STR_NULL);
	_hlp(KVI_STR_TRUE);
	_see("IF VARIABLES");
	_debug_leavetrace("doHelpOnFl");
}
