//
//   File : kvi_frame.h (/usr/cvs/kvirc/kvirc/kvi_frame.h)
//   Last modified : Wed Nov 25 1998 20:27:07 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//


#ifndef _KVI_FRAME_H_INCLUDED_
#define _KVI_FRAME_H_INCLUDED_

#include "kvi_defs.h"
#include "kvi_types.h"
#include <qdatetime.h>

class KviInterface;
class KviMircColors;
class KviUser;
//class KviSrv;
class KviServerManager;
class KviOptions;
class KviStatusWnd;
class KviIrcSocket;
class KviStatusBar;
class KviServerParser;
class KviGlobals;
class KviMdiManager;
class KviUserParser;
class KviAliasManager;
class KviEventManager;
class KviPopupManager;
class KviTranslator;
class KviScriptManager;
class KviLinkWnd;
class KviSetup;
class KviAudio;
class KviNetscapeController;
class KviDns;
class KviAsciiPlayer;
class KviChanWnd;
class KviQueryWnd;
class KviChatWnd;
class KviSendWnd;
class KviUserWnd;
class KviVoiceWnd;
class KviChanListWnd;
class KviUserManager;
class KviProxy;
class KviGlobalUserList;
class KviDCCDaemon;

#include <ktopwidget.h>

class KviToolBar;

typedef struct pixmapTabTag{
	int			index;
	const char 	*szPixName;	
	const char	*szDescription;
} pixmapTable;

typedef struct iconTabTag{
	int         index;
	const char  *szPixName;
} iconTable;

class KviFrame : public KTMainWindow
{
	Q_OBJECT;
public:
	static pixmapTable pixTab[KVI_NUM_PIXMAPS];
	static iconTable icoTab[KVI_NUM_WND_TYPES];
public:
	KviFrame();
	~KviFrame();
public:    //variables
	KviGlobalUserList  *m_lpGlobalUserList;
	KviInterface       *m_lpInt;
	KviMircColors      *m_lpClr;
	KviUser            *m_lpUsr;
	KviServerManager   *m_lpSrv;
	KviOptions         *m_lpOpt;
	QColor             *m_lpColor[16]; //managed by m_lpClr!!! created and deleted!
	QPixmap            *m_lpPixmap[KVI_NUM_PIXMAPS];
	QPixmap            *m_lpIcon[KVI_NUM_WND_TYPES];
	QPixmap            *m_lpOpPixmap;
	QPixmap            *m_lpVoicePixmap;
	QPopupMenu         *m_lpToolbarsPopup;
	KviStatusWnd       *m_lpConsole;
	KviVoiceWnd        *m_lpVoiceWnd;
	KviDCCDaemon       *m_lpDCCD;
	KviIrcSocket       *m_lpSock;
	KviStatusBar       *m_lpStatusBar;
	KviServerParser    *m_lpServerParser;
	KviGlobals         *m_lpGlb;
	KviMdiManager      *m_lpMdi;
	KviUserParser      *m_lpUserParser;
	KviAliasManager    *m_lpAliasManager;
	KviEventManager    *m_lpEventManager;
	KviPopupManager    *m_lpPopupManager;
	KviTranslator      *m_lpTranslator;
	KviScriptManager   *m_lpScriptManager;
	KviLinkWnd         *m_lpLinksWindow;
	KviChanListWnd     *m_lpChanListWindow;
	KviSetup           *m_lpSetup;
	QList<KviIsonStruct>  *m_lpIsOnList;
	KviAudio           *m_lpAudio;
	KviNetscapeController *m_lpNetscape;
	KviDns             *m_lpDns;
	KviAsciiPlayer     *m_lpAsciiPlayer;
	KviProxy           *m_lpProxy;
	KviProxyEntry      *m_lpProxyEntry;
	QTime              m_lastNotifyCheck;
	bool               m_bGotLastReply;
//	int                m_iProxyProto;
	int                m_iLastChanPannerPosition;
	bool               m_bLoggedIn;
	bool               m_bUsingAltNick;
	bool               m_bCanReconnect;
	bool               m_bReconnecting;
	bool               m_bFocusManagingEnabled;
	bool               m_bRestarting;
	KviHostDescription m_hostDescription;
//	kviHostDescription m_proxyDescription;
	uint               m_iCurHostIdx;
	KviUserManager     *m_lpUserManager;
public:    //methods
	KviUserStruct * findUserStruct(QString &szNick,QString &szMask);
	void linksWindowClosed();
	void chanListWindowClosed();
	void formatNickOutputString(QString &szResult,QString &szNick);
	void setStatusText(const char *szText);
	void applyOptions();
	void handleSocketConnected();
	void handleConnectFailed();
	void handleSocketDisconnected();
	void handleProxyReply(unsigned char replycode);
	void handleConnectedToServer();
	void handleSocketError(int nErr);
	void queryExternalDestroy(KviMdiChild *lpC);
	void connectToCurrentServer();
	void connectToServer();
	void hopServer(QString &szServer,int iPort);
	void disconnectFromServer();
	void clearHostDescription();
	void requestNickListPopup(QPoint pnt);
	void requestNotifyListPopup(QPoint pnt);
	void requestChanPopup(QPoint pnt);
	void requestStatusPopup(QPoint pnt);
	void requestChatPopup(QPoint pnt);
	void viewDoubleClicked(QString &szString);
	void requestQueryPopup(QPoint pnt);
	void setFocusTargetRecursive(QWidget *lpW,QWidget *lpTrg);
	void queryUserHost(QString &szUserHost);
	void startNotifyList();
	void startDCCDaemon();
	void setWindowCaption();
	KviChanWnd  * createChanWnd(const char *szName);
	KviQueryWnd * createQueryWnd(const char *szName);
	KviChatWnd  * createChatWnd(const char *szName);
	KviVoiceWnd * createVoiceWnd(const char *szName);
	KviSendWnd  * createSendWnd(const char *szName,bool bMinimized);
	KviUserWnd  * createUserWnd(const char *szName,bool bMinimized,bool bHasInput,const char *szImage=0,QRect *geom=0);
private:    //variables
	KMenuBar        *m_lpMenuBar;
	KviToolBar      *m_lpToolBar;
	QPopupMenu      *m_lpSettingsPopup;
	QPopupMenu      *m_lpMainPopup;
	QPopupMenu      *m_lpNickListPopup;
	QPopupMenu      *m_lpNotifyListPopup;
	QPopupMenu      *m_lpControlPopup;
	QPopupMenu      *m_lpDCCPopup;
	QPopupMenu      *m_lpCTCPPopup;
	QPopupMenu      *m_lpInfoPopup;
	QPopupMenu		*m_lpChanPopup;
	QPopupMenu		*m_lpToolPopup;
	QPopupMenu      *m_lpStatusPopup;
	QPopupMenu      *m_lpStatsPopup;
	QPopupMenu      *m_lpActionsPopup;
	QPopupMenu      *m_lpUModePopup;
	QString         m_szCurNetwork;
	QString         m_szPassword;
	QTimer          *m_lpReconnectTimer;
	QRect           m_statusWndRect;
	bool            m_bStatusWndMaximized;
	QTimer          *m_lpDestroyTimer;
	QTimer          *m_lpUserHostTimer;
	QTimer          *m_lpNotifyTimer;
	QString         m_szNextUserHostQuery;
	QString			m_szNotifyString;
	int             m_iNextChildIdx;
	KviMdiChild     *m_lpLastChildToDestroy;
private:    //methods
	void getBarPositionString(QString &szString,KToolBar *bar);
	void setBarPosition(QString &szPos,KToolBar *bar);
	bool fillProxyAddress(bool bUseProtoV5);
	void readSettings();
	void saveSettings();
	void createMenuBar();
	void createToolbarsPopup();
	void createStatusBar();
//	void createToolBar();
	void setBarPositions();
	void createMdiManager();
	void createColors();
	void destroyColors();
	void createPixmaps();
	void destroyPixmaps();
	void createNickListPopup();
	void createNotifyListPopup();
	void createChanPopup();
	void createStatusPopup();
public slots:
	void createChanListWindow(bool bReadFromDisk);
	void doLinksWindow();
	void doChansWindow();
	void doEventDialog();
	void doUserDialog();
	void doInterfaceDialog();
	void doOptionsDialog();
	void doDccOptionsDialog();
	void doUserListDialog();
	void doIrcColorsDialog();
	void doServerDialog();
	void doPopupDialog();
	void doAliasDialog();
	void doUserHost();
	void connectionSlot();
	void reconnectionSlot();
	void destroySlot();
	void checkNotifyList();
	void hopServerSlot();
	void newWindow();
	void saveAllOptions();
	void saveScript();
	void loadScript();
	void dnsQueryDone(const char *szResult);
	void toggleToolBar();
	void toggleTaskBar();
	void toggleStatusBar();
	void nickListUserSlot(const char *szCommand);
	void nickListSlot(const char *szCommand);
	void chanUserSlot(const char *szCommand);
	void chatUserSlot(const char *szCommand);
	void queryUserSlot(const char *szCommand);

	void slotUserAction(const char *szAction);

	void slotOp();
	void slotDeop();
	void slotVoice();
	void slotDevoice();
	void slotQuery();
	void slotPing();
	void slotChat();
	void slotVersion();
	void slotTime();
	void slotSource();
	void slotClientinfo();
	void slotUserinfo();
	void slotFinger();
	void slotWhois();
	void slotKick();
	void slotDCCSend();
	void slotDCCVoice();
	void slotKBan();
	void slotWhowas();
	void slotWhoWho();
	void slotUserlist();
	void slotClonescan();

	void notifyListSlot(const char *szCommand);

	void slotNotifyWhois();
	void slotNotifyPing();
	void slotNotifyDCCChat();
	void slotNotifyDCCSend();
	void slotNotifyDCCVoice();
	void slotNotifyVersion();
	void slotNotifyQuery();

	void slotChanKvirc();
	void slotChanUserlist();
	void slotChanClonescan();
	void slotChanBanlist();
	void slotChanPart();
	void slotChanSound();

	void slotStatusMotd();
	void slotStatusVersion();
	void slotStatusTime();
	void slotStatusAdmin();
	void slotStatusInfo();
	void slotStatusUsers();
	void slotStatusLusers();
//	void slotStatusLinks();
	void slotStatusStatsC();
	void slotStatusStatsK();
	void slotStatusStatsU();
	void slotStatusStatsM();

	void statusSlot(const char *sendData);

	void slotUModeI();
	void slotUModeS();
	void slotUModeW();

	void slotActJoin();
	void slotActPart();
	void slotActQuery();
	void slotActChat();
	void slotActSend();
	void slotActAway();
	void slotActUnaway();
	void slotAboutKvirc();

//	void toolBarMoved();
protected:
	virtual void focusInEvent(QFocusEvent *);
};

#endif // _KVI_FRAME_H_INCLUDED_
