//   $Id: kvi_file.h,v 1.2 1998/09/20 20:22:30 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_FILE_H_INCLUDED_
#define _KVI_FILE_H_INCLUDED_

#include <qstring.h>
#include <qfile.h>
#include <qdatetime.h>
#include <qobject.h>
#include <qlist.h>

class KviMdiChild;

typedef struct kviFileStructTag{
	QString szIdentifier;
	QFile   *lpFile;
	int     openflags;
	QString szFileName;
	QTime   timeLastOp;
} KviFileStruct;

#define KVI_FILE_OPEN_READ 1
#define KVI_FILE_OPEN_WRITE (1<<1)
#define KVI_FILE_OPEN_TRUNCATE (1<<2)
#define KVI_FILE_OPEN_CIRCULAR (1<<3)

class KviFileManager : public QObject{
	Q_OBJECT
public:
	KviFileManager();
	~KviFileManager();
public:
	QTimer *m_lpClearTimer;
	QList<KviFileStruct> *m_lpFileList;
public:
	bool fileOpen(const char *identifier,const char *filename,int openflags);
	bool fileClose(const char *identifier);
	bool fileReadNextLine(const char *identifier,QString &szData);
	bool fileReadRandLine(const char *identifier,QString &szData);
	bool fileWriteLine(const char *identifier,QString &szData);
	void showFiles(KviMdiChild *lpC);
	KviFileStruct *getFileStruct(const char *identifier);
public slots:
	void clearFiles();
};
#endif //_KVI_FILE_H_INCLUDED_
