//   $Id: kvi_evedlg.h,v 1.3 1998/09/20 20:22:26 fritz Exp $
//
//   This file is part of the KVIrc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_EVEDLG_H_INCLUDED_
#define _KVI_EVEDLG_H_INCLUDED_

#include "kvi_types.h"
#include "kvi_event.h"

#include <qdialog.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlabel.h>

class KviFrame;
class KviMultiLineEdit;

class KviEventDialog : public QDialog{
	Q_OBJECT
public:
	KviEventDialog(KviFrame *lpFrame);
	~KviEventDialog();
public:
	KviFrame		*m_lpFrm;
	KviEventManager	*m_lpEventManager;
	KviEventStruct  *lpEvent[KVI_EVENTS_NUMBER];
private:
	KviMultiLineEdit	*m_lpEdit;
	QPushButton		*m_lpDone;
	QPushButton     *m_lpHelp;
	QPushButton     *m_lpCancel;
	QComboBox		*m_lpBox;
	QCheckBox		*m_lpCheck;
	QLabel			*m_lpSyntax;
	int m_iLastSelection;
protected:
	virtual void resizeEvent(QResizeEvent *);
	void fillBox();
protected slots:
	void okPressed();
	void invokeHelp();
	void selectionChanged(int idx);
	void activeChanged(bool bOn);
};

#endif //_KVI_EVEDLG_H_INCLUDED_
