//   $Id: kvi_ctcp.h,v 1.3 1998/09/20 20:22:23 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_CTCP_H_INCLUDED_
#define _KVI_CTCP_H_INCLUDED_

#include "kvi_nick.h"

#include <qobject.h>

class KviFrame;
class KviServerParser;
class KviIrcSocket;
class KviGlobals;
class KviUser;
class KviOptions;
class KviIrcToken;

class KviCTCP : public QObject{
	Q_OBJECT
public:
	KviCTCP(KviFrame *lpFrame, KviServerParser *lpPar);
	~KviCTCP();

	KviFrame		*m_lpFrm;
	KviGlobals		*m_lpGlb;
	KviUser			*m_lpUsr;
	KviOptions		*m_lpOpt;
	int				m_iCTCPCount;
	QTimer			*m_lpCTCPTimer;
	KviServerParser *m_lpPar;
	KviIrcSocket	*m_lpSock;

public:
	void handleCTCPRequest(KviNewNick &nick,QString &target,KviIrcToken *lpData);

	void handleCTCPPageRequest(QString &szNick,QString &target,KviIrcToken *lpData);
	void handleCTCPActionRequest(QString &szNick,QString &target,KviIrcToken *lpData);
	void handleCTCPDCCRequest(QString &szNick,KviIrcToken *lpData,QString &szMask);
	void handleDCCChat(QString &szNick,QString &szMask,QString &szPara,QString &szAddr,QString &szPort);
	void handleDCCVoice(QString &szNick,QString &szMask,QString &szPara,QString &szAddr,QString &szPort);
	void handleDCCSend(QString &szNick,QString &szMask,QString &szPara,QString &szAddr,QString &szPort,KviIrcToken *lpData);
	bool getDCCSaveFileName(QString &szNewFileName,QString &szOldFileName,QString &szFileSize);
	QString getDCCSaveDirectory(QString &szStr);

	void handleCTCPReply(KviNewNick &nick,QString &target,KviIrcToken *lpData);
	void replyCTCPErrormsg(QString &szNick,const char *szReply);
	void replyCTCP(KviNewNick &nick,const char *szType,const char * szReply);
public slots:
	void resetCTCPCount();
};

#endif
