//   $Id:...$
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_CHLIST_H_INCLUDED_
#define _KVI_CHLIST_H_INCLUDED_

#include "kvi_child.h"

#include <knewpanner.h>

#include <ktablistbox.h>
#include <qlist.h>
#include <qfile.h>


typedef struct kviChanListEntryTag{
	QString szChannel;
	QString szUsers;
	QString szTopic;
} KviChanListEntry;

class KviChanListWnd : public KviMdiChild
{
	Q_OBJECT
public:	
	KviChanListWnd(KviMdiManager *parent,KviFrame *frame,int aid,bool getFromFile);
	~KviChanListWnd();
	
	KNewPanner      *m_lpPanner;
	KTabListBox       *m_lpView;
	QList<KviChanListEntry> *m_lpChanList;

	bool m_bDone;
	uint m_iNumChans;
	uint m_iMaxUsers;
	QString m_szMaxUsersChan;
	uint m_iAvgUsers;
	uint m_iPrvChans;
	uint m_iTotUsers;
public:
	void applyOptions();
	void doFmtOutput(int nType,const char *szFmt,...);
	void doOutput(int nType,const char *szText);
	void endOfChannelList();
	void addChanEntry(QString &szEntry);
	void clear();
protected:
	void writeToFile();
	void appendViewItem(KviChanListEntry *e);
	void cantWriteError();
	void cantReadError();
	bool writeChanEntry(QFile *f,KviChanListEntry *e);
	bool readChanEntry(QFile *f,KviChanListEntry *e);
	virtual void resizeEvent(QResizeEvent *);
	void readFromFile();
public slots:
	void itemDblClk(int index,int);
	void closeSlot();
};

#endif // _KVI_CHLIST_H_INCLUDED_
