//   $Id: kvi_cache.h,v 1.2 1998/09/20 20:22:07 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_CACHE_H_INCLUDED_
#define _KVI_CACHE_H_INCLUDED_

#include <qstring.h>
#include <qdict.h>

typedef QDict<QString>  KviSection;

class KviMdiChild;

class KviCache{
public:
	KviCache();
	~KviCache();
public:
	QDict<KviSection> *m_lpCache;
public:
	bool readCache();
	bool writeCache();
	void echoToWindow(KviMdiChild *lpC);
	bool readSection(KviSection *kvisect,QDataStream &stream);
	bool writeSection(KviSection *kvisect,QDataStream &stream);
	void insertKey(const char *section,const char *key,const char *value);
	const char * getKey(const char *section,const char *key);
	bool removeKey(const char *section,const char *key);
	bool removeSection(const char *section);
	void clearCache();
};
#endif //_KVI_CACHE_H_INCLUDED_
