//   $Id: kvi_bandlg.cpp,v 1.3 1998/09/20 20:22:05 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#include "kvi_bandlg.h"
#include "kvi_chan.h"
#include "kvi_frame.h"
#include "kvi_uparser.h"
#include "kvi_debug.h"

#include <kapp.h>

//============ KviBanDialog ============//
KviBanDialog::KviBanDialog(KviChanWnd *lpWnd,KviFrame *lpFrame) : QDialog(lpWnd,0,true)
{
	_debug_entertrace("KviBanDialog");
	m_lpFrm    = lpFrame;
	m_lpChan   = lpWnd;

	m_lpBox    = new KTabListBox(this,0,2);
	m_lpBox->setColumn(0,i18n("Ban mask"),160);
	m_lpBox->setColumn(1,i18n("Set by"));
	m_lpBox->setSeparator(',');
	m_lpBox->show();
	m_lpBox->setAutoUpdate(true);

	m_lpTempList=new QList<KviBanEntry>;
	m_lpTempList->setAutoDelete(false);
	m_lpUnbanList=new QList<KviBanEntry>;
	m_lpUnbanList->setAutoDelete(true);

	KviBanEntry *lpB=0;
	for(lpB=m_lpChan->m_lpBanList->first();lpB;lpB=m_lpChan->m_lpBanList->next()){
		QString szEntry=lpB->szBanMask+","+lpB->szBanSetBy;
		m_lpBox->appendItem(szEntry.data());
		KviBanEntry *lpNew=new KviBanEntry;
		lpNew->szBanMask=lpB->szBanMask.data();
		lpNew->szBanSetBy=lpB->szBanSetBy.data();
		m_lpTempList->append(lpNew);
	}

	m_lpSep     = new KSeparator(this,0);
	m_lpOk      = new QPushButton(i18n("OK"),this);
	m_lpCancel  = new QPushButton(i18n("Cancel"),this);
	m_lpUnban   = new QPushButton(i18n("Unban"),this);
	m_lpUnbanAll= new QPushButton(i18n("Unban all"),this);

	if(!m_lpChan->m_bIsMeOp || m_lpTempList->isEmpty()){
		m_lpUnban->setEnabled(false);
		m_lpUnbanAll->setEnabled(false);
	}

	connect(m_lpUnban,SIGNAL(clicked()),this,SLOT(slotUnban()));
	connect(m_lpUnbanAll,SIGNAL(clicked()),this,SLOT(slotUnbanAll()));
	connect(m_lpOk,SIGNAL(clicked()),this,SLOT(doChanges()));
	connect(m_lpCancel,SIGNAL(clicked()),this,SLOT(reject()));

	resize(350,300);
	_debug_leavetrace("KviBanDialog");
}
//============ ~KviBanDialog ============//
KviBanDialog::~KviBanDialog()
{
	_debug_entertrace("~KviBanDialog");
	m_lpTempList->setAutoDelete(true);
	while(!m_lpTempList->isEmpty())m_lpTempList->removeLast();
	delete m_lpTempList;
	while(!m_lpUnbanList->isEmpty())m_lpUnbanList->removeLast();
	delete m_lpUnbanList;
	delete m_lpOk;
	delete m_lpCancel;
	delete m_lpBox;
	delete m_lpSep;
	delete m_lpUnban;
	delete m_lpUnbanAll;
	_debug_leavetrace("~KviBanDialog");
}
//============ doChanges ============//
void KviBanDialog::doChanges()
{
	_debug_entertrace("doChanges");
	QString szUnban="";
	while(!m_lpUnbanList->isEmpty()){
		KviBanEntry *lpB=m_lpUnbanList->first();
		if(szUnban.isEmpty())szUnban="/UNBAN ";
		else szUnban+=',';
		szUnban+=lpB->szBanMask.data();
		KviBanEntry *lpC=0;
		for(lpC=m_lpChan->m_lpBanList->first();lpC;lpC=m_lpChan->m_lpBanList->next()){
			if(!strcasecmp(lpC->szBanMask.data(),lpB->szBanMask.data())){
				m_lpChan->m_lpBanList->removeRef(lpC);
			}
		}
		m_lpUnbanList->removeFirst();
	}
	if(!szUnban.isEmpty())m_lpFrm->m_lpUserParser->parseUserInput(m_lpChan,KVI_WND_TYPE_CHAN,m_lpChan->name(),szUnban);
	m_lpChan->updateUsersLabel();
	accept();
	_debug_leavetrace("doChanges");
}
//============ slotUnban ============//
void KviBanDialog::slotUnban()
{
	_debug_entertrace("slotUnban");
	if(m_lpBox->count()==0)return;
	int curItm=m_lpBox->currentItem();
	if(curItm != -1){
		m_lpBox->removeItem(curItm);
		m_lpUnbanList->append(m_lpTempList->at(curItm));
		m_lpTempList->remove(curItm);
		m_lpBox->unmarkAll();
		if(m_lpBox->count()>(uint)curItm)m_lpBox->setCurrentItem(curItm);
		else {
			if(m_lpBox->count() != 0)m_lpBox->setCurrentItem(0);
			else {
				m_lpUnban->setEnabled(false);
				m_lpUnbanAll->setEnabled(false);
			}
		}
	}
	_debug_leavetrace("slotUnban");
}
//============ slotUnbanAll ============//
void KviBanDialog::slotUnbanAll()
{
	_debug_entertrace("slotUnbanAll");
	if(m_lpBox->count()==0)return;
	while(!m_lpTempList->isEmpty()){
		m_lpUnbanList->append(m_lpTempList->first());
		m_lpTempList->removeFirst();
		m_lpBox->removeItem(0);
	}
	m_lpBox->clear();
	m_lpBox->repaint();
	_debug_leavetrace("slotUnbanAll");
}
//============ resizeEvent ============//
void KviBanDialog::resizeEvent(QResizeEvent *)
{
	_debug_entertrace("resizeEvent");
	m_lpOk->setGeometry((width()/2)+2,height()-32,(width()-24)/2,26);
	m_lpCancel->setGeometry(10,height()-32,(width()-24)/2,26);
	m_lpSep->setGeometry(10,height()-37,width()-20,3);
	m_lpUnbanAll->setGeometry((width()/2)+2,height()-68,(width()-24)/2,26);
	m_lpUnban->setGeometry(10,height()-68,(width()-24)/2,26);
	m_lpBox->setGeometry(10,10,width()-10,height()-81);
	_debug_leavetrace("resizeEvent");
}
#include "m_kvi_bandlg.moc"
