//   $Id: kvi_ascii.h,v 1.2 1998/09/20 20:22:03 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_ASCII_H_INCLUDED_
#define _KVI_ASCII_H_INCLUDED_

class KviMdiChild;
class KviFrame;

#include <qtextstream.h>
#include <qfile.h>
#include <qobject.h>
#include <qlist.h>

typedef struct kviAsciiStructTag{
	QTextStream *lpStream;
	QFile *lpFile;
	KviMdiChild *lpWindow;
	int timerId;
} KviAsciiStruct;

class KviAsciiPlayer : public QObject{
	Q_OBJECT
public:
	KviAsciiPlayer(KviFrame *lpFrm);
	~KviAsciiPlayer();
public:
	KviFrame   *m_lpFrm;
	QList<KviAsciiStruct> *m_lpAsciiList;
	bool playAscii(const char *fileName,KviMdiChild *lpWindow,int timeout);
	void stopAll();
protected:
	virtual void timerEvent(QTimerEvent *e);
};

#endif //_KVI_ASCII_H_INCLUDED_
