//   $Id: kvi_alidlg.cpp,v 1.5 1998/09/20 20:21:58 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include <kvi_alidlg.h>
#include <kvi_debug.h>
#include <kvi_frame.h>
#include <kvi_alias.h>
#include <kvi_mlined.h>

#include <kwm.h>
#include <kapp.h>
#include <kmsgbox.h>


//============ KviAliasDialog ============//

KviAliasDialog::KviAliasDialog(KviFrame *lpFrame)
	: QDialog(lpFrame, "KviAliasDialog", true)
{
	_debug_entertrace("KviAliasDialog");

	m_lpFrm=lpFrame;
	m_lpMng=lpFrame->m_lpAliasManager;

	m_lpAliasList=new QList<KviAliasStruct>;
	m_lpAliasList->setAutoDelete(true);
	//make a local copy of the aliases
	KviAliasStruct *lpA=0;
	for(lpA=m_lpMng->m_lpAliasList->first();lpA;lpA=m_lpMng->m_lpAliasList->next()){
		KviAliasStruct *lpCpy=new KviAliasStruct;
		lpCpy->szBuffer=lpA->szBuffer.copy();
		lpCpy->szName=lpA->szName.copy();
		m_lpAliasList->append(lpCpy);
	}

	setCaption(i18n("Aliases"));
	setMinimumWidth(400);
	setMinimumHeight(280);

	m_lpEdit=new KviMultiLineEdit(this,lpFrame);
	m_lpDone=new QPushButton(i18n("OK"),this);
	m_lpCancel=new QPushButton(i18n("Cancel"),this);
	m_lpHelp=new QPushButton(i18n("Help"),this);
	m_lpBox =new QComboBox(false,this);

	connect(m_lpDone,SIGNAL(clicked()),this,SLOT(okPressed()));
	connect(m_lpCancel,SIGNAL(clicked()),this,SLOT(reject()));
	connect(m_lpHelp,SIGNAL(clicked()),this,SLOT(invokeHelp()));

	connect(m_lpBox,SIGNAL(activated(const char *)),this,SLOT(selectionChanged(const char *)));

	m_lpRename=new QPushButton(i18n("Rename"),this);
	m_lpRemove=new QPushButton(i18n("Remove"),this);
	m_lpNew=new QPushButton(i18n("New"),this);

	connect(m_lpNew,SIGNAL(clicked()),this,SLOT(newAlias()));
	connect(m_lpRemove,SIGNAL(clicked()),this,SLOT(removeAlias()));
	connect(m_lpRename,SIGNAL(clicked()),this,SLOT(renameAlias()));

	//OOps?
	m_lpLined=new KRestrictedLine(this,"Mah","qwertyuioplkjhgfdsazxcvbnm.QWERTYUIOPLKJHGFDSAZXCVBNM");
	m_lpLined->hide();

	connect(m_lpLined,SIGNAL(returnPressed()),this,SLOT(enterPressed()));

	m_iMode=_KVI_ALIDLG_MODE_NONE;
	fillBox();
    if(!m_lpMng->m_lastGeometry.isEmpty())setGeometry(KWM::setProperties(winId(),m_lpMng->m_lastGeometry));
	else resize(400,400);

	if(!m_lpAliasList->isEmpty()){
		m_szLastSelection="";
		if((((int)m_lpAliasList->count()) > m_lpMng->m_iLastEdited)&&(m_lpMng->m_iLastEdited >=0)){
			KviAliasStruct *lpA=m_lpAliasList->at(m_lpMng->m_iLastEdited);
			if(lpA){
//				m_szLastSelection=lpA->szName.copy();
				m_lpBox->setCurrentItem(m_lpMng->m_iLastEdited);
				selectionChanged(lpA->szName.data());
			} else {
				m_lpMng->m_iLastEdited=0;
				m_lpBox->setCurrentItem(0);
				selectionChanged(m_lpAliasList->first()->szName.data());
			}
		} else {
			m_lpMng->m_iLastEdited=0;
			m_lpBox->setCurrentItem(0);
			selectionChanged(m_lpAliasList->first()->szName.data());
		}
	} else m_szLastSelection="";

	_debug_leavetrace("KviAliasDialog");
}

//============ ~KviAliasDialog ============//

KviAliasDialog::~KviAliasDialog()
{
	_debug_entertrace("~KviAliasDialog");
	while(!m_lpAliasList->isEmpty())m_lpAliasList->removeLast();
	delete m_lpAliasList;
	delete m_lpEdit;
	delete m_lpDone;
	delete m_lpCancel;
	delete m_lpHelp;
	delete m_lpBox;
	delete m_lpRename;
	delete m_lpRemove;
	delete m_lpNew;
	delete m_lpLined;
	_debug_leavetrace("~KviAliasDialog");
}

//============ okPressed ============//

void KviAliasDialog::okPressed()
{
	_debug_entertrace("okPressed");
	m_lpMng->m_iLastEdited=m_lpBox->currentItem();
	m_lpMng->m_lastGeometry=KWM::getProperties(winId());
	selectionChanged(0);
	//copy the aliases from local to global list
	KviAliasStruct *lpA=0;
	while(!m_lpMng->m_lpAliasList->isEmpty())m_lpMng->m_lpAliasList->removeLast();
	for(lpA=m_lpAliasList->first();lpA;lpA=m_lpAliasList->next()){
		KviAliasStruct *lpCpy=new KviAliasStruct;
		lpCpy->szBuffer=lpA->szBuffer.copy();
		lpCpy->szName=lpA->szName.copy();
		m_lpMng->m_lpAliasList->append(lpCpy);
	}
	//sort aliases
	m_lpMng->sortAliases();
	m_lpMng->saveToFile();
	accept();
	_debug_leavetrace("okPressed");
}

//============ invokeHelp ============//

void KviAliasDialog::invokeHelp()
{
	_debug_entertrace("invokeHelp");
	_debug_leavetrace("invokeHelp");
}

//============ newAlias ============//

void KviAliasDialog::newAlias()
{
	_debug_entertrace("newAlias");
	enableLined(false);
	m_iMode=_KVI_ALIDLG_MODE_NEW;
	_debug_leavetrace("newAlias");
}

//============ removeAlias ============//

void KviAliasDialog::removeAlias()
{
	_debug_entertrace("removeAlias");
	const char *szAli=m_lpBox->currentText();
	if(!szAli)return;
	KviAliasStruct *lpS=0;
	KviAliasStruct *lpF=0;
	for(lpS=m_lpAliasList->first();lpS && (!lpF);lpS=m_lpAliasList->next()){
		if(!strcasecmp(lpS->szName.data(),szAli))lpF=lpS;
	}
	if(lpF){
		m_lpAliasList->removeRef(lpF);
		m_szLastSelection="";
		fillBox();
		if(!m_lpAliasList->isEmpty()){
			m_lpBox->setCurrentItem(0);
			selectionChanged(m_lpAliasList->first()->szName.data());
		}	
	}
	_debug_leavetrace("removeAlias");
}

//============ renameAlias ============//

void KviAliasDialog::renameAlias()
{
	_debug_entertrace("renameAlias");
	const char *szAli=m_lpBox->currentText();
	if(!szAli)return;
	KviAliasStruct *lpS=0;
	KviAliasStruct *lpF=0;
	for(lpS=m_lpAliasList->first();lpS && (!lpF);lpS=m_lpAliasList->next()){
		if(!strcasecmp(lpS->szName.data(),szAli))lpF=lpS;
	}
	if(lpF){
		m_szTmpBuf=lpF->szBuffer.copy();
		m_szTmpName=lpF->szName.copy();
		m_lpAliasList->removeRef(lpF);
		m_szLastSelection="";
		enableLined(false);
		m_lpLined->setText(szAli);
		m_iMode=_KVI_ALIDLG_MODE_RENAME;	
	}

	_debug_leavetrace("renameAlias");
}

//============ fillBox ============//

void KviAliasDialog::fillBox()
{
	_debug_entertrace("fillBox");
	if(m_lpAliasList->isEmpty()){
		m_lpBox->setEnabled(false);
		m_lpEdit->clear();
		m_lpEdit->setEnabled(false);
		m_lpRename->setEnabled(false);
		m_lpRemove->setEnabled(false);	
	} else {
		KviAliasStruct *lpS=0;
		m_lpBox->clear();
		for(lpS=m_lpAliasList->first();lpS;lpS=m_lpAliasList->next()){
			m_lpBox->insertItem(lpS->szName.data());
		}
	}
	_debug_leavetrace("fillBox");
}

//============ selectionChanged ============//

void KviAliasDialog::selectionChanged(const char *szSel)
{
	_debug_entertrace("selectionChanged");
	//debug("WE ARE HERE:%s",m_szLastSelection.data());
	KviAliasStruct *lpS=0;
	KviAliasStruct *lpF=0;
	for(lpS=m_lpAliasList->first();lpS && (!lpF);lpS=m_lpAliasList->next()){
		//debug("LOOKING %s",lpS->szName.data());
		if(lpS->szName==m_szLastSelection)lpF=lpS;
	}
	//debug("DONE LOOKING");
	if(lpF){
		//debug("FOUND %s",lpS->szBuffer.data());
		lpF->szBuffer=m_lpEdit->text();
		//if(lpF->szBuffer.isEmpty())m_lpAliasList->removeRef(lpF); //<---do not remove it...only troubles :)
	}
	if(!szSel || (!(*szSel)))return;
	lpF=0;
	m_szLastSelection=szSel;
	m_szLastSelection=m_szLastSelection.upper();
	for(lpS=m_lpAliasList->first();lpS && (!lpF);lpS=m_lpAliasList->next()){
		if(lpS->szName==m_szLastSelection)lpF=lpS;
	}
	if(lpF){
		m_lpEdit->setText(lpF->szBuffer);
		m_lpEdit->setFocus();
	} else {
		debug("Qt drunk???????");
		ASSERT(false);
	}
	_debug_leavetrace("selectionChanged");
}

//============ enterPressed ============//

void KviAliasDialog::enterPressed()
{
	_debug_entertrace("enterPressed");
	if(m_iMode==_KVI_ALIDLG_MODE_NEW){
		if(m_lpLined->text()){
			KviAliasStruct *lpS=0;
			KviAliasStruct *lpF=0;
			for(lpS=m_lpAliasList->first();lpS && (!lpF);lpS=m_lpAliasList->next()){
				if(!strcasecmp(lpS->szName.data(),m_lpLined->text()))lpF=lpS;
			}
			if(lpF){
				KMsgBox::message(this, i18n("New alias..."), i18n("This name is already in the alias list."),
						 KMsgBox::EXCLAMATION);
				newAlias();
				return;
			}	
			lpS=new KviAliasStruct;
			lpS->szName=QString(m_lpLined->text()).upper();
			lpS->szBuffer="/<\n    echo $_window empty alias;\n>;";
			m_lpAliasList->append(lpS);
			m_lpMng->sortAliases(m_lpAliasList);
			fillBox();
			int index=m_lpAliasList->findRef(lpS);
			if(index==-1){
				debug("Internal error with aliases...");
				m_lpBox->setCurrentItem(0);
				KviAliasStruct *lpZ=m_lpAliasList->first();
				if(lpZ){
					selectionChanged(lpZ->szName.data());
				}
			} else {
				m_lpBox->setCurrentItem(index);
				selectionChanged(lpS->szName.data());
			}
		}
	} else if(m_iMode==_KVI_ALIDLG_MODE_RENAME){
		if(m_lpLined->text()){
			KviAliasStruct *lpS=0;
			KviAliasStruct *lpF=0;
			for(lpS=m_lpAliasList->first();lpS && (!lpF);lpS=m_lpAliasList->next()){
				if(!strcasecmp(lpS->szName.data(),m_lpLined->text()))lpF=lpS;
			}
			if(lpF){
				KMsgBox::message(this, i18n("Rename alias..."),
						 i18n("This name is already in the alias list."),
						 KMsgBox::EXCLAMATION);
			}
			lpS=new KviAliasStruct;
			if(!lpF)lpS->szName=QString(m_lpLined->text()).upper();
			else lpS->szName=m_szTmpName.copy();
			lpS->szBuffer=m_szTmpBuf.copy();
			m_lpAliasList->append(lpS);
			m_lpMng->sortAliases(m_lpAliasList);
			fillBox();
			int index=m_lpAliasList->findRef(lpS);
			if(index==-1){
				debug("Internal error with aliases...");
				m_lpBox->setCurrentItem(0);
				KviAliasStruct *lpZ=m_lpAliasList->first();
				if(lpZ){
					selectionChanged(lpZ->szName.data());
				}
			} else {
				m_lpBox->setCurrentItem(index);
				selectionChanged(lpS->szName.data());
			}
		} else {
			fillBox();
			if(!m_lpAliasList->isEmpty()){
				m_lpBox->setCurrentItem(0);
				selectionChanged(m_lpAliasList->first()->szName.data());
			}
			return;
		}	
	}
	enableLined(true);
	m_iMode=_KVI_ALIDLG_MODE_NONE;
	_debug_leavetrace("enterPressed");
}

//============ enableLined ============//

void KviAliasDialog::enableLined(bool bEnable)
{
	_debug_entertrace("enableLined");
	m_lpBox->setEnabled(bEnable);
	m_lpRename->setEnabled(bEnable);
	m_lpRemove->setEnabled(bEnable);
	m_lpNew->setEnabled(bEnable);
	//m_lpDone->setEnabled(bEnable);
	m_lpEdit->setEnabled(bEnable);
	if(bEnable){
		m_lpLined->hide();
		m_lpBox->show();
		m_lpEdit->setFocus();
	} else {
		m_lpBox->hide();
		m_lpLined->show();
		m_lpLined->setFocus();
	}
	_debug_leavetrace("enableLined");
}

//============ resizeEvent ============//

void KviAliasDialog::resizeEvent(QResizeEvent *)
{
	_debug_entertrace("resizeEvent");

	m_lpCancel->setGeometry(width()-100,height()-30,95,25);
	m_lpDone->setGeometry(width()-200,height()-30,95,25);
	m_lpHelp->setGeometry(width()-300,height()-30,95,25);
	m_lpBox->setGeometry(5,5,width()-10,25);
	m_lpRename->setGeometry(15+(((width()-20)/3)*2),40,(width()-20)/3,25);
	m_lpRemove->setGeometry(10+((width()-20)/3),40,(width()-20)/3,25);
	m_lpNew->setGeometry(5,40,(width()-20)/3,25);
	m_lpLined->setGeometry(5,5,width()-10,25);
	m_lpEdit->setGeometry(5,70,width()-10,height()-105);
	_debug_leavetrace("resizeEvent");
}

#include "m_kvi_alidlg.moc"

//
// $Log: kvi_alidlg.cpp,v $
// Revision 1.5  1998/09/20 20:21:58  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.4  1998/09/18 03:44:44  fritz
// Unified OK-Buttons (some had been 'Ok', most are 'OK'). Now all are 'OK'
// Work on the Server-Dialog. Still not satisfied, but it works.
//
// Revision 1.3  1998/09/16 17:15:53  fritz
// Starting i18n.
//
// Revision 1.2  1998/09/16 03:14:51  pragma
// Added the 'Cancel' and 'Help (empty slot by now)' buttons to the
// alias dialog. Now it operates on a copy of the alias list.
//
//
