//   $Id: kvi_alias.h,v 1.3 1998/09/20 20:21:57 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_ALIAS_H_INCLUDED_
#define _KVI_ALIAS_H_INCLUDED_

#include "kvi_types.h"

#include <qstring.h>
#include <qlist.h>

#define KVI_MAX_ALIAS_PARAMS 10

class KviAliasManager{
public:
	KviAliasManager();
	~KviAliasManager();
public:
	QList<KviAliasStruct> *m_lpAliasList;
	int m_iLastEdited;
	QString m_lastGeometry;
public:
	void saveToFile();
	KviAliasStruct * getAlias(const char *szName);
	void addAlias(const char *szName,QString &szBuffer);
	void removeAlias(const char *szName);
	void sortAliases(QList<KviAliasStruct> *list=0);
private:
	void readFromFile();
	void cantWriteError();
	void cantReadError();
	void internalError();
	void createEmptyAliasList();
};

#endif //_KVI_ALIAS_H_INCLUDED_
