//   $Id: kvi_alias.cpp,v 1.6 1998/10/01 00:55:23 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#include "kvi_app.h"
#include "kvi_alias.h"
#include "kvi_debug.h"
#include "kvi_macros.h"
#include "kvi_app.h"

#include <kmsgbox.h>

KviAliasManager::KviAliasManager()
{
	m_lpAliasList=new QList<KviAliasStruct>;
	m_lpAliasList->setAutoDelete(true);
	readFromFile();
	m_lastGeometry="";
	m_iLastEdited=0;
}
KviAliasManager::~KviAliasManager()
{
	saveToFile();
	m_lpAliasList->setAutoDelete(true);
	while(!m_lpAliasList->isEmpty()){
		m_lpAliasList->removeLast();
	}
	delete m_lpAliasList;
}

//============ sortAliases ============//

void KviAliasManager::sortAliases(QList<KviAliasStruct> *list)
{
	_debug_entertrace("sortAliases");
	// if list==0 the internal alias list is sorted!
	if(!list)list=m_lpAliasList;
	QList<KviAliasStruct> *l=new QList<KviAliasStruct>(*list); //shallow copy
	l->setAutoDelete(false);
	list->setAutoDelete(false);
	while(!list->isEmpty())list->removeLast();
	list->setAutoDelete(true);
	KviAliasStruct *lpA=0;
	for(lpA=l->first();lpA;lpA=l->next()){
		KviAliasStruct *lpN=0;
		bool bDone=false;
		int idx=0;
		for(lpN=list->first();lpN && (!bDone);lpN=list->next()){
			if(lpN->szName > lpA->szName.data()){ //if the alias in the list is greater that the inserting...replace
				list->insert(idx,lpA);
				bDone=true;
			}
			idx++;
		}
		if(!bDone){
			list->append(lpA);
		}
	}
	delete l;
	_debug_leavetrace("sortAliases");
}

//============ saveToFile ============//

void KviAliasManager::saveToFile()
{
	_debug_entertrace("saveToFile");
	QString szFileName(_macro_getKVircHomeDirectory("Config/kvi.alias.conf"));

	QFile config(szFileName.data());
	if(!config.open(IO_WriteOnly|IO_Truncate)){ cantWriteError(); return; }
	//Write the alias number
	uint cnt=m_lpAliasList->count();
	if(config.writeBlock("KVIrc CONFIGURATION FILE - PLEASE DO NOT EDIT\n",46)<0){ cantWriteError(); return; };
	if(config.writeBlock((char *)&cnt,sizeof(cnt))<0){ cantWriteError(); return; };

	for(uint i=0;i<cnt;i++){
		KviAliasStruct *lpA=m_lpAliasList->at(i);
		if(lpA){
			uint len=lpA->szName.length();
			if(config.writeBlock((char *)&len,sizeof(len))<0){ cantWriteError(); return; };
			if(config.writeBlock(lpA->szName.data(),len)<0){ cantWriteError(); return; };
			len=lpA->szBuffer.length();
			if(config.writeBlock((char *)&len,sizeof(len))<0){ cantWriteError(); return; };
			if(config.writeBlock(lpA->szBuffer.data(),len)<0){ cantWriteError(); return; };
		} else {
			internalError();
			return;
		}
	}
	config.close();
	_debug_leavetrace("saveToFile");
}
//============ cantWriteError ============//
void KviAliasManager::cantWriteError()
{
	_debug_entertrace("cantWriteError");
	KMsgBox::message(0,i18n("WARNING File I/O Error"),
			 i18n("Can't write to the kvi.alias.conf file.\nThe current aliases will be lost."));
	_debug_leavetrace("cantWriteError");
}
//============ cantReadError ============//
void KviAliasManager::cantReadError()
{
	_debug_entertrace("cantReadError");
	KMsgBox::message(0,i18n("WARNING File I/O Error"),i18n("Can't read the kvi.alias.conf file.\nThe current aliases will be lost."));
	_debug_leavetrace("cantReadError");
}
//============ internalError ============//
void KviAliasManager::internalError()
{
	_debug_entertrace("internalError");
	KMsgBox::message(0,i18n("WARNING"),i18n("Internal error.\nThe current aliases will be lost."));
	_debug_leavetrace("internalError");
}
//============ readFromFile ============//
void KviAliasManager::readFromFile()
{
	_debug_entertrace("readFromFile");
	QString szFileName(_macro_getKVircHomeDirectory("Config/kvi.alias.conf"));
//	QString szFileName(QDir::homeDirPath());
//	szFileName+="/kvirc/Config/kvi.alias.conf";

	QFile config(szFileName.data());
	if(!config.exists()){
		config.open(IO_WriteOnly);
		config.close();
		createEmptyAliasList();
		return;
	}
	if(!config.open(IO_ReadOnly)){ cantReadError(); return; }
	//Write the alias number
	uint cnt;
	char dummyBuf[100];
	if(config.readBlock(dummyBuf,46)<0){ createEmptyAliasList(); return; };
	if(config.readBlock((char *)&cnt,sizeof(cnt))<0){ createEmptyAliasList(); return; };
	if(cnt==0){ createEmptyAliasList(); return; };

	for(uint i=0;i<cnt;i++){
		KviAliasStruct *lpA=new KviAliasStruct;
		uint len;
		char szBuffer[4096];
		if(config.readBlock((char *)&len,sizeof(len))<0){ cantReadError(); return; };
		if(len>4096){
			internalError();
			return;
		}
		if(config.readBlock(szBuffer,len)<0){ cantReadError(); return; };
		lpA->szName=QString(szBuffer,len+1);
		if(config.readBlock((char *)&len,sizeof(len))<0){ cantReadError(); return; };
		if(len>4096){
			internalError();
			return;
		}
		if(config.readBlock(szBuffer,len)<0){ cantReadError(); return; };
		lpA->szBuffer=QString(szBuffer,len+1);
		m_lpAliasList->append(lpA);
	}
	config.close();
	_debug_leavetrace("readFromFile");
}
//============ createEmptyAliasList ============//
void KviAliasManager::createEmptyAliasList()
{
	_debug_entertrace("createEmptyAliasList");
	while(!m_lpAliasList->isEmpty())m_lpAliasList->removeLast();
	_debug_leavetrace("createEmptyAliasList");
}
KviAliasStruct * KviAliasManager::getAlias(const char *szName){
	KviAliasStruct *pS=0;
	for(pS=m_lpAliasList->first();pS;pS=m_lpAliasList->next()){
		if(!strcasecmp(pS->szName.data(),szName))return pS;
	}
	return 0;
}
void KviAliasManager::addAlias(const char *szName,QString &szBuffer){
//	debug("szBuffer=%s",szBuffer.data());
	KviAliasStruct *pS=getAlias(szName);
	if(pS){
		pS->szBuffer=szBuffer.copy();
	} else {
		pS=new KviAliasStruct;
		pS->szName=QString(szName);
		pS->szBuffer=szBuffer.copy();
		m_lpAliasList->append(pS);
	}
}
void KviAliasManager::removeAlias(const char *szName){
	KviAliasStruct *pS=getAlias(szName);
	if(pS)m_lpAliasList->removeRef(pS);
}

//
// $Log: kvi_alias.cpp,v $
// Revision 1.6  1998/10/01 00:55:23  pragma
// Minor updates
//
// Revision 1.5  1998/09/20 20:21:56  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.4  1998/09/16 17:15:52  fritz
// Starting i18n.
//
// Revision 1.3  1998/09/16 16:13:03  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
// Revision 1.2  1998/09/16 03:14:49  pragma
// Added the 'Cancel' and 'Help (empty slot by now)' buttons to the
// alias dialog. Now it operates on a copy of the alias list.
//
//
