//   $Id: kvi_about.cpp,v 1.8 1998/10/06 14:42:02 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_defs.h"
#include "kvi_about.h"
#include "kvi_debug.h"
#include "kvi_macros.h"
#include "kvi_app.h"
#include "kvi_view.h"

#include <kiconloader.h>

#include <qpushbutton.h>

#define __txt(__par1,__par2) m_lpView->appendText(__par1,__par2);

//============ showHallOfFame ============//

void KviHallOfFame::showHallOfFame()
{
	_debug_entertrace("showHallOfFame");
	__txt(KVI_OUT_KVIRC,"\x02\x1fHALL OF FAME\x0f");
	__txt(KVI_OUT_KVIRC," ");
	__txt(KVI_OUT_KVIRC,i18n("This is a small list of people that"));
	__txt(KVI_OUT_KVIRC,i18n("have contributed to the KVirc project"));
	__txt(KVI_OUT_KVIRC,i18n("ordered chronologically."));
	__txt(KVI_OUT_KVIRC," ");
	__txt(KVI_OUT_KVIRC,"\x02 Szymon 'Pragma@ircnet' Stefanek");
	__txt(KVI_OUT_KVIRC,"     @ 'Impossible is possible...just read the manual'");
	__txt(KVI_OUT_KVIRC,"     @ 'I will add it tomorrow...'");
	__txt(KVI_OUT_KVIRC,"     Mental work , hand work ,");
	__txt(KVI_OUT_KVIRC,"     eyes consuming and coffee drinking");
	__txt(KVI_OUT_KVIRC,"     Mantainer of the project");
	__txt(KVI_OUT_KVIRC,"\x02 Diabl0!H3llFir3@ircnet");
	__txt(KVI_OUT_KVIRC,"     @ 'Did you read my mail?'");
	__txt(KVI_OUT_KVIRC,"     @ 'Bus report...'");
	__txt(KVI_OUT_KVIRC,"     Beta testing , bugs hunting ,");
	__txt(KVI_OUT_KVIRC,"     also a big ideas-source.");
	__txt(KVI_OUT_KVIRC,"\x02 Andrew 'Drosha@undernet' Frolov ");
	__txt(KVI_OUT_KVIRC,"     @ 'This free project is better than shareware");
	__txt(KVI_OUT_KVIRC,"     @ mirc for windows even in alpha verion.'"); 
	__txt(KVI_OUT_KVIRC,"     Beta testing,");
	__txt(KVI_OUT_KVIRC,"     ideator and mantainer of www.kvirc.org");
	__txt(KVI_OUT_KVIRC,"     homepage : http://www.linuxer.net");
	__txt(KVI_OUT_KVIRC,"\x02 Andras 'Pigmy@ircnet' Szigethy");
	__txt(KVI_OUT_KVIRC,"     Nick completion and parts of logging code");
	__txt(KVI_OUT_KVIRC,"\x02 RAD Kade 1");
	__txt(KVI_OUT_KVIRC,"     @ 'I'm just  *really* good at doing things");
	__txt(KVI_OUT_KVIRC,"     @ when I have no idea what I'm actually doing.'"); 
	__txt(KVI_OUT_KVIRC,"     Debugging and improvements");
	__txt(KVI_OUT_KVIRC,"     Auto nick completion");
	__txt(KVI_OUT_KVIRC,"\x02 Paul 'infected@ircnet' S. Boehm");
	__txt(KVI_OUT_KVIRC,"     @ '...it's enough for 100 IPs per meter");
	__txt(KVI_OUT_KVIRC,"     @ on earth , so every lightswitch can have");
	__txt(KVI_OUT_KVIRC,"     @ it's own IP...then you telnet to your");
	__txt(KVI_OUT_KVIRC,"     @ lightswitch and turn it off!'");
	__txt(KVI_OUT_KVIRC,"     Beta tester , language structure improvements");
	__txt(KVI_OUT_KVIRC,"     homepage : http://insecurity.net");
	__txt(KVI_OUT_KVIRC,"     homepage : http://paul.boehm.org");
	__txt(KVI_OUT_KVIRC,"\x02 Christian Riege");
	__txt(KVI_OUT_KVIRC,"     Ctcp sound code base");
	__txt(KVI_OUT_KVIRC,"\x02 Fritz 'KNFritz@ircnet' Elfert");
	__txt(KVI_OUT_KVIRC,"     Child windows resizing , i18n port,");
	__txt(KVI_OUT_KVIRC,"     conversion to Automake , deutch translation ,");
	__txt(KVI_OUT_KVIRC,"     'spiritual-guide' to the KDE Standards,");
	__txt(KVI_OUT_KVIRC,"     CVS repository mantainer...more stuff...");
	__txt(KVI_OUT_KVIRC,"\x02 '[Anodine]@EFnet' brentwood@hotmail.com");
	__txt(KVI_OUT_KVIRC,"     @ 'I can  program anything I set my mind to'");
	__txt(KVI_OUT_KVIRC,"     Various funky improvements.");
	__txt(KVI_OUT_KVIRC,"\x02 Konstantin 'Ponchik@ircnet' Vainer");
	__txt(KVI_OUT_KVIRC,"     kvirc@eGroups.com list moderator.");
	__txt(KVI_OUT_KVIRC,"     Creator of #kvirc on ircnet , the KVirc help channel.");
	__txt(KVI_OUT_KVIRC,"\x02 Russell 'russ-man@ircnet' Lambert");
	__txt(KVI_OUT_KVIRC,"     Beta tester and #kvirc channel moderator");
	__txt(KVI_OUT_KVIRC,"\x02 Crocodile from the x11amp staff");
	__txt(KVI_OUT_KVIRC,"     Beta tester, bug hunter ,ideas source...");
	__txt(KVI_OUT_KVIRC,"\x02 Ryan 'xPsycho' Smith");
	__txt(KVI_OUT_KVIRC,"     www.kvirc.org mirroring at http://kvirc.rscs.org");
	_debug_leavetrace("showHallOfFame");
}

#undef __txt


//============ KviHallOfFame ============//

KviHallOfFame::KviHallOfFame(QWidget *parent) : QDialog(parent,0,true)
{
	_debug_entertrace("KviHallOfFame");
	m_lpView = new KviView(this,_macro_kviApplication->m_lpFrm);
	m_lpDone = new QPushButton("Done",this);
	connect(m_lpDone,SIGNAL(clicked()),this,SLOT(accept()));
	m_lpView->setGeometry(10,10,480,360);
	m_lpView->show();
	m_lpView->m_bTimestamp=false;
	m_lpDone->setGeometry(10,375,480,26);
	setFixedSize(500,410);
	showHallOfFame();
	setCaption("Hall of fame");
	_debug_leavetrace("KviHallOfFame");
}

//============ ~KviHallOfFame ============//

KviHallOfFame::~KviHallOfFame()
{
	_debug_entertrace("~KviHallOfFame");
	delete m_lpView;
	delete m_lpDone;
	_debug_leavetrace("~KviHallOfFame");
}



//============ KviAboutDialog ============//

KviAboutDialog::KviAboutDialog(QWidget *parent) : QDialog(parent,0,true)
{
	_debug_entertrace("KviAboutDialog");
	m_lpDone  = new QPushButton("Done",this);
	connect(m_lpDone,SIGNAL(clicked()),this,SLOT(accept()));
	m_lpLogo  = new QLabel("",this);
	m_lpLogo->setBackgroundPixmap(_macro_kviIconLoader->loadIcon("kvilogobig.gif"));
	m_lpLogo->setFrameStyle(QFrame::Sunken|QFrame::Panel);
	m_lpLogo->setGeometry(10,10,390,340);
	m_lpDone->setGeometry(208,385,192,26);
	m_lpVers  = new QLabel(KVI_VERSION,this);
	m_lpVers->setAlignment(AlignCenter);
	m_lpVers->setGeometry(10,355,390,26);
	m_lpHall  = new QPushButton("Hall of fame",this);
	m_lpHall->setGeometry(10,385,192,26);
	connect(m_lpHall,SIGNAL(clicked()),this,SLOT(hallOfFame()));
	setFixedSize(410,420);
	setCaption("About KVirc");
	_debug_leavetrace("KviAboutDialog");
}

//============ ~KviAboutDialog ============//

KviAboutDialog::~KviAboutDialog()
{
	_debug_entertrace("~KviAboutDialog");
	delete m_lpLogo;
	delete m_lpDone;
	delete m_lpVers;
	_debug_leavetrace("~KviAboutDialog");
}

//============ hallOfFame ============//

void KviAboutDialog::hallOfFame()
{
	_debug_entertrace("hallOfFame");
	KviHallOfFame theDlg(this);
	theDlg.exec();
	_debug_leavetrace("hallOfFame");
}


#include "m_kvi_about.moc"

// $Log: kvi_about.cpp,v $
// Revision 1.8  1998/10/06 14:42:02  pragma
// Tons of changes
//
// Revision 1.7  1998/09/30 03:13:04  pragma
// Again bugfixes
//
// Revision 1.6  1998/09/29 14:03:20  pragma
// Minor hacks all around
//
// Revision 1.5  1998/09/28 13:00:45  pragma
// Some fun...
//
// Revision 1.4  1998/09/20 20:21:52  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.3  1998/09/15 15:20:06  fritz
// Converted to automake.
//
// Revision 1.2  1998/09/15 03:23:58  pragma
// Updated the about dialog, fixed another DCC fsend bug and removed a couple
// of compile time warnings.
//
