/*

  sysledd: sysledd.c

  Copyright 2015 Kadir Mueller <kadir.mueller@theflatnet.de>

  This program is free software; you may redistribute and/or modify it under
  the terms of the GNU General Public License Version 2 as published by the
  Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
  for complete details.

*/


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <libgen.h>
#include <limits.h>
#include <syslog.h>
#include <paths.h>
#include <sys/mman.h>


char ownname[PATH_MAX];


const char *model_strs[]={
	"TP-LINK TL-WR1043ND\n",
	"TP-LINK TL-WDR3600/4300/4310\n",
	"TP-LINK TL-WR1043ND v2\n",
	"TP-LINK Archer C7 board\n",
	"BHU BXU2000n-2 A1\n",
	"EasyLink EL-M150\n",
	"EasyLink EL-MINI\n",
	"GS OOLITE V1.0\n",
	"HiWiFi HC6361\n",
	"MERCURY MAC1200R\n",
	"NC-LINK SMART-300\n",
	"TP-LINK TL-MR13U\n",
	"TP-LINK TL-MR3220\n",
	"TP-LINK TL-MR3420\n",
	"TL-WR841N-v7\n",
	"TP-LINK TL-WA701ND v2\n",
	"TP-LINK TL-WA830RE v2\n",
	"TP-LINK TL-WA901ND v2\n",
	"TP-LINK TL-WA901ND\n",
	"TP-LINK TL-WA801ND v2\n",
	"TP-LINK TL-WDR3500\n",
	"TP-LINK TL-WR1041N v2\n",
	"TP-LINK TL-WR703N\n",
	"TP-LINK TL-WR720N v3\n",
	"TP-LINK TL-WR741ND  v4\n",
	"TP-LINK TL-WR741ND\n",
	"TP-LINK TL-WR841N/ND v8\n",
	"TP-LINK TL-WR841N v1\n",
	"TP-LINK TL-WR941ND\n",
	"unknown"
};
const char model_gpios[]={
	2, 14, 19, 14, 14, 27, 27, 27, 1, 14, 15, 27, 1, 1, 1, 27, 14, 2, 1, 14, 14, 12, 27, 27, 27, 1, 14, 2, 2
};


int
gpioinit() {
	int fd, l;
	char buf[255], gpion[4];

	fd=open("/proc/cpuinfo", O_RDONLY);
	read(fd, buf, sizeof(buf));
	for(l=0; (l<sizeof model_gpios)&&(strstr(buf, model_strs[l])==NULL); l++);
	close(fd);
	if(l==sizeof model_gpios) {
		fprintf(stderr, "Unable to determining hardware type from /proc/cpuinfo, exiting.\n");
		exit(1);
	}
	sprintf(gpion, "%i", model_gpios[l]);
	fd=open("/sys/devices/platform/leds-gpio/driver/unbind", O_WRONLY);
	if(fd>0) {
		write(fd, "leds-gpio", 9);
		close(fd);
	}
	fd=open("/sys/class/gpio/unexport", O_WRONLY);
	if(fd>0) {
		write(fd, gpion, strlen(gpion));
		close(fd);
	}
	fd=open("/sys/class/gpio/export", O_WRONLY);
	if(fd<0) {
		fprintf(stderr, "Error opening gpio direction file: \"%s\": %s.\n", "direction", strerror(errno));
		exit(1);
	}
	if(write(fd, gpion, strlen(gpion))!=strlen(gpion)) {
		fprintf(stderr, "Error configuring GPIO %s for output: %s.\n", gpion, strerror(errno));
		exit(1);
	}
	close(fd);
	sprintf(buf, "/sys/class/gpio/gpio%s/direction", gpion);
	fd=open(buf, O_RDONLY);
	if(fd<0) {
		fprintf(stderr, "Error opening gpio direction file \"%s\": %s.\n", buf, strerror(errno));
		exit(1);
	}
	read(fd, buf, sizeof buf);
	close(fd);
	if(strncmp(buf, "out", 3)!=0) {
		fprintf(stderr, "Error: Was unable to set GPIO %s for output?\n", gpion);
		exit(2);
	}

	sprintf(buf, "/sys/class/gpio/gpio%s/value", gpion);
	fd=open(buf, O_RDWR);
	if(fd<0) {
		fprintf(stderr, "Error opening gpio value file: \"%s\": %s.\n", buf, strerror(errno));
		exit(3);
	}
	return fd;
}


void
daemonize() {
	int pidfilefd;
	char pidfile[PATH_MAX], pidstr[10];


	switch(fork()) {
		case -1:	fprintf(stderr, "%s: unable to fork() while initializing: %s. Exiting.", ownname, strerror(errno));
				syslog(LOG_DAEMON|LOG_ERR, "unable to fork() while initializing: %s. Exiting.", strerror(errno));
				exit(0);

		case  0:	break;

		default:	exit(0);
	}

	snprintf(pidfile, sizeof pidfile, _PATH_VARRUN"%s.pid", ownname);
	//snprintf(pidfile, sizeof pidfile, "/tmp/%s.pid", ownname);	/* DEBUG - FIXME! */
	pidfilefd=open(pidfile, O_CREAT|O_TRUNC|O_WRONLY, S_IRUSR|S_IWUSR|S_IRGRP);
	if(pidfilefd>0) {
		snprintf(pidstr, sizeof pidstr, "%i\n", (int)getpid());
		write(pidfilefd, pidstr, strlen(pidstr));
		close(pidfilefd);
	}
	chmod(pidfile, S_IRUSR|S_IWUSR|S_IRGRP);

	freopen("/dev/null", "r", stdin);
	freopen("/dev/null", "w", stdout);
	freopen("/dev/null", "w", stderr);
}


int
main(int argc, char *argv[]) {
	int gpiofd, usleepfor=100, up=1;

	strncpy(ownname, basename((char *)argv[0]), sizeof ownname);
	gpiofd=gpioinit();
	daemonize();

	for(;;) {
		if(write(gpiofd, "0", 1)==1) {
			usleep(usleepfor*200);
			write(gpiofd, "1", 1);
			usleep((100-usleepfor)*300);
			if(usleepfor==100)
				up=0;
			if(usleepfor==0)
				up=1;
			if(up)
				usleepfor+=1;
			else
				usleepfor-=1;
		}
		else {
			fprintf(stderr, "Error writing gpiofd: %s.\n", strerror(errno));
			return 4;
		}
	}

	return 0;
}

