/*

  scsi_admin: global.h

  Copyright 2001, 2002, 2005, 2007 Kadir A. Mueller <kadir.mueller@theflatnet.de>

  This program is free software; you may redistribute and/or modify it under
  the terms of the GNU General Public License Version 2 as published by the
  Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
  for complete details.

*/


#ifndef HAVE_SCSI_ADMIN_GLOBAL_H
#define HAVE_SCSI_ADMIN_GLOBAL_H

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <termios.h>
#include <dirent.h>
#include <errno.h>
#include <libgen.h>	/* dirname and (!) basename - last is a little bit */
			/* weird (XPG)... FIXME: Needs this to be portable??!*/
#include <string.h>
#include <limits.h>	/* for PATH_MAX */

#include <scsi/scsi.h>
#include <scsi/scsi_ioctl.h>
#include <scsi/sg.h>



#define CMD_MAXLEN      9	/* That's 8 for the command, 1 for do scan or don't. */

#define EPARAM		65536
#define ENODEVICE	65537
#define ECMDNOTIMP	65538
#define ENOPROCFS	65539
#define ENOSYSFS	65540
#define EDEVEXISTS	65541

int setdevvars(char *devicestr);
void scsi_devinfo();
int scsi_doorlock();
int scsi_doorunlock();
int scsi_start_unit();
int scsi_stop_unit();
int scsi_test_unit_ready();
int scsi_format_unit();
int proc_add_single_device();
int proc_remove_single_device();
int cmd_info();
int cmd_lock();
int cmd_unlock();
int cmd_open();
int cmd_close();
int cmd_start();
int cmd_stop();
int cmd_test();
int cmd_add();
int cmd_remove();
int cmd_swap();
int cmd_format();
int cmd_reset();
int cmd_help();


#endif /* HAVE_SCSI_ADMIN_GLOBAL_H */

