/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import netscape.debug.Debugger;
import netscape.debug.ThreadHook;
import netscape.debug.ThreadState;

public class Thread
implements Runnable {
    private char[] name;
    private int priority;
    private Thread threadQ;
    private int PrivateInfo;
    private int eetop;
    private boolean single_step;
    private boolean daemon = false;
    private boolean stillborn = false;
    private Runnable target;
    private static Thread activeThreadQ;
    private ThreadGroup group;
    private static int threadInitNumber;
    private ThreadHook hook;
    private ThreadState debugState;
    private boolean inDebugSuspend;
    private int initial_stack_memory;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public static native Thread currentThread();

    public static native void yield();

    public static native void sleep(long var0) throws InterruptedException;

    public static void sleep(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        Thread.sleep(l);
    }

    private void init(ThreadGroup threadGroup, Runnable runnable, String string) {
        this.init(threadGroup, runnable, string, false);
    }

    private void init(ThreadGroup threadGroup, Runnable runnable, String string, boolean bl) {
        Thread thread = Thread.currentThread();
        if (threadGroup == null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                threadGroup = securityManager.getThreadGroup();
            }
            if (threadGroup == null) {
                threadGroup = thread.getThreadGroup();
            }
        } else if (bl) {
            threadGroup.checkAccess();
        }
        this.group = threadGroup;
        this.daemon = thread.isDaemon();
        this.priority = thread.getPriority();
        this.name = string.toCharArray();
        this.target = runnable;
        SecurityManager.enablePrivilege("UniversalThreadAccess");
        this.setPriority(this.priority);
        SecurityManager.revertPrivilege();
        threadGroup.add(this);
    }

    public Thread() {
        this.init(null, null, "Thread-" + Thread.nextThreadNum(), true);
    }

    public Thread(Runnable runnable) {
        this.init(null, runnable, "Thread-" + Thread.nextThreadNum(), true);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this.init(threadGroup, runnable, "Thread-" + Thread.nextThreadNum(), true);
    }

    public Thread(String string) {
        this.init(null, null, string, true);
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this.init(threadGroup, null, string, true);
    }

    public Thread(Runnable runnable, String string) {
        this.init(null, runnable, string, true);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        this.init(threadGroup, runnable, string, true);
    }

    public synchronized native void start();

    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    private void exit() {
        if (this.group != null) {
            this.group.remove(this);
            this.group = null;
        }
        this.target = null;
    }

    public final void stop() {
        SecurityManager.enablePrivilege("UniversalThreadAccess");
        this.stop(new ThreadDeath());
    }

    public final synchronized void stop(Throwable throwable) {
        System.getSecurityManager().checkAccess(this, throwable);
        this.resume();
        this.stop0(throwable);
    }

    public void interrupt() {
        System.getSecurityManager().checkAccess(this);
        this.interrupt0();
    }

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted(true);
    }

    public boolean isInterrupted() {
        return this.isInterrupted(false);
    }

    private native boolean isInterrupted(boolean var1);

    public void destroy() {
        throw new NoSuchMethodError();
    }

    public final native boolean isAlive();

    public final void suspend() {
        System.getSecurityManager().checkAccess(this);
        if (Debugger.getDebugManager() == null) {
            System.err.println("Warning: Thread.suspend() was called; Navigator deadlock might result");
        }
        this.suspend0();
    }

    public final void resume() {
        System.getSecurityManager().checkAccess(this);
        this.resume0();
    }

    public final void setPriority(int n) {
        if (!SecurityManager.isPrivilegeEnabled("UniversalThreadAccess")) {
            return;
        }
        System.getSecurityManager().checkAccess(this);
        if (n > 10 || n < 1) {
            throw new IllegalArgumentException();
        }
        if (n > this.group.getMaxPriority()) {
            n = this.group.getMaxPriority();
        }
        this.priority = n;
        this.setPriority0(this.priority);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setName(String string) {
        System.getSecurityManager().checkAccess(this);
        this.name = string.toCharArray();
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray);
    }

    public native int countStackFrames();

    /*
     * Unable to fully structure code
     */
    public final synchronized void join(long var1_1) throws InterruptedException {
        var3_2 = System.currentTimeMillis();
        var5_3 = 0L;
        if (var1_1 < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (var1_1 != 0L) ** GOTO lbl13
        while (this.isAlive()) {
            this.wait(20L);
        }
        return;
        while ((var7_4 = var1_1 - var5_3) > 0L) {
            this.wait(var7_4);
            var5_3 = System.currentTimeMillis() - var3_2;
lbl13:
            // 2 sources

            if (this.isAlive()) continue;
        }
    }

    public final synchronized void join(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        this.join(l);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public final void setDaemon(boolean bl) {
        System.getSecurityManager().checkAccess(this);
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.daemon = bl;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public void checkAccess() {
        System.getSecurityManager().checkAccess(this);
    }

    public String toString() {
        if (this.getThreadGroup() != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + this.getThreadGroup().getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + "" + "]";
    }

    private native void setPriority0(int var1);

    private native void stop0(Object var1);

    private native void suspend0();

    private native void resume0();

    private native void interrupt0();
}

