//==============================
//Expert Quake Overlay Constants
//==============================

//I prefer picky compilers, thank you...
#ifdef _WIN32
#pragma warning(default : 4100 4127 4701 4054)
#pragma warning(default : 4136 4051 4018 4305)
#endif

//screen dimensions
//WARNING. Picture filenames larger than 1 char are not currently supported
//WARNING: Remember to change MAX_HORIZ/VERT if you changed ScrWidth/Height
#define MAX_SCREENS 3 //number of different screen size settings
#define INIT_SCREEN 1
short scrWidth[MAX_SCREENS] = {0, 32, 64};
short scrHeight[MAX_SCREENS] = {0, 32, 64};
#define PIC_CHARS 2 //length of a pic filename, including null
#define MAX_HORIZ 65 //highest scrHeight + 1
#define MAX_VERT 65 //highest scrWidth + 1

//overlay help
#define LEGEND_SINGLE "Green dots are weapons. Yellow dots are powerups. Magenta dots refer to secret areas on your level. Red dots are secrets above you, and blues are below you.\n"
#define LEGEND_DM "Green dots are weapons. Yellow dots are powerups. Items still appear on screen even if they have been picked up. This is to prevent people from having too much knowledge about player movements.\n"

//defaults
#define INIT_HSCALE 100
#define INIT_VSCALE 100
#define INIT_HPOS 4
#define INIT_VPOS 4
#define INIT_MODE (8+16+512+1024) //see clMode bitvector

//for z axis plotting
#define ABOVE_FEET 64
#define BELOW_FEET -64
#define PLOT_ABOVE "r"
#define PLOT_BELOW "b"

//images - remember to modify LoadImages to precache your additions
char scrPic[MAX_SCREENS][PIC_CHARS] = {"\0","1","2"};
#define NOPIC "0"
#define SELF "h"
#define WEAP "g"
#define POWER "y"
#define SECRET "r"

//clMode bitvector
#define ISVALID		1 << 0 // 1, MUST be on.
#define RADARON		1 << 1 // 2, default on
#define BARON		1 << 2 // 4, default on
#define SHOWBACK	1 << 3 // 8
#define SHOWSELF	1 << 4 // 16
#define NOROTATE	1 << 5 // 32
#define ZVERT		1 << 6 // 64
#define	SHOWAMMO	1 << 7 //ammo statusbar
#define DEBUGON		1 << 8
#define SHOWWEAP	1 << 9 // 512
#define SHOWPOWER	1 << 10// 1024
#define MATRIXON	1 << 11// 2048

#define PLOT_EDGE 1 //for plot(flags) 
#define PLOT_FORCE 2
#define PLOT_Z 4
#define PLOT_ALTZ 8  //not implemented

//string lengths
#define LAYOUT_CHARS 1400
#define LAYOUT_SAFE 1398
#define STRING_CHARS 1024 //nice round number

// Radar variables
static char blip[MAX_HORIZ][MAX_VERT][PIC_CHARS];
static qboolean IsColumn[MAX_HORIZ]; //if there are any blips in that column
static unsigned short hpos, vpos, hscale, vscale, curMode, curScreen; //current player's settings
static edict_t *mpedCur = NULL; //current player

// Matrix variables
#define MINPLAYERS 4 //always allocate room for these many players
static byte* mpaTranslateRank = NULL; //translation table to access the KillsVersus arrays, sorted by rank
static byte mcPlayersAllocated = 0; //number of players allocated for all arrays

// ===================
//  Utility Functions
// ===================

#define ElementSize(a) (sizeof(a[0]))

qboolean fStrMatch(char *psLeft, char *psRight)
{
	if (Q_stricmp(psLeft, psRight) == 0) return true;
	return false;
}

void SetIntKey(char sKey[32], int Value)
{
	char sCommand[64];
	Com_sprintf(sCommand, sizeof(sCommand), 
		"set %s %i u \n", sKey, Value);
	StuffCmd(mpedCur, sCommand);
}

unsigned short KeyToShort(char *psKey)
{
	int value;
	value = atoi(Info_ValueForKey(mpedCur->client->pers.userinfo, psKey));
	if (value < 0 || value > 32767) return 0;
	return value;
}

qboolean ExpertFlags(int Bit) 
{
	if ((int)sv_expflags->value & Bit)
		return true;
	return false;
}

//Prototypes
void DecodeConfig(edict_t* pedNew);
