/*
	e_gbstat.h

	Deffinitions specific to e_gbstat.c file

	Credit is due to:
		GibStat page at: http://www.planetquake.com/gibstat
		Great idea for a modification! I plan to follow this standard where ever
		it's applicable to a Q2 project I work on.
*/


/* 
	Version 1.2 GibStats Standard
*/

#define GS_VERSION						"1.2"				// GibStats Version

/*	Log Start/Stop Constants		*/

#define GS_LOG_START					"\t\tStdLog\t%s\n"
#define GS_GAME_START					"\t\tGameStart\t\t\t%s\n"
#define GS_GAME_END						"\t\tGameEnd\t\t\t%s\n"
#define GS_PATCH_NAME					"\t\tPatchName\t%s\n"
#define GS_LOG_DATE						"\t\tLogDate\t%02u%02u%02u\n"
#define GS_LOG_TIME						"\t\tLogTime\t%02u:%02u.%02u\n"
#define GS_DM_SETTINGS					"\t\tLogDeathFlags\t%u\n"
#define GS_MAP_NAME						"\t\tMap\t%s\n"

/*	Player Info						*/
#define GS_PLAYER_INFO					"\t\tPlayer\t%s\t%s\t%u\n"

#define GS_PLAYER_DROP					"\t\tPlayerLeft\t%s\t\t%u\n"
#define GS_PLAYER_CONNECT				"\t\tPlayerConnect\t%s\t%s\t%u\n"

#define GS_PLAYER_TEAM_CHANGE			"\t\tPlayerTeamChange\t%s\t%s\t%u\n"
#define GS_PLAYER_NAME_CHANGE			"\t\tPlayerRename\t%s\t%s\t%u\n"

#define GS_SCORE						"%s\t%s\t%s\t%s\t%i\t%u\t%u\n"

#define GS_TYPE_KILL					"kill"
#define GS_TYPE_SUICIDE					"suicide"

#define GS_EMPTY_STRING					""

/*	The following are here for future CTF support	*/

#define GS_TYPE_CTF_CAPTURE				"Flag Capture"
#define GS_TYPE_CTF_RETURN				"Flag Return"
#define GS_TYPE_CTF_FLAG_DEFENSE		"Flag Defense"
#define GS_TYPE_CTF_CARRIER_DEFENSE		"Carrier Defense"
#define GS_TYPE_CTF_CARRIER_KILL		"Carrier Kill"
#define GS_TYPE_CTF_CARRIER_SAVE		"Carrier Save"

/* 
	Version 1.1 GibStats Standard

#define GS_GAME_START					"\t\tGame\tStart\n"
#define GS_GAME_END						"\t\tGame\tEnd\n"

#define GS_MAP_INFO						"\t\tMap\t%s\n"
#define GS_PLAYER_INFO					"\t\tPlayer\t%s\n"
#define GS_PLAYER_INFO_TEAM				"\t\tPlayer\t%s\t%s\n"

#define GS_FRAG_LOG						"%s\t%s\t%s\t%s\t%+i\t%f2\t%u\n"

#define GS_PLAYER_CONNECT				"Player\t%s\t\n"
#define GS_PLAYER_CONNECT_TEAM			"\t\tPlayer\t%s\t%s\n"
#define GS_PLAYER_DISCONNECT			"\t\tPlayer\tLeft\t%s\n"

#define GS_PLAYER_CHANGE_TEAM			"\t\tPlayer\t%s\t%s\n"

#define GS_TYPE_KILL					"kill"
#define GS_TYPE_SUICIDE					"suicide"

*/