/*
Copyright (C) 1997  Jonathan Simantov <reptile@interport.net>
Released under the GNU General Public License.
See the included LICENSE file for GPL information.
*/

#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>

/* Headers to show - all others are omitted. */
char *headers[] = { "To: ", "From: ", "Cc: ", "Subject: ", "Date: ",
		   "Reply-To: ", NULL};

/* Size to truncate messages to. */
#define TRUNCATESIZE 4096

/* You shouldn't need to change this. */
#define CMDFILE "makedocs" 

#define PILOTPORT "/dev/pilot"

/* This chooses what line from the header you want to show as the title of
   the Doc document. */
#define HDRLINE "Subject: "

int main()
{
  FILE *outfile=NULL;
  FILE *cmdfile = fopen(CMDFILE, "w");
  struct stat filestat;
  char filename[20];
  char filesubj[80];
  char filesubjtmp[80];
  int n=0, filetop=0, i,j;
  char buf[1024];
  char **p;
  while (!feof(stdin))
    {
      fgets(buf, 1023, stdin);
      if (!strncmp(buf, "From ", 5) && !filetop)
	{
	  if (outfile)
	    {
	      printf("Reading message %d...\n", n);
	      fprintf(cmdfile, "makedoc %s %s.prc \'%02d. %s\' >/dev/null\n", filename, filename, n, filesubj);
	      fclose(outfile);
	      stat(filename, &filestat);
	      if (filestat.st_size > TRUNCATESIZE)
		{
		  truncate(filename, TRUNCATESIZE); /* truncate if too big */
		  outfile = fopen(filename, "a");
		  fprintf(outfile, "\n\n*** Message truncated after %d bytes. ***\n", TRUNCATESIZE);
		  fclose(outfile);
		}
	    }
	  sprintf(filename, "mymail.%d", ++n);
	  outfile = fopen(filename, "w");    
	  filetop = 1;
	  strcpy(filesubj, "");
	}
      if (buf[0] == '\n')
	{
	  filetop = 0;
	}
      if (filetop)
	{
	  if (!strncmp(buf, HDRLINE, strlen(HDRLINE)))
	    {
	      strncpy(filesubj, buf + strlen(HDRLINE), 80);
	      if (filesubj[strlen(filesubj)-1] == '\n')
		{
		  filesubj[strlen(filesubj)-1] = '\0';
		}
	      strncpy(filesubjtmp, filesubj, 80);
	      for (i=0, j=0; j < 80; i++, j++)
		{
		  if (filesubjtmp[i] == '\'')
		    {
		      if (j < 76)
			{
			  filesubj[j++] = '\'';
			  filesubj[j++] = '\\';
			  filesubj[j++] = '\'';
			}
		      else
			
			{
			  filesubj[j] = '\0';
			  break;
			}
		    }
		  filesubj[j] = filesubjtmp[i];
		}
	    }
	  p = headers;
	  while (*p)
	    {
	      if (!strncmp(buf, *p, strlen(*p)))
		{
		  fputs(buf, outfile);
		}
	      p++;
	    }
	}
      else
      fputs(buf, outfile);
    
    }
  if (!n) return 1;
  printf("Reading message %d...\n", n);
  fprintf(cmdfile, "makedoc %s %s.prc \'%02d. %s\' >/dev/null\n", filename, filename, n, filesubj);
  fclose(outfile);
  stat(filename, &filestat);
  if (filestat.st_size > TRUNCATESIZE)
    {
      truncate(filename, TRUNCATESIZE); /* truncate if too big */
      outfile = fopen(filename, "a");
      fprintf(outfile, "\n\n*** Message truncated after %d bytes. ***\n", TRUNCATESIZE);
      fclose(outfile);
    }
  
  fprintf(cmdfile, "\n");
  fclose(cmdfile);
  chmod(CMDFILE, S_IREAD | S_IWRITE | S_IEXEC);
  return 0;
}

