/*
 * PilotMines is Copyright (c) 1997-1999 by Thomas Pundt
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose, without fee, and without a written agreement is hereby granted,
 * provided that the above copyright notice and this paragraph and the
 * following two paragraphs appear in all copies.
 *
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 * THE AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */

#include <Common.h>
#include <System/KeyMgr.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "minercp.h"
#include "mine.h"
#include "hscore.h"

int insertPos;

static VoidPtr Id2Ptr(Word id)
{
  FormPtr frm = FrmGetActiveForm();
  return FrmGetObjectPtr(frm, FrmGetObjectIndex(frm,id));
}

void InitHighScore()
{
  int i,j;
  for (i=0; i<3; i++)
    for (j=0; j<4; j++) {
      game.hscore[i][j].score   = 0;
      game.hscore[i][j].name[0] = 0;
      game.hscore[i][j].date    = 0;
    }
}

Boolean isHighScore(int score)
{
  int i;

  for (i=0; i<5; i++) {
    if (game.hscore[game.level][i].score != 0 
        && game.hscore[game.level][i].score <= score)
      continue;
    return true;
  }
  return false;
}

static void DrawScoreAt(int score, ULong when, SWord x, SWord y)
{
  DateTimeType date;
  SystemPreferencesType sysPrefs; 
  char buf[20];

  if (!score)
    return;

  StrCopy(buf,"00:00");
  
  if (score>3559)
    score = 3559;
  buf[4] = score % 10 + 48;
  buf[3] = (score / 10) % 6 + 48;
  buf[1] = (score / 60) % 10 + 48;
  buf[0] = (score / 600) % 10 + 48;
  WinDrawChars(buf, 5, x, y);

  TimSecondsToDateTime(when, &date);
  PrefGetPreferences (&sysPrefs);
  DateToAscii(date.month, date.day, date.year, sysPrefs.dateFormat, buf);
  WinDrawChars(buf, StrLen(buf), x+35, y);

}

static void InsertHighScore(int score)
{
  int j;
  VoidHand handle;
  CharPtr name;
  FieldPtr fld;
  FormPtr frm;
  FontID tmp;
  char buf[8];

  StrCopy (buf, "Level 0");
  insertPos = 5;

  tmp = FntSetFont(boldFont);

  if (score) {
    for (insertPos=0; insertPos<5; insertPos++) {
      if (game.hscore[game.level][insertPos].score != 0 
          && game.hscore[game.level][insertPos].score <= score)
        continue;
      for (j=3; j>=insertPos; j--) {
        game.hscore[game.level][j+1].score = game.hscore[game.level][j].score;
        game.hscore[game.level][j+1].date  = game.hscore[game.level][j].date;
        game.hscore[game.level][j].name[10] = 0;
        StrCopy(game.hscore[game.level][j+1].name, 
                game.hscore[game.level][j].name);
      }
      game.hscore[game.level][insertPos].score = score;
      game.hscore[game.level][insertPos].date  = TimGetSeconds();

      fld = Id2Ptr(ID_HighScoreField+insertPos);

      if (!(handle = (VoidHand)FldGetTextHandle(fld))) {
        handle = MemHandleNew(NAMLEN*sizeof(char));
        name = MemHandleLock(handle);
        name[0] = '\0';
        MemHandleUnlock(handle);
        FldSetTextHandle(fld, (Handle)handle);
      } else {
        name = MemHandleLock(handle);
        name[0] = '\0';
        MemHandleUnlock(handle);
      }

      FldSetUsable(fld, true);
      FldDrawField(fld);
      frm = FrmGetActiveForm();
      FrmSetFocus(frm, FrmGetObjectIndex(frm, ID_HighScoreField+insertPos));

      break;
    }
  }

  buf[6] = game.level+49;
  WinDrawChars(buf, 7, 60, 15);

  for (j=0; j<5; j++) {
    if (j!=insertPos) {
      WinDrawChars(game.hscore[game.level][j].name, 
                   StrLen(game.hscore[game.level][j].name), 5, 45+j*15 );
    }
    DrawScoreAt(game.hscore[game.level][j].score,
                game.hscore[game.level][j].date, 75,45+j*15);
  }

  FntSetFont(tmp);  

}

static void CloseHighScore()
{
  FieldPtr fld;
  CharPtr  name;

  if (insertPos<5) {
    fld = Id2Ptr(ID_HighScoreField+insertPos);
    name = FldGetTextPtr(fld);
    StrCopy(game.hscore[game.level][insertPos].name, name ? name:"");
    FldSetUsable(fld, false);
  }
}

Boolean HighscoresFormHandleEvent(EventPtr e)
{
  Boolean handled;
  
  CALLBACK_PROLOGUE
  handled = false;
  
  switch (e->eType) {

  case frmOpenEvent:
    FrmDrawForm(FrmGetActiveForm());
    InsertHighScore(score);
    handled = true;
    break;

  case ctlSelectEvent:
    if (e->data.ctlSelect.controlID == ID_HighScoreDone) {
      CloseHighScore();
      FrmReturnToForm(0);
      score = 0;
      insertPos = 0;
      handled = true;
    }
    break;

  default:
    break;
  }
  
  CALLBACK_EPILOGUE
  return handled;
}
