/*
	switchd rev.0.1 by Andreas H. Mueller 070796.
	Read COPYING for copyright information.
*/

#include <stdio.h>
#include <asm/io.h>
#include <unistd.h>
#include <stdlib.h>

#include "config.h"

#define MAXPARAMS 1

char getio(char ownname[])
{
	if (ioperm(PORT, 1, 1)) {
		fprintf(stderr, "%s: Error: Unable to get io-permissions. Possibly not run as root?\n", ownname);
		exit(5);
	}
	else {
		return 0;
	}
}

void do_switch()
{
	for(;;) {
		if (inb(PORT) == ON) {
			system(SCRIPT1);
			while(inb(PORT)==ON) {
				usleep(500000);
			}
		}
		else {
			if (inb(PORT) == OFF) {
						system(SCRIPT2);
						while(inb(PORT)==OFF) {
							usleep(500000);
						}
			}
		}
	usleep(100000);
	}
}

int main(int argc, char *argv[])
{
	switch(fork()) {
		case 0: /* I am the child */
			getio(argv[0]);
			do_switch();
		case -1: /* fork failed */
			fprintf(stderr, "hercd: can't fork.\n");
			exit(1);
		default: /* I am the parent */
			return(0);
	}
}
/*
	getio(argv[0]);
	for(;;) {
		printf("%i\n", inb(PORT));
		sleep(1);
	}
	return 4;
*/
