#include <stdio.h>
#include <asm/io.h>
#include <unistd.h>

#include "config.h"

#define MAXPARAMS 1

char getio(char ownname[])
{
  if (ioperm(PORT, 1, 1))
  {
    fprintf(stderr, "%s: Error: Unable to get io-permissions. Possibly not run as root?\n", ownname);
    exit(5);
  }
  else
  {
    return 0;
  }
}

int main(int argc, char *argv[])
{
  if (argc!=MAXPARAMS)
  {
    if (argc==2)
    {
      if (!memcmp(argv[1], "-", 1))
      {
        if (!strcmp(argv[1], "--help"))
        {
          fprintf(stderr, "\n  %s rev.1.0 by Andreas H. Mueller in 1995.\n\n", argv[0]);
          fprintf(stderr, "  Usage : %s <on> | <off> | <--help>\n\n", argv[0]);
          fprintf(stderr, "   This utility toggles between 0x%02x (on) and 0x%02x (off) at port 0x%x,\n", ON, OFF, PORT);
          fprintf(stderr, "  This is not much, but everything I need for my purposes.\n");
          fprintf(stderr, "   Note that %s must be SUID root if non-root-users should use it!\n", argv[0]);
          fprintf(stderr, "\n   %s returns the following error-codes:\n", argv[0]);
          fprintf(stderr, "\n  1 : Help called.\n");
          fprintf(stderr, "  2 : Unknown option.\n");
          fprintf(stderr, "  3 : Unknown parameter.\n");
          fprintf(stderr, "  4 : Missing argument.\n");
          fprintf(stderr, "  5 : Unable to get io-permissions.\n\n");
          return 1;
        }
        else
        {
          if (!strcmp(argv[1], "-RN"))
          {
            printf("  The original name of this tool is light, the revision is 1.0.\n");
            return 0xff;
          }
          else
          {
            fprintf(stderr, "%s: Error: Unknown option.\n", argv[0]);
            fprintf(stderr, "Try %s --help for usage information.\n", argv[0]);
            return 2;
          }
        }
      }
      else
      {
        if (!strcmp(argv[1], "on"))
        {
          getio(argv[0]);
          outb(ON, PORT);
          return 0;
        }
        else
        {
          if (!strcmp(argv[1], "off"))
          {
            getio(argv[0]);
            outb(OFF, PORT);
            return 0;
          }
          else
          {
            fprintf(stderr, "%s: Error: Unknown parameter (%s).\n", argv[0], argv[1]);
            fprintf(stderr, "Try %s --help for usage information.\n", argv[0]);
            return 3;
          }
        }
      }
    }
    else
    {
      fprintf(stderr, "%s: Error: Too much parameters.\n", argv[0]);
      fprintf(stderr, "Try %s --help for usage information.\n", argv[0]);
      return 3;
    }
  }
  fprintf(stderr, "%s: Error: Missing argument.\n", argv[0]);
  fprintf(stderr, "Try %s --help for usage information.\n", argv[0]);
  return 4;
}
