/*
	userd rev.1.0 by Andreas H. Mueller 092897.
	Read COPYING for copyright information.
*/

#include <stdio.h>
#include <asm/io.h>
#include <unistd.h>
#include <stdlib.h>
#include <utmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sched.h>

#include "config.h"

#define MAXPARAMS 1

#define PORTSTAT PORT+2
#define SLEEPDELAY DELAY*1000
#define LEFT 6
#define RIGHT 0

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif


char getio(char ownname[])
{
	if(ioperm(PORT, 1, 1) | ioperm(PORTSTAT, 1, 1)) {
		fprintf(stderr, "%s: Error: Unable to get io-permissions. Possibly not run as root?\n", ownname);
		exit(5);
	}
	else {
		return 0;
	}
}

void checkfile_utmp(char ownname[])
{
	if(open(_PATH_UTMP, O_RDONLY) == -1) {
		fprintf(stderr, "%s: Error: Unable to open %s.\nCheck your %s or correct /usr/include/utmp.h.\n", ownname, _PATH_UTMP, _PATH_UTMP);
		exit(2);
	}
}

void do_usercnt()
{

	int fd;
	FILE *fp;
	register int cnt, i;
	register char dispstat=1;
	register div_t disp;
	register pid_t prev_pid=0;
	struct utmp ut;
	char nouser[]="        ";
	const unsigned char table[]={63,  6, 91, 79, 102, 109, 125, 7, 127, 111};
	struct sched_param schpar = { PRIORITY_REAL };
	sched_setscheduler(getpid(), SCHED_RR, &schpar);

        fp = fopen(_PATH_VARRUN"/userd.pid", "w");
        if (fp != NULL) {
                fprintf(fp, "%d\n", getpid());
                 fclose(fp);
        }
	fd=open(_PATH_UTMP, O_RDONLY);
	for(;;)  {
		lseek(fd, 0, SEEK_SET);
		cnt=prev_pid=0; i=1;
		while((i!=0) && (cnt!=99)) {
			i=read((int)fd, (char *) &ut, sizeof(struct utmp));
			if((ut.ut_type==USER_PROCESS) &&
			  (!((strcmp(ut.ut_user, nouser))==-1)) &&
			  (ut.ut_pid!=prev_pid)) {
				prev_pid=ut.ut_pid;
				cnt++;
			}
		}
		disp=div(cnt, 10);
		if(dispstat==LEFT) {
			outb(table[disp.quot], PORT);
			dispstat=RIGHT;
		}
		else {
			outb(table[disp.rem], PORT);
			dispstat=LEFT;
		}
		outb(dispstat, PORTSTAT);
		usleep(SLEEPDELAY);
	}
}

int main(int argc, char *argv[])
{
	getio(argv[0]);
	checkfile_utmp(argv[0]);
	switch(fork()) {
		case 0: /* I am the child */
			getio(argv[0]);
			do_usercnt();
		case -1: /* fork failed */
			fprintf(stderr, "%s: can't fork.\n", argv[0]);
			exit(1);
		default: /* I am the parent */
			return(0);
	}
}

