/*
 *  ALSA sequencer System Client
 *  Copyright (c) 1998 by Frank van de Pol <frank@vande-pol.demon.nl>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __SND_SEQ_SYSTEM_H
#define __SND_SEQ_SYSTEM_H

#include "seq_kernel.h"


/* entry points for broadcasting system events */
extern void snd_seq_system_client_ev_client_start(int client);
extern void snd_seq_system_client_ev_client_exit(int client);
extern void snd_seq_system_client_ev_client_change(int client);

extern void snd_seq_system_client_ev_port_start(int client, int port);
extern void snd_seq_system_client_ev_port_exit(int client, int port);
extern void snd_seq_system_client_ev_port_change(int client, int port);



/* register our internal client */
extern void snd_seq_system_client_init(void);

/* unregister our internal client */
extern void snd_seq_system_client_done(void);


#endif
