/* false - return a 1
   Copyright (C) 91, 92, 93, 1994 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Eric Kuzniar <kuzniar@cs.unca.edu> */

#include <config.h>
#include <stdio.h>
#include <getopt.h>

#include "long-options.h"
#include "version.h"

/* The name this program was run with. */
char *program_name;

static void usage (int status)
{
  if (status != 0)
    fprintf (stderr, "Try `%s --help' for more information.\n",
	     program_name);
  else
    {
      printf ("Usage: %s [OPTION]\n", program_name);
      printf ("\
\n\
  --help      display this help and exit\n\
  --version   output version information and exit
");
    }
  exit (status);
}

int main (int argc, char *argv[])
{
	program_name = argv[0];

   if (argc > 1)
   {
      parse_long_options (argc, argv, "false", version_string, usage);
      usage(1); /* will only be executed if no valid options */
   }
   return(1);
}
