/*
 * RCF named extensions:
 * (C) Research Computing Facility,
 *     Department of Computer Science
 *     Umass/Amherst
 *
 * Matt Kimmel    (kimmel@oit.umass.edu)
 * Craig I. Hagan (hagan@cih.com)
 *
 * You are free to redistribute this code as long as the above
 * notice remains. Please send up any changes that you make.
 */

/*
 * define RCF_SERVICE to enable this stuff
 */

#if !defined(_NS_SERVICE_H) && defined(RCF_SERVICE)

/*****************************************************************************
 *
 * User configureable data follows:
 */

/* 
 * We define the filename of the alias file here, just to be lazy. 
 * This really should be read in from named.boot 
 */

extern char *SERVICE_FILE;

/*
 * should named fork a daemon which will verify that
 * hosts are connecteable to ipport?
 */

#define USE_GUARANTEED 1

/* 
 * Should guaranteed services be enabled?
 */

#define GUARANTEED_AUTOCHECK 1

/*
 * how often (in seconds) should this daemon run?
 * this should be greater than the TIME_WAIT value on
 * your sockets -- 2*MAX_TTL (tcp) or something like that
 * otherwise you will build up lots of bad connections for
 * machines that are down resulting in your system
 * running out of sockets, a bad thing(tm).
 */

#define GUARANTEED_AUTOCHECK_PERIOD 300

/*
 * guaranteed pessimistic turned on causes the autocheck
 * algorithm to assume a host is down until the connect
 * call returns. Otherwise it is assumed to be whatever
 * the previous state was (usually up)
 */

#define GUARANTEED_PESSIMISTIC 1

/*
 * guaranteed strict causes the named process to verify
 * that the target host can be connected to on ipport
 * as of when the name is being resolved. This is here
 * due to the possibility that the check may not be
 * good enough
 *
 * warning: if a host is down, named will block until the
 * socket call times out.
 */
 
#undef GUARANTEED_STRICT 1

/* how many times z_minimum ttl we should allow caching for. */

#define TTLMUL 10


/*****************************************************************************/

/* below is data relevant for the program */

/*****************************************************************************/



/* 
 * Set the values for determining if a
 * guaranteed host is up or down 
 */

#define GUARANTEED_HOSTUP 1
#define GUARANTEED_HOSTDOWN 0

/*
 * values for whether or not a guaranteed host has
 * been checked yet
 */

#define GUARANTEED_UNCHECKED 0
#define GUARANTEED_CHECKED 1

/* 
 * Defines and typedefs for named aliasing module 
 */

extern int lookup_service_was_used;
extern int lookup_service_ttl;
extern int lookup_service_init(char *service_file);
char *lookup_service(char *dnbuf);

/* Struct for linked list of names (there's one of these lists for each
 * alias)
 */

struct namenode {
  char name[40]; /* This name */
  char ipaddr[16]; /* This IP address */
  int weight; /* Its weight */
  unsigned long accesses; /* Number of requests that have been sent to it */
  int upindex; /* Index into up table */
  struct namenode *next;
};

/*
 *  Struct for linked list of aliases 
 */

struct aliasnode {
  char alias[40];
  int guaranteed; /* Is this service guaranteed? */
  int ipport; /* IP port associated with this service */
  struct namenode *namelist;
  struct aliasnode *next;
};


#define _NS_SERVICE_H
#endif _NS_SERVICE_H
