.TH XMMOUNT 1 
.SH NAME
xmmount \- device mounter with Motif interface
.SH SYNOPSIS
.B xmmount
.SH DESCRIPTION
.B xmmount 
is a comfortable mount utility for different devices with a Motif user 
interface. The window contains a number of buttons for mounting and unmounting 
a device. If the user presses one of the mount buttons 
.B xmmount 
tries to recognize the type of the filesystem on the selected device.
.B xmmount 
knows the following filesystems:
.IP 
.B msdos 
\- MS-DOS filesystem
.IP
.B minix
\- minix filesystem
.IP
.B ext
\- extended filesystem
.IP
.B ext2
\- extended filesystem two
.IP
.B xiafs
\- xia filesystem
.IP
.B ISO 9660 / High Sierra
\- CD-ROM filesystem
.LP
If the device contains a known filesystem it is mounted to the directory which
is defined in the config file. After mounting a floppy successfully the label 
of the button is changed to 'umount'. The current mounting status (
.B unmounted
,
.B msdos
,
.B minix
,
.B ext
,
.B ext2
,
.B xiafs
,
.B iso9660
) is displayed in front of the button. Before unmounting a disk the 
filesystems super-block is written by a sync system call.

Errors and status messages are displayed in the status line of the window.

The program has to be executed with root permissions, so the set ID bit must
be set and the owner of the file must be root.

The number of buttons and the devices which are available for mounting are 
described by a configuration file named "xmmounttab". Usually this file
should be found in "/etc". A different location has to be specified
by the environment variable XMMOUNTPATH. The maximal number of mountable
devices is 16.

If the user likes to mount a filesystem which is not supportet yet, he can
disable the autodetection of the filesystem type in the config file.

The config file has the following format:

    #####################################################
    #
    # Config file for xmmount (v4.5)
    #
    # name    device       directory   type    options

    Floppy0:  /dev/fd0     /mnt0       auto    defaults  
    Floppy1:  /dev/fd1     /mnt1       auto    defaults  

    Syquest:  /dev/sda4    /mnt2       ext2    ro,noexec 
    CD-ROM:   /dev/scd0    /cd-rom     auto    ro        

    Special:  /dev/secial  /special    special defaults  

The '#' sign marks the rest of a line as a comment. Empty lines are allowed. 
Each line has to contain exactly five entries: the name of the label, the
mountable device, the mounting directory, the filesystem type (or auto
detection) and the option entry.
.SH ENVIRONMENT
XMMOUNTPATH \- search path for xmmounttab
.SH FILES
/etc/xmmounttab \- config file for xmmount
.br
/etc/mtab       \- mounted filesystem table
.SH "SEE ALSO"
mount(1), mount(2), umount(1), umount(2), sync(1), sync(2)
.SH AUTHOR
Thomas Uhl, uhl@fh-heilbronn.de 
.br
Harald M. Stauss, harald.stauss@rz.hu-berlin.de
.SH COPYRIGHT
v1.0 \- 7.2.1993 
.br
v1.1 \- 28.3.1993 
.br
v2.0 \- 17.4.1993 
.br
v2.5 \- 5.5.1993 
.br
v3.0 \- 22.5.1993 
.br
v3.5 \- 14.8.1993 
.br
v3.6 \- 20.8.1994 

Copyright (C) 1994 by Thomas Uhl

v4.0 \- 02.11.1996
.br
v4.4 \- 30.08.1997
.br
v4.5 \- 05.10.1997

Copyright (C) 1996 by Harald Stauss

This software may be used and distributed according to the terms
of the GNU Public License.

