#ifndef	TOOL_H
#define TOOL_H

/* Limite pour le plus permissif des file system */
/* En fait, il y en a des plus permissif que ca, bof ... */
#define MAXSIZ_PATH		255
#define MAXSIZ_NAME		255
#define MAXSIZ_EXTENSION 255
#define MAXSIZ_BASENAME 255

#define TOOL_OS_SEP			'/'
#define TOOL_AUTRE_OS_SEP	'\\'
#define WILD_ALLFILE		"*"

typedef	enum {
	FILETYPE_REG,		/* fichier ordinaire */
	FILETYPE_DIR,		/* directory */
	FILETYPE_PIPE,		/* pipe	*/
	FILETYPE_DEVCHR,	/* device */
	FILETYPE_DEVBLK
} FILETYPE;

typedef	struct {
	char name[MAXSIZ_NAME];
	long size;
	unsigned long date;		/* date	de revision	*/
	FILETYPE type;
	int	inode;		/* Inode controlant ce fichier */
	int device;		/* Device (file_system) ou est ce fichier */
	int	filler[9];
} FILEINFO;

typedef	struct{
	char str[MAXSIZ_NAME];
} WILD;

#define wild_maxsel 50
typedef struct {
    int nbsel;  /* nombre de wsel */
	WILD *tbsel[wild_maxsel];
    int nbuns;  /* nombre de wuns */
    WILD *tbuns[wild_maxsel];
} WILD_SELECT;

typedef struct {		/* path_pushdir et popdir */
	char path[MAXSIZ_PATH+1];
} SAVEPATH;

#endif
