#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include "link.h"

static int cmp (const void *p1, const void *p2)
{
	MODULE *pt1 = *(MODULE**)p1;
	MODULE *pt2 = *(MODULE**)p2;
	return strcmp(pt1->name,pt2->name);
}
/*
	Format the dependancy list of a module into a simple makefile
*/
PUBLIC void MODULES::prtdepend (
	FILE *fout,
	const char *dontcare,	// Module we don't want to know about
							// in the dependancy lists
	int verbose,		// Print all module visited
	int showerror)		// Shows undefined symbol
{
	MODULE **tbdep = new MODULE*[nbmod];
	MODULE *ptmod = tbmod;
	for (int i=0; i<nbmod; i++, ptmod++){
		if (strcmp(ptmod->name,dontcare)!=0){
			SYMBOL **ptext = ptmod->ext.tb;
			int nbext = ptmod->ext.nb;
			int nbdepmod = 0;
			int nberr = 0;
			for (int e=0; e<nbext; e++, ptext++){
				MODULE *mod = (*ptext)->module;
				if (mod==NULL){
					if (nberr == 0){
						depmod_error ("*** Unresolved symbols in module %s"
								,ptmod->name);
					}
					if (showerror){
						depmod_error ("\t%s",(*ptext)->name);
					}
					nberr++;
				}else{
					if (strcmp(mod->name,dontcare)!=0){
						int m;
						for (m=0; m<nbdepmod; m++){
							if (tbdep[m] == mod) break;
						}
						if (m == nbdepmod) tbdep[nbdepmod++] = mod;
					}
				}
			}
			if (nberr == 0 && verbose) printf ("%s\n",ptmod->name);
			// Sort so it is nicer to look at :-)
			qsort(tbdep,nbdepmod,sizeof(MODULE*),cmp);
			fprintf (fout,"%s:",ptmod->name);
			for (int m=0; m<nbdepmod; m++){
				if (m != 0 && (m & 3) == 0) fprintf (fout,"\\\n");
				fprintf (fout,"\t%s",tbdep[m]->name);
			}
			fprintf (fout,"\n\n");
		}
	}
	delete [] tbdep;
}


