#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <asm/io.h>

#define herc_buffer_size 0xfa0
#define herc_line_length 160
#define herc_lines 25
#define herc_lastline_start herc_line_length*(herc_lines-1)
#define herc_lastline_end herc_line_length*herc_lines
#define hercinfile "/dev/herc"

#undef CONF_DEBUG

char *buffer;
FILE *in;
int buf_pos=herc_lastline_start;



void herc_scroll()
{
	int l;

#ifdef CONF_DEBUG
	printf("herc_scroll()...");
#endif
	for(l=0; l<(herc_buffer_size-herc_line_length); l++) {
		buffer[l]=buffer[l+herc_line_length];
	} /* scroll */
	for(l=herc_lastline_start; l<herc_lastline_end; l+=2) {
		buffer[l]=0x20;
		buffer[l+1]=7;
	} /* erase last line after scroll */
	buf_pos=herc_lastline_start;
#ifdef CONF_DEBUG
	printf(" done.\n");
#endif
} /* herc_scroll */


void herc_putchar(char c)
{
        if(buf_pos>=herc_lastline_end) {
                herc_scroll();
        } /* Already end of last line? */
	if(c==10|c==13) {
		if(c==10) {
			buf_pos+=herc_line_length;
		} /* lf */
		else {
			buf_pos=herc_lastline_start;
		} /* cr */
	} /* lf or cr ? */
	else
	{
	        buffer[buf_pos]=c;
	        buf_pos++;
	        buffer[buf_pos]=7;
	        buf_pos++;
	}
} /* herc_putchar */


void init()
{
	int l;
	static char herc_txt_tbl[12] = {
		0x61, 0x50, 0x52, 0x0f, 0x19, 6, 0x19, 0x19, 2, 0x0d, 0x0b, 0x0c};


#ifdef CONF_DEBUG
	printf("init(): Mapping buffer memory...");
#endif
	buffer=(char *)mmap((caddr_t)0xb0000, 0xfa0, PROT_WRITE, MAP_FIXED | MAP_SHARED, open("/dev/mem", O_RDWR), 0xb0000);
#ifdef CONF_DEBUG
	printf(" done.\n");
#endif
	for(l=0; l<herc_buffer_size; l+=2) {
		buffer[l]=0x20;
		buffer[l+1]=7;
	}
#ifdef CONF_DEBUG
	printf("Resetting MDA-card...");
#endif
	ioperm(0x3b4, 1, 1);
	ioperm(0x3b5, 1, 1);
	ioperm(0x3b8, 1, 1);
	ioperm(0x3bf, 1, 1);
	/* set MDA-ccard to textmode */
	outb(0, 0x3bf);
	outb(0, 0x3b8);
	for(l=0; l<12; l++) {
		outb(l, 0x3b4); /* power-on defaults */
		outb(herc_txt_tbl[l], 0x3b5); /* Blank screen, page 0 */
	}
	outb(40, 0x3b8); /* unblank hardware */
#ifdef CONF_DEBUG
	printf(" done.\n");
#endif
	herc_scroll();
#ifdef CONF_DEBUG
        printf("Opening pipe, O_RO...");
#endif
        in=fopen(hercinfile, "r");
#ifdef CONF_DEBUG
        printf(" done.\n");
#endif
} /* init */


int main(int argc, char *argv[])
{
	char c;

	switch(fork()) {
		case 0: /* I am the child */
			init();
			for(;;) {
				c=fgetc(in);
				herc_putchar(c);
			}
		case -1: /* fork failed */
			fprintf(stderr, "hercd: can't fork.\n");
			exit(1);
		default: /* I am the parent */
			return(0);
	}
} /* main */
