/*
 * Add an MSDOS filesystem to a low level formatted diskette.
 *
 * Emmet P. Gray			US Army, HQ III Corps & Fort Hood
 * ...!uunet!uiucuxc!fthood!egray	Attn: AFZF-DE-ENV
 * fthood!egray@uxc.cso.uiuc.edu	Directorate of Engineering & Housing
 * 					Environmental Management Office
 * 					Fort Hood, TX 76544-5057
 */


#include <sys/types.h>
#include <sys/fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <ctype.h>
#include <memory.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include "getopt.h"
#ifdef BSD
#include <sys/time.h>
#else /* BSD */
#include <time.h>
#endif /* BSD */
#include <errno.h>
#include "msdos.h"

#ifdef USE_2M
#include <linux/fd.h>
#include <sys/ioctl.h>
#endif

extern int errno;

#ifdef NO_STRERROR
/* fixup braindead include philes */
extern char *sys_errlist[];
#define strerror(x) ( sys_errlist[x] )
#endif


static int comp_fat_bits(struct device *dev,int num_clus)
{
	if (dev->fat_bits == 0 ){
		if (num_clus > FAT12)
			fat_bits = 16;
		else
			fat_bits = 12;		
	} else if (dev->fat_bits < 0) 
		fat_bits = -dev->fat_bits;
	else
		fat_bits = dev->fat_bits;
	return fat_bits;
}

static char bootprog[]=
{0xfa, 0x31, 0xc0, 0x8e, 0xd8, 0x8e, 0xc0, 0xfc, 0xb9, 0x00, 0x01,
 0xbe, 0x00, 0x7c, 0xbf, 0x00, 0x80, 0xf3, 0xa5, 0xea, 0x00, 0x00,
 0x00, 0x08, 0xb8, 0x01, 0x02, 0xbb, 0x00, 0x7c, 0xba, 0x80, 0x00,
 0xb9, 0x01, 0x00, 0xcd, 0x13, 0x72, 0x05, 0xea, 0x00, 0x7c, 0x00,
 0x00, 0xcd, 0x19};

void
mformat(argc, argv)
int argc;
char *argv[];
{
	char *target;
	int hs;
#ifdef USE_2M
	int sum;
	int arguse_2m = 0, use_2m;
	int size2, sector2, nb_renum;
	int j;
	int sectors0=18; /* number of sectors on track 0 */
	struct floppy_struct geometry;
#endif

#ifdef MULTISIZE
	int argssize=0, ssize; /* sector size */
#endif
	int msize=0;
	int i;

#define boot (*( (struct bootsector *) buffer))

	char buffer[MAX_SECTOR];
	int c, oops, tracks, heads, sectors, fat_len, dir_len, clus_size;
	int tot_sectors, num_clus, rem_sect, occupied, tries;
	int argtracks, argheads, argsectors;
	long now;
	char drive, *name;

	unsigned char media, label[12], buf[MAX_SECTOR];
	struct device *dev;
	struct directory *dir;
	char errmsg[80];

#ifdef USE_SERIAL
	unsigned long serial;
 	int serial_set;
#endif
 
	/* avoid compiler warnings */
	tracks = sectors = heads = 0;

	hs = 0;
	oops = 0;
	argtracks = 0;
	argheads = 0;
	argsectors = 0;
	label[0] = '\0';

#ifdef USE_SERIAL
	serial_set = 0;
#endif
					/* get command line options */
	while ((c = getopt(argc, argv, "t:h:s:l:"
#ifdef USE_SERIAL
                                       "n:"
#endif
                                       "H:M:S:12:")) != EOF) {
		switch (c) {
			case 'H':
				hs = atoi(optarg);
				break;
			case 't':
				argtracks = atoi(optarg);
				break;
			case 'h':
				argheads = atoi(optarg);
				break;
			case 's':
				argsectors = atoi(optarg);
				break;
			case 'l':
				sprintf((char *) label, "%-11.11s", optarg);
				break;
#ifdef USE_SERIAL
 			case 'n':
 				serial = strtoul(optarg, NULL, 0);
 				serial_set = 1;
 				break;
#endif
#ifdef MULTISIZE
			case 'S':
				argssize = atoi(optarg);
				break;
#endif
			case 'M':
				msize = atoi(optarg);
				if (msize % 128 || msize > 8192 )
					oops=1;					
				break;
#ifdef USE_2M
			case '1':
				arguse_2m = 1;
				break;
			case '2':
				arguse_2m = FD_2M;
				sectors0 = atoi(optarg);
				break;				
#endif
			default:
				oops = 1;
				break;
		}
	}

	if (oops || (argc - optind) != 1) {
		fprintf(stderr, "Mtools version %s, dated %s\n", mversion, mdate);
		fprintf(stderr, "Usage: %s [-t tracks] [-h heads] [-s sectors] [-l label] "
#ifdef USE_SERIAL
                                "[-n serialnumber] "
#endif
                                "[-S hardsectorsize] [-M softsectorsize] [-1] [-2 track0sectors] device\n", argv[0]);
		exit(1);
	}

	drive = argv[argc -1][0];
	if (islower(drive))
		drive = toupper(drive);

	/* check out a drive whose letter and parameters match */	
	sprintf(errmsg, "Drive '%c:' not supported", drive);	
	fd = -1;
	for(dev=devices;dev->drive;dev++) {

					/* drive letter */
	  if (dev->drive != drive)
	    continue;
					/* non removable media */
	  if ( dev->tracks == 0 &&
	      ( argtracks == 0 || argheads == 0 || argsectors == 0 )) {
	    sprintf(errmsg, 
		    "Non-removable media is not supported "
		    "(You must tell the complete geometry of the disk, "
		    "either in /etc/mtools or on the command line) " );
	    continue;
	  }
	  				/* parameters */
	  if (dev->tracks && !dev->gioctl) {
	    if ((argtracks && dev->tracks != argtracks) ||
		(argheads && dev->heads != argheads) ||
		(argsectors && dev->sectors != argsectors)){
	      sprintf(errmsg, "Paramaters not supported");
	      continue;
	    }
	  }
					/* open the device */
	  name = expand(dev->name);
	  if ( fd != -1 )
	    close(fd);
	  fd = open(name, O_RDWR | dev->mode);
	  if (fd < 0) {
	    sprintf(errmsg,"init: open: %s", strerror(errno));
	    continue;
	  }

	  tracks = argtracks;
	  heads = argheads;
	  sectors = argsectors;
					/* fill in the blanks */
	  if (!tracks)
	    tracks = dev->tracks;
	  if (!heads)
	    heads = dev->heads;
	  if (!sectors)
	    sectors = dev->sectors;

	  msector_size = 512;
#ifdef MULTISIZE
	  ssize = 0x80;
	  if (argssize){
		  ssize = argssize;
		  msector_size = 128 << ssize;
	  }
#endif

#ifdef USE_2M
	  if (arguse_2m & FD_2M)
		  msector_size = 512;
	  if (arguse_2m)
		  use_2m = arguse_2m;
	  else
		  use_2m = 0;
#endif

	  if(msize)
		  msector_size = msize;

					/* set parameters, if needed */
	  if (dev->gioctl) {
		  if ((*(dev->gioctl)) (fd, tracks, heads, 
					sectors * msector_size / 512
					PAR_SIZE PAR_2M)){
				  sprintf(errmsg,"Could not set requested parameters");
				  continue;
			  }
		  }

#ifdef MULTISIZE
	  if (ssize == 0x80)
		  ssize=2;
	  if (!msize ){
#ifdef USE_2M
		  if ( use_2m & FD_2M)
			  msector_size = 512;
		  else
#endif
			  msector_size = 128 << ssize;
	  }
#endif

	  /* do a "test" read */
	  if (read(fd, (char *) buf, msector_size) != msector_size) {
		  sprintf(errmsg, 
			  "Error reading from '%s', wrong parameters?",name);
		  continue;
	  }
	  break;
	}
					/* print error msg if needed */	
	if ( dev->drive == 0 ){
	  fprintf(stderr,"%s: %s\n", argv[0],errmsg);
	  exit(1);
	}

					/* get the parameters */
	tot_sectors = tracks * heads * sectors - hs;
	switch (tot_sectors) {
		case 320:		/* 40t * 1h * 8s = 160k */
			media = 0xfe;
			clus_size = 1;
			dir_len = 4;
			fat_len = 1;
			fat_bits = 12;
			break;
		case 360:		/* 40t * 1h * 9s = 180k */
			media = 0xfc;
			clus_size = 1;
			dir_len = 4;
			fat_len = 2;
			fat_bits = 12;
			break;
		case 640:		/* 40t * 2h * 8s = 320k */
			media = 0xff;
			clus_size = 2;
			dir_len = 7;
			fat_len = 1;
			fat_bits = 12;
			break;
		case 720:		/* 40t * 2h * 9s = 360k */
			media = 0xfd;
			clus_size = 2;
			dir_len = 7;
			fat_len = 2;
			fat_bits = 12;
			break;
		case 1440:		/* 80t * 2h * 9s = 720k */
			media = 0xf9;
			clus_size = 2;
			dir_len = 7;
			fat_len = 3;
			fat_bits = 12;
			break;
		case 2400:		/* 80t * 2h * 15s = 1.2m */
			media = 0xf9;
			clus_size = 1;
			dir_len = 14;
			fat_len = 7;
			fat_bits = 12;
			break;
		case 2880:		/* 80t * 2h * 18s = 1.44m */
			media = 0xf0;
			clus_size = 1;
			dir_len = 14;
			fat_len = 9;
			fat_bits = 12;
			break;
		default:		/* a non-standard format */
			media = 0xf0;
			if (heads == 1)
				clus_size = 1;
			else {
				clus_size = (tot_sectors > 2000 ) ? 1 : 2;
#ifdef USE_2M
				if ( use_2m & FD_2M)
					clus_size = 1;
#endif
			}

			num_clus = tot_sectors / clus_size;
			while (comp_fat_bits(dev, num_clus) == 12 &&
#ifdef USE_2M
			       !use_2m &&
#endif
			       num_clus > FAT12){
				clus_size <<= 1;
				num_clus = tot_sectors / clus_size;
			}

			if (heads == 1)
				dir_len = 4;
			else
				dir_len = (tot_sectors > 2000) ? 14 : 7;

			if ( (dir_len * 512 ) % msector_size ){
				dir_len += msector_size / 512;
				dir_len -= dir_len % (msector_size / 512);
			}

			/* the "remaining sectors" after directory and boot
			 * has been accounted for.
			 */
			rem_sect = tot_sectors - dir_len - 1;

			/* rough estimate of fat size */
			fat_len = 1;
			
			tries=0;
			while(1){
				num_clus = (rem_sect - 2 * fat_len ) /clus_size;
				comp_fat_bits(dev, num_clus);
				fat_len = FAT_SIZE;
				occupied = 2 * fat_len + clus_size * num_clus;

				/* if we have exactly used up all
				 * sectors, fine */
				if ( occupied == rem_sect )
					break;

				/* if we have used up more than we have,
				 * we'll have to reloop */

				if ( occupied > rem_sect )
					continue;

				/* if we have not used up all our
				 * sectors, try again.  After the second
				 * try, decrease the amount of available
				 * space. This is to deal with the case of
				 * 344 or 345, ..., 1705, ... available
				 * sectors.  */

				switch(tries++){
				default:
					/* this should never arrive */
					fprintf(stderr,
						"Internal error in cluster/fat repartition calculation.\n");
					exit(1);
				case 2:
				case 1:
					rem_sect--;
				case 0:
					continue;
				}
			}
			if ( num_clus > FAT12 && fat_bits == 12 ){
				fprintf(stderr,"Too many clusters for this fat size. Please choose a 16-bit fat in your /etc/mtools or .mtoolsrc file\n");
				exit(1);
			}
			break;
		}
					/* the boot sector */
	memset(buffer, '\0', msector_size);
	strncpy(boot.banner, "Mtools  ", 8);
	boot.secsiz[0] = msector_size % 0x100;
	boot.secsiz[1] = msector_size / 0x100;
	boot.clsiz = (unsigned char) clus_size;
	boot.nrsvsect[0] = 1;
	boot.nrsvsect[1] = 0;
	boot.nfat = 2;
	boot.dirents[0] = (dir_len * 16) % 0x100;
	boot.dirents[1] = (dir_len * 16) / 0x100;
	if ( tot_sectors < 0x10000 ){
		boot.psect[0] = tot_sectors % 0x100;
		boot.psect[1] = tot_sectors / 0x100;
		boot.bigsect[0]= boot.bigsect[1]= 0;
		boot.bigsect[2]= boot.bigsect[3]= 0;
	} else {
		boot.psect[0] = 0;
		boot.psect[1] = 0;
		boot.bigsect[0]= (tot_sectors >>  0) & 0xff;
		boot.bigsect[1]= (tot_sectors >>  8) & 0xff;
		boot.bigsect[2]= (tot_sectors >> 16) & 0xff;
		boot.bigsect[3]= (tot_sectors >> 24) & 0xff;
	}
	boot.descr = media;
	boot.fatlen[0] = fat_len % 0x100;
	boot.fatlen[1] = fat_len / 0x100;
	boot.nsect[0] = sectors % 0x100;
	boot.nsect[1] = sectors / 0x100;
	boot.nheads[0] = heads % 0x100;
	boot.nheads[1] = heads / 0x100;

	boot.nhs[0] = (hs >>  0) & 0xff;
	boot.nhs[1] = (hs >>  8) & 0xff;
	boot.nhs[2] = (hs >> 16) & 0xff;
	boot.nhs[3] = (hs >> 24) & 0xff;

	boot.physdrive = 0;
	boot.reserved = 0;
	boot.dos4 = 0x29;
#ifdef USE_SERIAL
  	if (!serial_set) {
		srandom(time (0));
		serial=random();
	}
 	memcpy(boot.serial, &serial, 4);
#endif
	strncpy(boot.label, label, 11);
	sprintf(boot.fat_type, "FAT%2.2d   ", fat_bits);
	target = boot.fat_type + 10;
#ifdef USE_2M
	if (use_2m & FD_2M){
		strncpy(boot.banner, "2M-STV04", 8);
		boot.res_2m = 0;
		boot.fmt_2mf = 6;
		if ( sectors % ( ((1 << ssize) + 3) >> 2 ))
			boot.wt = 1;
		else
			boot.wt = 0;
		ioctl( fd, FDGETPRM, &geometry);
		boot.rate_0=geometry.rate & 0x3;
		boot.rate_any= boot.rate_0;
		if (boot.rate_any== 2 )
			boot.rate_any= 1;
		i=76;

		/* Infp0 */
		boot.Infp0[0] = i;
		boot.Infp0[1] = 0;
		boot.jump[i++] = sectors0;
		boot.jump[i++] = 108;
		for(j=1; j<= sectors0; j++)
			boot.jump[i++] = j;

		/* InfpX */
		boot.InfpX[0] = i % 0x100;
		boot.InfpX[1] = i / 0x100;
		
		boot.jump[i++] = 64;
		boot.jump[i++] = 3;
		nb_renum = i++;
		sector2 = sectors;
		size2 = ssize;
		j=1;
		while( sector2 ){
			while ( sector2 < 1 << ( size2 - 2) )
				size2--;
			boot.jump[i++] = 128 + j;
			boot.jump[i++] = j++;
			boot.jump[i++] = size2;
			sector2 -= 1 << (size2 - 2 );
		}
		boot.jump[nb_renum] = ( i - nb_renum - 1 ) / 3;
		
		/* InfTm */
		boot.InfTm[0] = i % 0x100;
		boot.InfTm[1] = i / 0x100;

		sector2 = sectors;
		size2=ssize;
		while(sector2){
			while ( sector2 < 1 << ( size2 - 2) )
				size2--;
			boot.jump[i++] = size2;
			sector2 -= 1 << (size2 - 2 );
		}
		
		/* BootP */
		boot.BootP[0] = i % 0x100;
		boot.BootP[1] = i / 0x100;

		/* checksum */		
		for (sum=0, j=64; j<i; j++) 
			sum+= boot.jump[j];/* checksum */
		boot.CheckSum=-sum;
		target = &boot.junk[i+2];
		/* set parameters, if needed */
		if (dev->gioctl) {
			if ((*(dev->gioctl)) (fd, tracks, heads, sectors
					      PAR_SIZE PAR_2M)){
				fprintf(stderr,
					"Could not set requested parameters");
				exit(1);
			}
		}
	}
#endif
	memcpy(target, bootprog, sizeof( bootprog) /sizeof(bootprog[0]));
	boot.jump[0] = 0xe9;
	boot.jump[1] = (target - buffer - 3) & 0xff;
	boot.jump[2] = ((target - buffer - 3) >> 8) & 0xff;	
	target[20] = (target + 24 - buffer) & 0xff;
	target[21] = ((target + 24 - buffer ) >> 8) & 0xff;	
					/* write the boot */
	lseek(fd, dev->offset, 0);
	if( write(fd, (char *) &boot, 512) < 0 ){
	  perror("write");
	  exit(1);
	}
					/* first fat */
	memset((char *) buf, '\0', msector_size);
	buf[0] = media;
	buf[1] = 0xff;
	buf[2] = 0xff;
	if ( fat_bits == 16 )
		buf[3] = 0xff;
	write(fd, (char *) buf, msector_size);
	memset((char *) buf, '\0', msector_size);
	for (i = 1; i < fat_len; i++)
		if(write(fd, (char *) buf, msector_size)<0){
		  perror("write");
		  exit(1);
		}
					/* second fat */
	buf[0] = media;
	buf[1] = 0xff;
	buf[2] = 0xff;
	if ( fat_bits == 16 )
		buf[3] = 0xff;
	write(fd, (char *) buf, msector_size);
	memset((char *) buf, '\0', msector_size);
	for (i = 1; i < fat_len; i++)
		if(write(fd, (char *) buf, msector_size) < 0 ){
		  perror("write");
		  exit(1);
		}
					/* the root directory */
	if (label[0] != '\0') {
		time(&now);
		dir = mk_entry(label, 0x08, 0, 0L, now);
		memcpy((char *) buf, (char *) dir, MDIR_SIZE);
	}
	if(write(fd, (char *) buf, msector_size) < 0 ){
	  perror("write");
	  exit(1);
	}
	memset((char *) buf, '\0', msector_size);
	for (i = 1; i < dir_len; i++)
		if(write(fd, (char *) buf, msector_size) < 0 ){
		  perror("write");
		  exit(1);
		}
	close(fd);
	exit(0);
}

