/*
 * Change MSDOS directories
 *
 * Emmet P. Gray			US Army, HQ III Corps & Fort Hood
 * ...!uunet!uiucuxc!fthood!egray	Attn: AFZF-DE-ENV
 * fthood!egray@uxc.cso.uiuc.edu	Directorate of Engineering & Housing
 * 					Environmental Management Office
 * 					Fort Hood, TX 76544-5057
 */

#include <sys/types.h>
#include <sys/fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "msdos.h"

void
mcd(argc, argv)
int argc;
char *argv[];
{
	FILE *fp;
	char newpath[MAX_PATH];
	char *pathname, *filename, drive;
	char *mcwd_path;
	char *file, mcwd_file[MAX_PATH+sizeof("/.mcwd") ], *homedir;

	if (argc > 2) {
		fprintf(stderr, "Mtools version %s, dated %s\n", mversion, mdate);
		fprintf(stderr, "Usage: %s: msdosdirectory\n", argv[0]);
		exit(1);
	}
					/* only report the mcwd */
	mcwd = fix_mcwd();
	if (argc == 1) {
		printf("%s\n", mcwd);
		exit(0);
	}

	drive = get_drive(argv[1]);
	filename = get_name(argv[1]);
	pathname = get_path(argv[1]);

	if (init(drive, O_RDONLY)) {
		fprintf(stderr, "%s: Cannot initialize '%c:'\n", argv[0], drive);
		exit(1);
	}

	/*
	 * Move to "first guess" subdirectory, so that is_dir() can
	 * search to see if filename is also a directory.
	 */
	if (subdir(drive, pathname)) {
		fprintf(stderr, "%s: Directory not found\n", argv[0]);
		exit(1);
	}
					/* is filename really a subdirectory? */
	strcpy(newpath, pathname);
	if (is_dir(filename)) {
		if (newpath[strlen(newpath) -1] != '/')
			strcat(newpath, "/");
		strcat(newpath, filename);

					/* move to real subdirectory */
		if (subdir(drive, newpath)) {
			fprintf(stderr, "%s: Directory not found\n", argv[0]);
			exit(1);
		}
	}
	else {
		if (*filename != '\0') {
			fprintf(stderr, "%s: Directory not found\n", argv[0]);
			exit(1);
		}
	}
					/* it checked out ok, so save it */
	mcwd_path = getenv("MCWD");

	if (mcwd_path == NULL || *mcwd_path == '\0'){
		homedir= get_homedir();
		if ( homedir ){
			strncpy(mcwd_file, homedir, MAX_PATH);
			mcwd_file[MAX_PATH]='\0';
			strcat( mcwd_file, "/.mcwd");
			file = mcwd_file;
		} else
			file = "/tmp/.mcwd";
	} else
		file = expand(mcwd_path);

	if (!(fp = fopen(file, "w"))) {
		fprintf(stderr, "%s: Can't open '%s' for write\n", argv[0], expand(mcwd_path));
		exit(1);
	}
	fprintf(fp, "%c:%s\n", drive, newpath);
	fclose(fp);
	exit(0);
}
