#include <stdio.h>
#include "msdos.h"

/*
 * Puts a code into the FAT table.  Is the opposite of fat_decode().  No
 * sanity checking is done on the code.  Returns a 1 on error.
 */

int
fat_encode(num, code)
unsigned int num;
unsigned int code;
{
	unsigned int start;

	if (fat_bits == 12) {
		/*
		 *	|    byte n     |   byte n+1    |   byte n+2    |
		 *	|7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|
		 *	| | | | | | | | | | | | | | | | | | | | | | | | |
		 *	| n+0.0 | n+0.5 | n+1.0 | n+1.5 | n+2.0 | n+2.5 |
		 *	    \_____  \____   \______/________/_____   /
		 *	      ____\______\________/   _____/  ____\_/
		 *	     /     \      \          /       /     \
		 *	| n+1.5 | n+0.0 | n+0.5 | n+2.0 | n+2.5 | n+1.0 |
		 *	|      FAT entry k      |    FAT entry k+1      |
		 */
					/* which bytes contain the entry */
		start = num * 3 / 2;
		if (start <= 2 || start + 1 > (fat_len * msector_size))
			return(1);
					/* (odd) not on byte boundary */
		if (num % 2) {
			*(fat_buf + start) = (*(fat_buf + start) & 0x0f) + ((code << 4) & 0xf0);
			*(fat_buf + start + 1) = (code >> 4) & 0xff;
		}
					/* (even) on byte boundary */
		else {
			*(fat_buf + start) = code & 0xff;
			*(fat_buf + start + 1) = (*(fat_buf + start + 1) & 0xf0) + ((code >> 8) & 0x0f);
		}
	}
	else {
		/*
		 *	|    byte n     |   byte n+1    |
		 *	|7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|
		 *	| | | | | | | | | | | | | | | | |
		 *	|         FAT entry k           |
		 */
					/* which bytes contain the entry */
		start = num * 2;
		if (start <= 3 || start + 1 > (fat_len * msector_size))
			return(1);

		*(fat_buf + start + 1) =  code / 0x100;
		*(fat_buf + start) =  code % 0x100;
	}
	return(0);
}

/*
 * Write the FAT table to the disk.  Up to now the FAT manipulation has
 * been done in memory.  All errors are fatal.  (Might not be too smart
 * to wait till the end of the program to write the table.  Oh well...)
 */

void
fat_write()
{
	int i, start, dups;

	if (fd < 0)
		return;

	start = dir_start - (fat_len * num_fat);

	for (i=start; i<start+fat_len; i++)
		disk_write((long) i, &fat_buf[(i-start)*msector_size], msector_size);

	/*
	 * Only duplicate the FAT table if no errors were detected
	 */
	if (!fat_error) {
#ifdef USE_2M
		if(is_2m)
			dups=0;
		else
#endif
			dups = num_fat - 1;
		while (dups--) {
			start += fat_len;
			for (i=start; i<start+fat_len; i++)
				disk_write((long) i, &fat_buf[(i-start)*msector_size], msector_size);
		}
	}
	return;
}
