#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "msdos.h"

int fat_len;				/* length of FAT table (in sectors) */
unsigned int end_fat;			/* the end-of-chain marker */
unsigned int last_fat;			/* the last in a chain marker */
unsigned char *fat_buf;			/* the File Allocation Table */

/*
 * Get and decode a FAT (file allocation table) entry.  Returns the cluster
 * number on success or 1 on failure.
 */

unsigned int
fat_decode(num)
unsigned int num;
{
	unsigned int fat, fat_hi, fat_low, byte_1, byte_2, start;

	if (fat_bits == 12) {
		/*
		 *	|    byte n     |   byte n+1    |   byte n+2    |
		 *	|7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|
		 *	| | | | | | | | | | | | | | | | | | | | | | | | |
		 *	| n+0.0 | n+0.5 | n+1.0 | n+1.5 | n+2.0 | n+2.5 |
		 *	    \_____  \____   \______/________/_____   /
		 *	      ____\______\________/   _____/  ____\_/
		 *	     /     \      \          /       /     \
		 *	| n+1.5 | n+0.0 | n+0.5 | n+2.0 | n+2.5 | n+1.0 |
		 *	|      FAT entry k      |    FAT entry k+1      |
		 */
					/* which bytes contain the entry */
		start = num * 3 / 2;
		if (start <= 2 || start + 1 > (fat_len * msector_size))
			return(1);

		byte_1 = *(fat_buf + start);
		byte_2 = *(fat_buf + start + 1);
					/* (odd) not on byte boundary */
		if (num % 2) {
			fat_hi = (byte_2 & 0xff) << 4;
			fat_low = (byte_1 & 0xf0) >> 4;
		}
					/* (even) on byte boundary */
		else {
			fat_hi = (byte_2 & 0xf) << 8;
			fat_low = byte_1 & 0xff;
		}
		fat = (fat_hi + fat_low) & 0xfff;
	}
	else {
		/*
		 *	|    byte n     |   byte n+1    |
		 *	|7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|
		 *	| | | | | | | | | | | | | | | | |
		 *	|         FAT entry k           |
		 */
					/* which bytes contain the entry */
		start = num * 2;
		if (start <= 2 || start + 1 > (fat_len * msector_size))
			return(1);

		fat = (*(fat_buf + start + 1) * 0x100) + *(fat_buf + start);
	}
	return(fat);
}

/*
 * Read the entire FAT table into memory.  Crude error detection on wrong
 * FAT encoding scheme.
 */

void
fat_read(start)
int start;
{
	static int fat_compatibility=0;
	int i,f;
	unsigned int buflen;

#ifdef INT16
	long junk;
	junk = (long) fat_len * msector_size;
	
	if (junk > 65535L) {
		fprintf(stderr, "fat_read: FAT table is too large\n");
		exit(1);
	}
#endif /* INT16 */

	if ( fat_bits != 12 && fat_bits != 16 ){
	  fprintf(stderr,"%d fat bits not supported\n", fat_bits);
	  exit(1);
	}

	/*
	 * Let's see if the length of the FAT table is appropriate for
	 * the number of clusters and the encoding scheme.
	 * Older versions of mtools goofed this up. If the env var
	 * MTOOLS_FAT_COMPATIBILITY is defined, skip this check in order to read
	 * disks formatted by an old version.
	 */
	if ( ! fat_compatibility ){
		if ( getenv("MTOOLS_FAT_COMPATIBILITY") )
			fat_compatibility = 1;
		else
			fat_compatibility = -1;
	}

	if ( fat_compatibility == -1 ){
		if (FAT_SIZE != fat_len) {
		  fprintf(stderr, "fat_read: Wrong FAT encoding %d %d?\n",
			  FAT_SIZE, fat_len);
		  exit(1);
		}
	}
					/* only the first copy of the FAT */
	buflen = fat_len * msector_size;
	fat_buf = (unsigned char *) malloc(buflen);
	if (fat_buf == NULL) {
		perror("fat_read: malloc");
		exit(1);
	}
					/* read the FAT sectors */
	for (i=start; i<start+fat_len; i++){
		switch(disk_read((long) i, 
				 &fat_buf[(i-start)*msector_size],
				 msector_size)){
		case -1:
			perror("read error in fat_read");
			exit(1);
		case -2:
			fprintf(stderr,"end of file in fat_read\n");
			exit(1);
		case 0:			
		}
	}

					/* the encoding scheme */
	if (fat_bits == 12) {
		end_fat = 0xfff;
	        last_fat = 0xff6;
	}
	else {
		end_fat = 0xffff;
		last_fat = 0xfff6;
	}

	if(!getenv("MTOOLS_SKIP_CHECK")){
		if ( (fat_buf[0] & 0xf0) != 0xf0){
			fprintf(stderr,
				"Bad media type, probably non-MSDOS disk\n");
			exit(1);
		}

		for ( i= 3 ; i <num_clus; i++){
			f = fat_decode(i);
			if ( f < last_fat && f > num_clus){
				fprintf(stderr,"Cluster # at %d too big(%#x)\n",
					i,f);
				fprintf(stderr,"Probably non MS-DOS disk\n");
				exit(1);
			}
		}
	}

	return;
}
