/*----------------------------------------------------------------------
 *
 * Program: 	dcf77clock
 *
 * File:  	termio.c	Terminal and Port input/output functions
 *
 * Edition	History:  
 *                                                                
 * #    Date        			Comments                   by  
 * -- --------  ----------------------------------------------    ---- 
 * 01 02/05/94	Created                                           wpsk
 *
 * Last Edition:  8. May 1994
 *
 *----------------------------------------------------------------------*/

#include <stdio.h>
#include <termios.h>			/* Terminal I/O definitions	*/
#include "clock.h" 


struct termios oterm;		/* hold old terminal modes	*/
struct termios nterm;		/* hold new terminal modes	*/

struct termios oport;		/* save  last port modes	*/
struct termios nport;		/* new   modes			*/

short	term_ospeed;	   	/* Output Speed [used by TERMCAP] */
short	port_ospeed;


/*----------------------------------------------------------------------
 * This function is called once to set up the terminal device streams.
 *----------------------------------------------------------------------*/

void open_term()
{
	ioctl(0, TCGETS, &oterm);		/* Get old modes */
	nterm  = oterm;

	nterm.c_lflag &= ~(ICANON|ECHO);
	nterm.c_cc[VMIN]  = 0;
	nterm.c_cc[VTIME] = 0;
	nterm.c_cc[VINTR] = 0x71;	/* SIGINT  ---> 'Q' (quit) */ 
	
	term_ospeed = oterm.c_cflag & CBAUD;

	fflush(stdout);
	ioctl(0, TCSETS, &nterm);		/* Set  new  modes	*/
}

/*------------------------------
 * Restore old terminal values.
 *------------------------------*/

void close_term()
{
	ioctl(0, TCSETS, &oterm);	/* save old modes	*/
}


/*---------------------------------
 * Set tty device to get the data  
 *---------------------------------*/

void open_tty(fd)	
int fd;
{
int line;
	ioctl(fd, TCGETS, &oport);	/* Get old modes to save later */
	ioctl(fd, TCGETS, &nport);	/* Get old modes to change them */

	nport.c_cflag &=  ~CBAUD;
	nport.c_cflag |=   B50;
	nport.c_cflag &=  ~CSIZE;
      	nport.c_cflag |=   CS6;
 	nport.c_cflag &=   ~PARENB;
	nport.c_cflag |=   CLOCAL | CREAD;
	nport.c_cflag &=  ~CRTSCTS;

	nport.c_lflag &= ~(ICANON|ECHO);
	nport.c_cc[VMIN]  = 1;
	nport.c_cc[VTIME] = 0;	

	ioctl(fd, TCSETS, &nport); 	/* Set  new  modes	*/


	ioctl(fd, TIOCMGET, &line);	
	line &= ~TIOCM_DTR;		/* switch DTR off	*/
	line |=  TIOCM_RTS; 		/*   "    RTS on	*/
	ioctl(fd, TIOCMSET, &line);
}

/*------------------------------------
 * Restore  old values for tty device
 *------------------------------------*/
void close_tty(fd)
int fd;
{	
	ioctl(fd, TCSETS, &oport);	/* Set  old  modes	*/
}
