/*----------------------------------------------------------------------
 * Program: 	dcf77clock
 *
 * File:  	main.c	
 *
 * Edition	History:  
 *                                                                
 * #    Date        			Comments                   by  
 * -- --------  ----------------------------------------------    ---- 
 * 01 02/05/94	Created                                           wpsk
 *
 * Last Edition:  8. May 1994
 *
 *----------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <termios.h>
#include  <setjmp.h>


char *msg1 = "To exit: Type  'q'  for no update  or  'w' with update of the CMOC clock";
char *msg2 = "Write new date if next minute is complete";
char *msg3 = "No sufficient amount of successful cycles: Should be > 2";
char *msg4 = "No 'root' permission";

#define MAINDEF

#include "clock.h"


char 	*testopt();

extern struct termios nport;
extern struct termios nterm;

extern char *terminal, *getenv();
extern int  CO,LI, xmax, ymax;
jmp_buf env;

void	usage(), datamsg(), initsignals(); 




char	*port,		/* /dev/...... 		*/
	*progname,
	databuf[80],	/* dcf77 signal buffer */ 
	port_flg = FALSE;


main(argc,argv)
int	argc;
char	*argv[];
{
REG int	i, k, n; 
REG char *c = 0;
int	   count;

char    start_flg = FALSE,
	line_flg  = FALSE;

char in;
	/*-----------------    SCAN THRU THE COMMAND LINE   -------------------*/


	progname = argv[0];	

	while(argc-- > 0) {

	    while ( argc > 0   &&  **++argv  == '-' ) {
	    	argc--;
		switch (*++*argv) {

		case  0:	fprintf(stderr,"%s: no valid option found\n",progname); 
 				exit(1);
 		case '-':	if(!(*argv)[argc]) {
					++argv;
				}
				break;
		default: 

		    do {
		 	switch (**argv) {
			case '?':	usage(progname);
					exit(0);

			case 'b': 	bell_flg++;
					continue;     

			case 'p':	port = testopt(argv);
					*argv += strlen(*argv) -1;
					port_flg++;
					continue;     

		  	default: 	fprintf(stderr,"%s: unknown option -%c\n",progname,**argv);
 				 	exit(0);
		 	} 
	     	    }
	     	    while(*++*argv) ;
		    	continue;		   
		}
     		break;
	    }

	}	/*----  COMMAND LINE SCAN READY   ------*/		


	if(!port_flg)
		printf("%s: No port specified\n",progname);


	if((tfd = open(port, O_RDWR )) < 0) {
		printf("%s: Can't open %s\n",progname, port);
		exit(1);
        }


	/* 
	 * Init terminal, dataport, signals and termcap.
	 */


	open_term();
	open_tty(tfd);
	initsignals();
	
	/*--- read garbage, if any ---*/
	sleep(1);
	ioctl(tfd,FIONREAD,&count);
	while(count-- > 0)
		read(tfd,c,1);

	puts("\nWait for Device ready");
	puts("\nTo exit type 'q'");	

	/*--- wait for device ready ---*/ 
	sleep(30);  
	ioctl(tfd,FIONREAD,&count);
	if(count < 1) {
		fprintf(stderr,"%s: Device %s  not ready\n",progname,port);
		close_tty(tfd);
		exit(1);
	}

	inittcap();
	if(strlen(getenv("WINDOWID")) != 0)  
		X11_flg = TRUE;

	setjmp(env);
	cursor_off();
	start_flg = FALSE;
	line_flg  = FALSE;
	get_win_size();
	clearscreen();

	if(CO < 80 || LI < 24) {
		if(CO < 80)
			puts("Screen\nwidth\ntoo\nsmall");
		else	printf("Screen\nhight\ntoo\nsmall\n");
		close_tty(tfd);
		cursor_on();
		exit(1);
	}		
	

	/*
 	 *  Draw background black if xterm is used.
	 */
	if(X11_flg) {
		bgc(BLACK);
		for(i = 0; i < LI; i++){
			goxy(0,i);
			for(k = 0; k < CO ; k++)
				write(1," ",1);
			fflush(stdout);	
		}
	}
	
	half_x  = CO / 2;
	win2xStartpos = half_x - 30;
	win1end = 6;
	win2end = 14;
	border(win1end, win2end, 0);
	win2ypos = 9;
	bgc(BLUE);

	for(i = 1; i < win1end; i++){
		goxy(1,i);
		for(k = 1; k < xmax ; k++)
			write(1," ",1);
		fflush(stdout);	
	}
	goxy(2, 4);
	printf("Input:");
	fflush(stdout);
	goxy(xmax - 14,2);
	printf("Parity:");
	fflush(stdout);
	goxy(xmax - 14,4);
	printf("Success:");
	fflush(stdout);
	goxy(half_x - 17, 2);
	printf("%s","D C F 7 7   R A D I O   C L O C K");
	fflush(stdout);
	blink_on();
	datamsg("Wait for first cycle of minute", 4, RED, BLUE);
	blink_off();
	goxy(2,2);
	bgc(BLUE);
	fgc(WHITE);
	printf("Port: %s",port);
	fflush(stdout);

	i = 0;	k = 0; n = 0;

	goxy(win2xStartpos ,win2ypos);
	fgc(GREEN);
 	printf("-p----------------------p------p-------s--------------------");
	fflush(stdout);
	goxy(win2xStartpos ,win2ypos + 1);
	printf("987654321098765432109876543210987654321098765432109876543210");
	fflush(stdout);
	goxy(win2xStartpos , win2ypos + 2);
	printf("         5         4         3         2         1         0"); 
	fflush(stdout);
	datamsg(msg1, ymax -1, YELLOW, BLACK); 
	
	for(;;) {
		read(0, &in, 1);
		if(in == 'w') {
   			in = 0;
			if(!getuid()) {
				if(success > SUCCESS) {
					write_flg = TRUE;
					clearline(msg1,ymax -1);
					datamsg(msg2, ymax -1, YELLOW, BLACK); /* write .. */ 
				}	
				else {
					clearline(msg1,ymax -1);
					datamsg(msg3, ymax -1, YELLOW, BLACK); /* No write .. */
				}
			}
			else {
				clearline(msg1,ymax -1);
				datamsg(msg4, ymax -1, YELLOW, BLACK); /* No permis .. */			
			}
		}
		nport.c_cc[VMIN]  = 0;
		nport.c_cc[VTIME] = 15; 	/* detect the minute time gap */ 
		ioctl(tfd, TCSETS, &nport);
		count = read(tfd, c, 1);

		if (count < 0) {		/* read error on port */
			clearscreen();
			printf("Clock not readable");
			prg_exit(1);
		}

		if(count == 0 || n > 59) {

			datamsg(msg1, ymax -1, YELLOW, BLACK); /* To exit .... */

			if(start_flg == TRUE) {
				cursor_off();
				ParseDCFdata(databuf);
				cursor_on();

				if(write_flg && success > SUCCESS) {
					sprintf(msgstr,"/bin/date -sd %s >/dev/null ; clock -w",date);
					system(msgstr);
					write_flg = 0;
					writenum++;
					success = 0;
					bgc(BLUE);
					goxy(xmax - 6,4);
					printf("     ");
					fflush(stdout);
					datamsg(msg1, ymax -1, YELLOW, BLACK);
				}
				if(n == 59) {
					goxy(i,k);
					printf("*");
					fflush(stdout);
				}
			}
			beep();
			read(tfd, c, 1);
			i = win2xStartpos + 59;
			n = 0;
			start_flg = TRUE;
			if(line_flg == FALSE) {
				k = win2ypos - 1;
				line_flg = TRUE;
			}

			else {
				k = win2ypos + 3;
				line_flg = FALSE;
			}
			clearline(k);
		}
		if(start_flg == TRUE) {

			goxy(9, 4);
			cursor_off();
			bgc(BLUE);
			printf("0x%02x", *c);
			fflush(stdout);
			bgc(BLACK);
			cursor_on();
			goxy(i,k);
			if(*c == 0x20) {
				databuf[n] =  '0' ;
			}
			else {
				databuf[n] =  '1' ;
			}
			printf("%c",databuf[n]);
			fflush(stdout);
			n++;
			goxy(i-- ,k);
		}
	}
	prg_exit(0);
}

/*------------------------------------
 * Test for valid options of *argv[]  
 *------------------------------------*/
char *testopt(opt)

REG char *opt[];		
{
char c;
	c = **opt;	
	if(*++*opt == '=')
		*++*opt;
	if(**opt == 0) {
		fprintf(stderr,"%s: No parameter on option '%c' found\n", progname, c);
		exit(1);		
	}
	return *opt;
}


/*-------------------------
 *  Program  exit
 *-------------------------*/

prg_exit(err)

int err;
{
	close_term();
	close_tty(tfd);
	invoff();
	cursor_on();
	exit(err);
}

/*----------------------------
 * Print usage of program 
 *---------------------------*/
void usage(prog)
char *prog;
{
printf("Syntax:   %s  opts\n",prog);
puts  ("Function: Read raw data from a serial DCF Radio Clock");
puts("Options:");
puts("  -b beep every minute");
puts("  -p=/dev/....  tty port ");
}

/*-----------------------------------
 *   print messages centered
 *---------------------------------*/

void datamsg(msg,ypos,fcolor,bcolor)
char *msg;
int  ypos, fcolor, bcolor;
{
int xpos;

	if(strlen(msg) > xmax)
		strcpy(msg,"Last message to long");		
	
	xpos = half_x - 2 - (strlen(msg) / 2);
	goxy(xpos,ypos);
	if(fcolor == YELLOW && !X11_flg)
		bold_on();
	fgc(fcolor);
	bgc(bcolor);
	printf(" %s ",msg);
	fflush(stdout);
	bold_off();
	bgc(BLACK);
	fgc(WHITE);
}


/*------------------------------------------
 * Signal handling for external kill command 
 *------------------------------------------*/
void sighandler()
{
	prg_exit(1);
}


/*----------------------------------
 * Signal handling:  'q' quit
 *---------------------------------*/

void quit_sighandler()
{
	clearscreen();
	if(!writenum)
		printf("%s: Exit with no system clock update\n",progname);
	prg_exit(1);
}

/*----------------------------------------
 * Signal handling: Change window size 
 *---------------------------------------*/
void win_sighandler()
{
	signal(SIGWINCH,win_sighandler);
	longjmp(env,1);
}


/*-----------------------------------
 *   Init signals
 *---------------------------------*/

void initsignals()
{
int i;
int sigtab[] = { SIGHUP , SIGQUIT, SIGABRT, SIGKILL, SIGTERM};

	for(i = 0; i < 6; i++) {
		if(signal(sigtab[i], sighandler) <  0 ) {
			printf("Could not set signal handler\n");
		}
	}
	if(signal(SIGINT, quit_sighandler) < 0 ) {
		printf("Could not set signal handler\n");
	}
	if(signal(SIGWINCH, win_sighandler) < 0 ) {
		printf("Could not set signal handler\n");
	}
}

/*--------------------------------------------------
 * Ring the bell. Switch On/Of with option -b 
 *--------------------------------------------------*/
beep()
{
	if(bell_flg == TRUE)
		putchar(BELL);
}

clearline(str,y)
char *str;
int y;
{
REG int len, xpos;

	len = strlen(str) + 2;
	xpos = half_x - 1 - (len / 2);
	goxy(xpos,y);
	for(xpos; xpos <= len; xpos++)
		write(1," ",1);
}
