#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <termios.h>
#include <setjmp.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <time.h>
#include <syslog.h>
#include <limits.h>

/*
 * 	The DCF77 time code
 *
 *
 *	SECOND		MEANING
 *
 *
 * 	 0 - 14		unused (always zero)
 *	15		alternate transmitter
 *	16		expect zone change (1 hour before)
 *	17              MEZ  (MET) 	    winter time
 *	18              MESZ (MED, MET DST) summer time
 *	19		Ankndigung Schaltsekunde.
 *	20		start of time code (always 1)
 *	21 - 24		 1 Minutes (1/2/4/8/10/20/40)
 *	25 - 27		10 Minutes
 *	28		Minute Parity
 *	29 - 32		 1 Hours
 *	33 - 34        	10 Hours
 *	35		Hour Parity
 *	36 - 39		 1 Days
 *	40 - 41		10 Days
 *	42 - 44		Day of week  Sunday .... Saturday
 *	45 - 49 	 1 Month
 *	50              10 Months
 *	51 - 53	50-53	 1 Years
 *	54 - 57		10 Years
 *	58		Date Parity
 *	59		Minute ready, except for leap insertion
 *
 *	all data are binary coded decimal
 */

#define	Summer 		17	/* MET DST   	*/
#define Winter 		18	/* MET       	*/

#define DataStart	20

#define Min1Start	21
#define Min1End		24
#define Min10Start	25
#define Min10End	27
#define MinParity	28

#define Hour1Start	29 
#define Hour1End	32
#define Hour10Start	33
#define Hour10End	34
#define HourParity	35

#define Day1Start	36
#define Day1End		39
#define Day10Start	40
#define Day10End	41

#define WeekDayStart	42
#define WeekDayEnd	44


#define Month1Start	45
#define Month1End	48
#define Month10		49

#define Year1Start	50
#define Year1End	53
#define Year10Start	54
#define Year10End	57
#define DateParity	58

#define FALSE  0
#define TRUE   1

/* notification levels */
#define LEV_QUIET 0	/* log nothing */
#define LEV_ERR_ONLY 1	/* log errors */
#define LEV_ALL 2	/* log all */

/* pid file */
#define DCF_PID "/var/run/dcf77d.pid"
#define MAX_PID_LEN 11

/* /proc entry for cmdline */
#define PROC_CMDLINE_FILE "/proc/%d/cmdline"
#define PROC_CMDLINE_LEN  (MAX_PID_LEN + 13)

/* Global Vars */
struct termios oport;
struct termios nport;

/* Prototyp definitions */

/* main.c */
void Done(int sig);

/* termios.c */
void open_term(int fd);
void close_term(int fd);
/* getinfo.c */
void ParseDCFdata(char buf[]);

/* time.c */
void startclock( void );

/* log.c */
void writelog(int logtype, char *message);
