/*
 * usershutdown v1.1 (C) Copyright 1997-1998 Julian Hall
 *
 * Permission is granted to modify, use and distribute this source code
 * in any way whatsoever, as long as the copyright notice above and this
 * statement remain intact.
 *
 * Allows non root users to shut down the system, if given permission in
 * configuration file /etc/usershutdown.conf.
 *
 * v1.1: added support for logging through 'syslog', rather than directly
 *       to file, which is a much nicer way of doing it! Thanks to whoever
 *	 it was who suggested it originally; sorry I lost your patch and
 *	 had to re-write it myself!
 */

#include <pwd.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <syslog.h>

/*
 * configurable section starts here:
 */
#define SHUTDOWN	"/sbin/shutdown"
#define LOG_IDENT	"usershutdown"
#define LOG_OPTION	0
#define	LOG_FACILITY	LOG_AUTHPRIV
#define LOG_PRIORITY	LOG_INFO
/*
 * end of user configurable section
 */

int checkaccess(char *login)
{
    FILE	* userlist;
    char	buf[81], * start, * i;

    userlist = fopen("/etc/usershutdown.conf", "r");
    if (! userlist) {
	fprintf(stderr, "Can't open /etc/usershutdown.conf\n");
	return 0;
    }
    while (! feof(userlist))
    {
	fgets(buf, 80, userlist);
	i = buf;

	while(*i && (*i == ' ' || *i == '\t')) i++;
	start = i;
	while(*i && *i != ' ' && *i != '\t' && *i != '\n' && *i != '#') i++;
	*i = 0;

	if (i == start)		/* empty line */
	    continue;
	if (! strcmp(login, start)) {
	    fclose(userlist);
	    return 1;
	}
    }
    fclose(userlist);
    return 0;
}

int main(int argc, char **argv)
{
    uid_t		uid;
    struct passwd	* pwent;
    FILE		* messagelog;
    int			tmp;

    uid = getuid();
    pwent = getpwuid(uid);
    if (!pwent) {
	fprintf(stderr, "Cannot find entry in password file for uid %d\n",
		(int)uid);
	return 1;
    }

    openlog(LOG_IDENT, LOG_OPTION, LOG_FACILITY);

    if (uid != 0) {
	if (! checkaccess(pwent->pw_name)) {
	    syslog(LOG_PRIORITY, "Failed shutdown attempt by '%s'\n", 
		   pwent->pw_name);
	    closelog();

	    fprintf(stderr, "You do not have permission to shut "
		    "this system down. Go away.\n");
	    return 1;
	}
    }

    syslog(LOG_PRIORITY, "System shutdown initiated by '%s'\n", 
	   pwent->pw_name);
    closelog();

    tmp = execv(SHUTDOWN, argv);
    fprintf(stderr,"usershutdown: execv() of %s returned %d\n", SHUTDOWN, tmp);
}

