/*

  scsi_admin: scsi.h

  Copyright 2001 by Andreas H. Mueller <andreas.muller@web.de>

  This program is free software; you may redistribute and/or modify it under
  the terms of the GNU General Public License Version 2 as published by the
  Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
  for complete details.

*/


#ifndef HAVE_SCSI_ADMIN_SCSI_H
#define HAVE_SCSI_ADMIN_SCSI_H

static const char scsi_types[31][18]={ "direct-access", "sequential-access", "Printer", "Processor",
		 "WORM", "CD-ROM", "Scanner", "optical", "Medium Changer", "Communications",
		 "ASC IT8", "ASC IT8", "storage array", "Enclosure", "15", "16", "17", "18", "19",
		 "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31" };

#ifdef IN_SCSI_ADMIN_SCSI_C	/* only scsi.c shuold be interested in  */
				/* the definitions below		*/

static unsigned char sense_buffer[64];
static sg_io_hdr_t sg_io;

#define SG_TIMEOUT	60000	/* 1min - some devices need time to spin up */
#define SG_FORMAT_TIMEOUT	-1	/* unlimited -- a SCSI-timeout during
					   an FORMAT_UNIT would be fatal */
#define	SCSI_SG_HEADER_OFFSET		sizeof(struct sg_header)

#define	SCSI_INQUIRY_COMMAND_LEN	6
#define	SCSI_INQUIRY_REPLY_LEN		96
static unsigned char scsi_inquiry_command[SCSI_INQUIRY_COMMAND_LEN]={
	INQUIRY, 0, 0, 0, SCSI_INQUIRY_REPLY_LEN, 0
};
static unsigned char scsi_inquiry_buffer[SCSI_INQUIRY_REPLY_LEN];


#define SCSI_READCAPACITY_COMMAND_LEN	10
#define SCSI_READCAPACITY_REPLY_LEN	64
static unsigned char scsi_readcapacity_command[SCSI_READCAPACITY_COMMAND_LEN]={
	READ_CAPACITY, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char scsi_readcapacity_buffer[SCSI_READCAPACITY_REPLY_LEN];

#define SCSI_TUR_COMMAND_LEN		6
static unsigned char scsi_tur_command[SCSI_TUR_COMMAND_LEN]={
	TEST_UNIT_READY, 0, 0, 0, 0, 0
};

#define SCSI_START_COMMAND_LEN		6
static unsigned char scsi_start_command[SCSI_START_COMMAND_LEN]={
        START_STOP, 0, 0, 0, 1, 0
};

#define SCSI_STOP_COMMAND_LEN		6
static unsigned char scsi_stop_command[SCSI_STOP_COMMAND_LEN]={
	START_STOP, 0, 0, 0, 0, 0
};

#define SCSI_DOORLOCK_COMMAND_LEN	6
static unsigned char scsi_doorlock_command[SCSI_STOP_COMMAND_LEN]={
	ALLOW_MEDIUM_REMOVAL, 0, 0, 0, 1, 0
};

#define SCSI_DOORUNLOCK_COMMAND_LEN	6
static unsigned char scsi_doorunlock_command[SCSI_STOP_COMMAND_LEN]={
	ALLOW_MEDIUM_REMOVAL, 0, 0, 0, 0, 0
};

#define	SCSI_FORMAT_COMMAND_LEN		6
static unsigned char scsi_format_command[SCSI_FORMAT_COMMAND_LEN]={
	FORMAT_UNIT, 0, 0, 0, 0, 0
};

#endif /* IN_SCSI_ADMIN_SCSI_C */

#endif /* HAVE_SCSI_ADMIN_SCSI_H */

