/*

  scsi_admin: scsi.c

  Copyright 2001 by Andreas H. Mueller <andreas.muller@web.de>

  This program is free software; you may redistribute and/or modify it under
  the terms of the GNU General Public License Version 2 as published by the
  Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
  for complete details.

*/


#include "global.h"
#define IN_SCSI_ADMIN_SCSI_C
#include "scsi.h"

int scsi_format_unit()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_format_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_NONE;
	sg_io.cmdp=scsi_format_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_FORMAT_TIMEOUT;

	return(ioctl(fd, SG_IO, &sg_io));
}

int scsi_doorlock()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_doorlock_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_NONE;
	sg_io.cmdp=scsi_doorlock_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return(ioctl(fd, SG_IO, &sg_io));
}

int scsi_doorunlock()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_doorunlock_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_NONE;
	sg_io.cmdp=scsi_doorunlock_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return(ioctl(fd, SG_IO, &sg_io));
}

int scsi_stop_unit()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_stop_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_NONE;
	sg_io.cmdp=scsi_stop_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return(ioctl(fd, SG_IO, &sg_io));
}

int scsi_start_unit()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_start_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_NONE;
	sg_io.cmdp=scsi_start_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return(ioctl(fd, SG_IO, &sg_io));
}

int scsi_test_unit_ready()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_tur_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_NONE;
	sg_io.cmdp=scsi_tur_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return ioctl(fd, SG_IO, &sg_io);
}

int scsi_inquiry()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_inquiry_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_FROM_DEV;
	sg_io.dxfer_len=SCSI_INQUIRY_REPLY_LEN;
	sg_io.dxferp=scsi_inquiry_buffer;
	sg_io.cmdp=scsi_inquiry_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return ioctl(fd, SG_IO, &sg_io);
}

int scsi_read_capacity()
{
	memset(&sg_io, 0, sizeof(sg_io_hdr_t));
	sg_io.interface_id='S';
	sg_io.cmd_len=sizeof(scsi_readcapacity_command);
	sg_io.mx_sb_len=sizeof(sense_buffer);
	sg_io.dxfer_direction=SG_DXFER_FROM_DEV;
	sg_io.dxfer_len=SCSI_READCAPACITY_REPLY_LEN;
	sg_io.dxferp=scsi_readcapacity_buffer;
	sg_io.cmdp=scsi_readcapacity_command;
	sg_io.sbp=sense_buffer;
	sg_io.timeout=SG_TIMEOUT;

	return ioctl(fd, SG_IO, &sg_io);
}

int opendev(char *path)
{
	int fd;

	fd=open(path, O_RDWR);
	if(fd>0)
		return fd;
	else
		if(errno==EACCES)
			printf("%s: %s while opening %s RW.\n%s: Trying RO...", ownname, strerror(errno), path, ownname);
	fd=open(path, O_RDONLY);
	if(fd>0)
		printf(" ok, opened read-only.\n");
	else
		if(errno==EACCES) {
			printf(" FATAL: %s.\n", strerror(errno));
			exit(2);
		}
	return fd;
}

int setdevvars(char *devicestr, int scan)	/* set device variables as wanted by the   */
{						/* user, say convert $2 to fd, bus, id etc */
	struct sg_scsi_id sg_id;
	int l, occs=0;
	unsigned char *scsi_inquiry_bufferp=scsi_inquiry_buffer;
	int result=0;
	char *devicestrp, hoststr[4], chanstr[4], idstr[4], lunstr[4];


	if(access("/dev/.devfsd", O_RDONLY)!=0)
		return -ENODEVFS;

	for(l=0; l<strlen(devicestr); l++)	  /*						    */
		if(devicestr[l]==',')		 /* do we have to convert x,x,x,x to a devfs-path? */
			occs++;			/*	(We assume this if 3 ","'s are found)	  */

	if(occs==3) {				  /* yepp. */
		memset(hoststr, 0, sizeof(hoststr));
		memset(chanstr, 0, sizeof(chanstr));
		memset(idstr, 0, sizeof(idstr));
		memset(lunstr, 0, sizeof(lunstr));
		devicestrp=devicestr;
		strncpy(hoststr, devicestrp, strchr(devicestrp, ',')-devicestrp);
		bus=atoi(hoststr);
		devicestrp=strchr(devicestrp, ',')+1;
		strncpy(chanstr, devicestrp, strchr(devicestrp, ',')-devicestrp);
		chan=atoi(chanstr);
		devicestrp=strchr(devicestrp, ',')+1;
		strncpy(idstr, devicestrp, strchr(devicestrp, ',')-devicestrp);
		id=atoi(idstr);
		devicestrp=strchr(devicestrp, ',')+1;
		strncpy(lunstr, devicestrp, strlen(devicestrp));
		lun=atoi(lunstr);
		memset(devicestr, 0, sizeof(devicestr));
		strcpy(devicestr, "/dev/scsi/host");
		strcat(devicestr, hoststr);
		strcat(devicestr, "/bus");
		strcat(devicestr, chanstr);
		strcat(devicestr, "/target");
		strcat(devicestr, idstr);
		strcat(devicestr, "/lun");
		strcat(devicestr, lunstr);
		strcat(devicestr, "/generic");
	}
	strcpy(devicepath, devicestr);
	fd=opendev(devicepath);
	if(fd<1) {
		if(scan) {
			devicestrp=strstr(devicepath, "/host")+5;
			bus=atoi(devicestrp);
			devicestrp=strstr(devicepath, "/bus")+4;
			chan=atoi(devicestrp);
			devicestrp=strstr(devicepath, "/target")+7;
			id=atoi(devicestrp);
			devicestrp=strstr(devicepath, "/lun")+4;
			lun=atoi(devicestrp);
			if(proc_add_single_device()==-ENOPROCFS)
				return -ENOPROCFS;
			fd=opendev(devicepath);
			if(fd<1)
				return -ENODEVICE;
		}
		else
			return -ENODEVICE;
	}
	ioctl(fd, SG_GET_SCSI_ID, &sg_id);
	bus=sg_id.host_no;
	chan=sg_id.channel;
	id=sg_id.scsi_id;
	lun=sg_id.lun;
	type=sg_id.scsi_type;
	ioctl(fd, SG_GET_VERSION_NUM, &sgversion);
	result=scsi_inquiry();
	if(result==0) {
		strncpy(vendor, scsi_inquiry_bufferp+8, 8);
		strncpy(model, scsi_inquiry_bufferp+16, 16);
		strncpy(revision, scsi_inquiry_bufferp+32, 4);
		strncpy(serial, scsi_inquiry_bufferp+36, 8);
		enclosure=scsi_inquiry_bufferp[6]&0x40;
		multip=scsi_inquiry_bufferp[6]&0x10;
		mchngr=scsi_inquiry_bufferp[6]&8;
		ackreqq=scsi_inquiry_bufferp[6]&4;
		addr32=scsi_inquiry_bufferp[6]&2;
		addr16=scsi_inquiry_bufferp[6]&1;
		reladr=scsi_inquiry_bufferp[7]&0x80;
		wide32=scsi_inquiry_bufferp[7]&0x40;
		wide=scsi_inquiry_bufferp[7]&0x20;
		syncneg=scsi_inquiry_bufferp[7]&0x10;
		cmdque=scsi_inquiry_bufferp[7]&2;
		linked=scsi_inquiry_bufferp[7]&8;
		sftre=scsi_inquiry_bufferp[7]&1;
		pq=(scsi_inquiry_bufferp[0]&0xe0)>>5;
		removable=scsi_inquiry_bufferp[1]&0x80;
		devtypemod=scsi_inquiry_bufferp[1]&0x7f;
		isovers=scsi_inquiry_bufferp[2]>>6;
		ecmavers=(scsi_inquiry_bufferp[2]&56)>>3;
		ansivers=scsi_inquiry_bufferp[2]&7;
		result=scsi_read_capacity();
		if(result==0) {
			sectors=1+((scsi_readcapacity_buffer[0]<<24)|
				(scsi_readcapacity_buffer[1]<<16)|
				(scsi_readcapacity_buffer[2]<<8)|
				scsi_readcapacity_buffer[3]);
			sectorsize=(scsi_readcapacity_buffer[4]<<24)|
				(scsi_readcapacity_buffer[5]<<16)|
				(scsi_readcapacity_buffer[6]<<8)|
				scsi_readcapacity_buffer[7];
		}
		return 0;
	}
	return result;
}

