/*

  scsi_admin: proc.c

  Copyright 2001 by Andreas H. Mueller <andreas.muller@web.de>

  This program is free software; you may redistribute and/or modify it under
  the terms of the GNU General Public License Version 2 as published by the
  Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
  for complete details.

*/


#include "global.h"

int proc_add_single_device()
{
	FILE *procfile;

	procfile=fopen("/proc/scsi/scsi", "r+");
	if(procfile!=NULL) {
		if(!added) {
			fprintf(procfile, "scsi add-single-device %i %i %i %i", bus, chan, id, lun);
			added=1;
		}
		fclose(procfile);
	}
	else {
		printf("%s: Error opening /proc/scsi/scsi: %s.\n", ownname, strerror(errno));
		return -ENOPROCFS;
	}
	return 0;
}

int proc_remove_single_device()
{
	FILE *procfile;

	procfile=fopen("/proc/scsi/scsi", "r+");
	if(procfile!=NULL) {
		close(fd);
		fprintf(procfile, "scsi remove-single-device %i %i %i %i", bus, chan, id, lun);
		added=0;
		fclose(procfile);
	}
	else
		return -1;
	return 0;
}

