/*

  scsi_admin: main.c

  Copyright 2001 by Andreas H. Mueller <andreas.muller@web.de>

  This program is free software; you may redistribute and/or modify it under
  the terms of the GNU General Public License Version 2 as published by the
  Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
  for complete details.

*/


#include "global.h"

int main(int argc, char *argv[])
{
	int i=0, result=0;

	ownname=basename(argv[0]);

	added=0;
	if((argv[1]==NULL)||((argv[2]==NULL)&(strcmp(argv[1], "help")!=0))) {
		fprintf(stderr, "%s: Parameter error.\n%s: Try \"%s help\" for usage information.\n", ownname, ownname, argv[0]);
		return 1;
	}
	if(strcmp(argv[1], "help")==0) {
		cmd_help();
		return 0;
	}
	for(i=0; (strncmp(argv[1], *commands[i], strlen(*commands[i])-1)!=0)&(*commands[i][0]!=0); i++);
	if(*commands[i][0]!=0)
		result=setdevvars(argv[2], strcmp(*commands[i]+strlen(*commands[i])-1, "S")==0);
	else
		result=-EPARAM;
	if(result==0) {
		switch(i) {
			case 0x00: /* info */
				result=cmd_info();
				break;
			case 0x01: /* lock */
				result=cmd_lock();
				break;
			case 0x02: /* unlock */
				result=cmd_unlock();
				break;
			case 0x03: /* open */
				result=cmd_open();
				break;
			case 0x04: /* close */
				result=cmd_close();
				break;
			case 0x05: /* start */
				result=cmd_start();
				break;
			case 0x06: /* stop */
				result=cmd_stop();
				break;
			case 0x07: /* test */
				result=cmd_test();
				break;
			case 0x08: /* add */
				result=cmd_add();
				break;
			case 0x09: /* remove */
				result=cmd_remove();
				break;
			case 0x0a: /* swap */
				result=cmd_swap();
				break;
			case 0x0b: /* format */
				result=cmd_format();
				break;
			case 0x0c: /* reset */
				result=cmd_reset();
				break;
			default:
				result=-EPARAM;
				break;
		}
	}
	switch(result) {
		case -EPARAM:
			fprintf(stderr, "%s: Parameter error - \"%s\".\n%s: Try \"%s help\" for usage information.\n", ownname, argv[1], ownname, argv[0]);
			return 1;
		case -ENODEVICE:
			fprintf(stderr, "%s: unable to open device \"%s\": %s.\n", ownname, devicepath, strerror(errno));
			return 3;
		case -ECMDNOTIMP:
			fprintf(stderr, "%s: Sorry, this command is not yet implemented.\n", ownname);
			return 7;
		case -ENODEVFS:
			fprintf(stderr, "%s: Error: Need devfs mounted on /dev. Nothing done.\n", ownname);
			return 5;
		case -ENOPROCFS:
			fprintf(stderr, "%s: Error: Need procfs mounted on /proc writable for me. Nothing done.\n", ownname);
			return 4;
		case 0:
			return 0;
		default:
			fprintf(stderr, "%s: %s.\n", ownname, strerror(errno));
	}
	return 6;
}

