/*

  scsi_admin: global.h

  Copyright 2001 by Andreas H. Mueller <andreas.muller@web.de>

  This program is free software; you may redistribute and/or modify it under
  the terms of the GNU General Public License Version 2 as published by the
  Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
  for complete details.

*/


#ifndef HAVE_SCSI_ADMIN_GLOBAL_H
#define HAVE_SCSI_ADMIN_GLOBAL_H

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <scsi/scsi.h>
#include <scsi/scsi_ioctl.h>
#include <scsi/sg.h>
#include <errno.h>
#include <libgen.h>	/* dirname and (!) basename - last is a little bit */
			/* weird (XPG)... FIXME: Needs this to be portable??!*/
#include <string.h>
#include <limits.h>	/* for PATH_MAX */



#define CMD_MAXLEN      9	/* That's 8 for the command, 1 for do scan or don't. */

extern const char *commands[][CMD_MAXLEN];

int bus, id, lun, chan, type;	/* The device we are working on...	   */
char wide, wide32, syncneg, linked, cmdque, removable, sftre, pq, devtypemod,
	isovers, ecmavers, ansivers, multip, mchngr, reladr, ackreqq, addr16,
	addr32, enclosure;
int sectors, sectorsize;
char vendor[9], model[17], revision[5], serial[9];
int fd;				/* ...and the corresponding char-device,   */
char devicepath[PATH_MAX];	/* which was opened with this pathname,	   */
long uid;			/* and has this uniqe ID in our system.	   */
int sgversion;			/* The version of the SCSI-generic-driver. */
int added;			/* remember if we've added the device.	   */
char *ownname;

#define EPARAM		65536
#define ENODEVICE	65537
#define ECMDNOTIMP	65538
#define ENODEVFS	65539
#define ENOPROCFS	65540

int setdevvars(char *devicestr, int scan);
int scsi_doorlock();
int scsi_doorunlock();
int scsi_start_unit();
int scsi_stop_unit();
int scsi_test_unit_ready();
int scsi_format_unit();
int proc_add_single_device();
int proc_remove_single_device();
int cmd_info();
int cmd_lock();
int cmd_unlock();
int cmd_open();
int cmd_close();
int cmd_start();
int cmd_stop();
int cmd_test();
int cmd_add();
int cmd_remove();
int cmd_swap();
int cmd_format();
int cmd_reset();
int cmd_help();


#endif /* HAVE_SCSI_ADMIN_GLOBAL_H */

