/*

  scsi_admin: cmd.c

  Copyright 2001 by Andreas H. Mueller <andreas.muller@web.de>

  This program is free software; you may redistribute and/or modify it under
  the terms of the GNU General Public License Version 2 as published by the
  Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
  for complete details.

*/


#include "global.h"
#include "scsi.h"


const char *commands[][CMD_MAXLEN] = {
	{ "infoN" },	/* 0x00 */
	{ "lockN" },	/* 0x01 */
	{ "unlockN" },	/* 0x02 */
	{ "openN" },	/* 0x03 */
	{ "closeN" },	/* 0x04 */
	{ "startN" },	/* 0x05 */
	{ "stopN" },	/* 0x06 */
	{ "testN" },	/* 0x07 */
	{ "addS" },	/* 0x08 */
	{ "removeN" },	/* 0x09 */
	{ "swapN" },	/* 0x0a */
	{ "formatN" },	/* 0x0b */
	{ "resetN" },	/* 0x0c */
	{ "help" },	/* 0x0d -- this is not very important to be known here, since it's called before parsing argv[1]... */
	{ "" }		/* This MUST be the last */
};


int cmd_info()
{
	printf("\nBus %.2i, Chan %.2i, ID %.2i, lun %.2i (%s):\n", bus, chan, id, lun, devicepath);
	printf("Vendor: %-8s  Model: %-16s  Rev: %-4s  Serial: %-8s\n\n", vendor, model, revision, serial);
	printf("Type: %s", scsi_types[(int)type]);
	if((type==0)|(type==4)|(type==7))
		printf(" with %i %i-byte sectors, size %i Mbytes.\n", sectors, sectorsize, sectors/1024*sectorsize/1024);
	else
		printf(".\n");
	printf("Versions:  ANSI: %02i  ECMA: %02i  ISO/IEC: %02i\n\n", ansivers, ecmavers, isovers);
	printf("Removable: %s  Med.Chngr: %s  MultiP.: %s  Enclosure: %s\n",
		removable ? "Yes":" No", mchngr ? "Yes":" No", multip ? "Yes":" No", enclosure ? "Yes":" No");
	printf("Wide-16:   %s  Addr-16:   %s  Wide-32: %s  Addr-32:   %s  ACKQ/REQQ: %s\n",
		wide ? "Yes":" No", addr16 ? "Yes":" No", wide32 ? "Yes":" No", addr32 ? "Yes":" No", ackreqq ? "Yes":" No");
	printf("Sync:      %s  LinkdCmds: %s  Queuing: %s  Rel.Addr.: %s  SoftReset: %s\n",
		syncneg ? "Yes":" No", linked ? "Yes":" No", cmdque ? "Yes":" No", reladr ? "Yes":" No", sftre ? "Yes":" No");
	return 0;
}

int cmd_lock()
{
	return scsi_doorlock();
}

int cmd_unlock()
{
	return scsi_doorunlock();
}

int cmd_open()
{
	int retval=-ECMDNOTIMP;
	return retval;
}

int cmd_close()
{
	int retval=-ECMDNOTIMP;
	return retval;
}

int cmd_start()
{
	return scsi_start_unit();
}

int cmd_stop()
{
	return scsi_stop_unit();
}

int cmd_test()
{
	return scsi_test_unit_ready();
}

int cmd_add()
{
	return proc_add_single_device();
	return 0;
}

int cmd_remove()
{
	int retval;
	char *path;

	scsi_doorunlock();
	retval=scsi_stop_unit();
	if(retval==0)
		retval=proc_remove_single_device();
	if(retval==0) {
		path=dirname(devicepath);
		path=dirname(devicepath);
		while(rmdir(path)==0)
			path=dirname(devicepath);
	}
	return retval;
}

int cmd_swap()
{
	int retval=-1;

	printf("\nPreparing for removal:\n");
	cmd_info();
	printf("\nSending STOP_UNIT-command, please wait...");
	retval=cmd_remove();
	if(retval==0) {
		printf(" o.k.\nNow replace the device and press enter to continue (or CTRL-C to abort) >");
		scanf("*a");
		printf("o.k., please wait...");
		cmd_add();
		printf(" done\n");
		printf("Inserted:\n");
		cmd_info();
		printf("swap done.\n");
	}
	else {
		printf(" error.\n");
		cmd_info();
	}
	return retval;
}

int cmd_reset()
{
	scsi_doorunlock();
	proc_remove_single_device();
	return proc_add_single_device();
}

int cmd_format()
{
	return scsi_format_unit();
}

int cmd_help()
{
	printf("\n  scsi_admin rev.0.1 by Andreas H. Mueller.\n");
	printf("  This program is distributed under the terms of version 2 of the GNU public\n  license.\n\n");
	printf("  Usage: %s <COMMAND> <DEVICE>\n\n", ownname);
	printf("  DEVICE can be a device represented via HOST,BUS,ID,LUN or by an SCSI-\n");
	printf("  generic-device.\n\n");
	printf("  Available commands:\n");
	printf("    add:    Adds a newly attached device to the system.\n");
	printf("    start:  Send a START_UNIT-command to the device (spin it up).\n");
	printf("    test:   Sends a TEST_UNIT-command to the device.\n");
	printf("    info:   Sends an INQUIRY-command and shows you the results.\n");
	printf("    reset:  Remove the device from the system and add it again.\n");
	printf("    lock:   Try to lock the door/tray/whatever of an device.\n");
	printf("    unlock: Try to unlock the door/tray/whatever of an device.\n");
	printf("    open:   Try to open the door/tray/whatever of an device.\n");
	printf("    close:  Try to close the door/tray/whatever of an device.\n\n");
	printf("  The really dangerous commands:\n");
	printf("    remove: Prepares a device to get removed from the system.\n");
	printf("    stop:   Send a STOP-UNIT-command to the device (spin it down).\n");
	printf("    swap:   Remove a device, ask for the new one and add it.\n");
	printf("    format: Send a FORMAT_UNIT-command to the device (low-level format it).\n\n");
	printf("  WARNING: The linux-kernel does not check if a device you sent a STOP_UNIT\n");
	printf("  or FORMAT_UNIT to contains a mounted filesystem or is busy in any other way.\n");
	printf("  If you say STOP and the device is busy you will get very much SCSI-errors\n");
	printf("  and your system may crash!\n");
	printf("  BIG_FAT_WARNING: After issuing an FORMAT_UNIT the device must be considered\n");
	printf("  completely erased! The device will format itself without the need to be even\n");
	printf("  connected to the SCSI-bus, BUT LEAVE THE POWER ON IT! An aborted low-level-\n");
	printf("  format may result in unrecoverable hardware damage.\n");
	printf("  You will need read-write access to the corresponding SCSI-generic-device for\n");
	printf("  these commands. Only the info-command is satisfied with read-only access.\n");
	printf("  scsi_admin needs the proc filesystem mounted at /proc and devfs mounted at\n");
	printf("  /dev to work properly. devfs is needed since it's the only chance to get the\n");
	printf("  correct device for a given SCSI-ID, because the SCSI-device-naming/numbering\n");
	printf("  in the linux-kernel is just a big mess.\n");
	printf("  NOTE: SCSI does not support hot-plugging. Doing so may damage your hardware,\n");
	printf("  unless you have some hot-plug-aware hardware like SCA.\n\n");
	printf("  _ALL_ COMMANDS WILL BE EXECUTED WITHOUT ANY QUESTIONS OR WARNINGS!!!\n\n");
	return 0;
}

