
#include <rpcsvc/nispasswd.h>

bool_t
xdr_nispasswd_status (XDR *xdrs, nispasswd_status *objp)
{
  if (!xdr_enum(xdrs, (enum_t *)objp))
    return (FALSE);
  return (TRUE);
}

bool_t
xdr_nispasswd_code (XDR *xdrs, nispasswd_code *objp)
{
  if (!xdr_enum(xdrs, (enum_t *)objp)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t
xdr_nispasswd_field (XDR *xdrs, nispasswd_field *objp)
{
  if (!xdr_enum(xdrs, (enum_t *)objp)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t
xdr_nispasswd_error (XDR *xdrs, nispasswd_error *objp)
{
  if (!xdr_nispasswd_field(xdrs, &objp->npd_field)) {
    return (FALSE);
  }
  if (!xdr_nispasswd_code(xdrs, &objp->npd_code)) {
    return (FALSE);
  }
  if (!xdr_pointer(xdrs, (char **)&objp->next, sizeof(nispasswd_error), (xdrproc_t)xdr_nispasswd_error)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t
xdr_passwd_info (XDR *xdrs, passwd_info *objp)
{
  if (!xdr_string(xdrs, &objp->pw_gecos, ~0)) {
    return (FALSE);
  }
  if (!xdr_string(xdrs, &objp->pw_shell, ~0)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t
xdr_npd_request(XDR *xdrs, npd_request *objp)
{
  if (!xdr_string(xdrs, &objp->username, ~0)) {
    return (FALSE);
  }
  if (!xdr_string(xdrs, &objp->domain, ~0)) {
    return (FALSE);
  }
  if (!xdr_string(xdrs, &objp->key_type, ~0)) {
    return (FALSE);
  }
  if (!xdr_array(xdrs, (char **)&objp->user_pub_key.user_pub_key_val, (u_int *)&objp->user_pub_key.user_pub_key_len, ~0, sizeof(u_char), (xdrproc_t)xdr_u_char)) {
    return (FALSE);
  }
  if (!xdr_array(xdrs, (char **)&objp->npd_authpass.npd_authpass_val, (u_int *)&objp->npd_authpass.npd_authpass_len, ~0, sizeof(u_char), (xdrproc_t)xdr_u_char)) {
    return (FALSE);
  }
  if (!xdr_u_long(xdrs, &objp->ident)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t
xdr_passbuf (XDR *xdrs, passbuf objp)
{
  if (!xdr_opaque(xdrs, objp, __NPD_MAXPASSBYTES)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t
xdr_npd_newpass (XDR *xdrs, npd_newpass *objp)
{
  if (!xdr_u_long(xdrs, &objp->npd_xrandval)) {
    return (FALSE);
  }
  if (!xdr_passbuf(xdrs, objp->pass)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t
xdr_npd_update (XDR *xdrs, npd_update *objp)
{
  if (!xdr_u_long(xdrs, &objp->ident)) {
    return (FALSE);
  }
  if (!xdr_npd_newpass(xdrs, &objp->xnewpass)) {
    return (FALSE);
  }
  if (!xdr_passwd_info(xdrs, &objp->pass_info)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t
xdr_nispasswd_verf (XDR *xdrs, nispasswd_verf *objp)
{
  if (!xdr_u_long (xdrs, &objp->npd_xid)) {
    return (FALSE);
  }
  if (!xdr_u_long (xdrs, &objp->npd_xrandval)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t
xdr_nispasswd_authresult (XDR *xdrs, nispasswd_authresult *objp)
{
  if (!xdr_nispasswd_status(xdrs, &objp->status)) {
    return (FALSE);
  }
  switch (objp->status) {
  case NPD_SUCCESS:
  case NPD_TRYAGAIN:
    if (!xdr_nispasswd_verf(xdrs, &objp->nispasswd_authresult_u.npd_verf)) {
      return (FALSE);
    }
    break;
  default:
    if (!xdr_nispasswd_code(xdrs, &objp->nispasswd_authresult_u.npd_err)) {
      return (FALSE);
    }
    break;
  }
  return (TRUE);
}

bool_t
xdr_nispasswd_updresult (XDR *xdrs, nispasswd_updresult *objp)
{
  if (!xdr_nispasswd_status (xdrs, &objp->status))
    return (FALSE);
  switch (objp->status)
    {
    case NPD_PARTIALSUCCESS:
      if (!xdr_nispasswd_error (xdrs, &objp->nispasswd_updresult_u.reason))
	return (FALSE);
      break;
    case NPD_FAILED:
      if (!xdr_nispasswd_code (xdrs, &objp->nispasswd_updresult_u.npd_err))
	return (FALSE);
      break;
    default:
      break;
    }
  return (TRUE);
}
