/*
 * options.c		Option handling functions for ttc.
 * 
 * Copyright (C) 1997, 1998 Pekka Riikonen, priikone@fenix.pspt.fi.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

/*
 * Revision 1.2  8.3.1998  pekka
 *	Added Option structure for easier option handling
 *	Some minor code change for better
 *	Fixed some bugs
 *
 * Revision 1.1  26.5.1997  pekka
 *	Added -l option
 *	Added login count options
 *
 * Revision 1.0  21.2.1997  pekka
 *	First released version
 *
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "options.h"

int read_options(char *filename, Option *option)
{	
	FILE *fd;
	char tmp[1][256];		/* temp option storage */
	Options *optp;
	int i = 0, a = 0, h = 0;
	int parn;
	int uu;

	/*
	 * find out number of parameters in options
	 */
	if ((fd = fopen(filename, "r")) == 0 ) {
	    printf("ttc: %s\n", strerror(errno));
	    exit(1);
	}
	while ((parn = find_parnum(fd, parn)) != -1) {
	    option[a].parnum = parn;
     	    parn = 0;
	    a++; 
	}
	fclose(fd);

	/*
	 * get options
	 */
	fd = fopen(filename, "r");
	while(getword(fd, tmp[0]) != -1) {

	    /* is there a match */
	    for (optp = opts; optp->name; optp++)
	    	if (!strcmp(tmp[0], optp->name)) {

		    if (option[h].parnum < optp->minpar) {
			printf("ttc: Too few parameters in %s option.\n",
				tmp[h]);
			exit(1);
		    }

		    option[h].option = *optp->oletter;

		    if (option[h].parnum != 0)
		    	/* get parameters for option */
		    	for (i = 0; i < option[h].parnum; i++) {
		    	    getword(fd, option[h].params[i]);
			}
		}
		h++;
		bzero(&tmp, sizeof(tmp));
	}

	fclose(fd);
	return h;			/* return number of options */
}

int find_parnum(FILE *fd, int parnum)	/* find out number of parameters */
{
	int ch;
	int marked = 0;			/* we'll assume line is legal */
	int firstchar = 1;		/* we'll assume first char is '\n' */

	while((ch = getc(fd)) != EOF) {
	    if (ch == '\n')			/* end of line ? */
		if (firstchar != 1)
		    if (marked != 1)
		    	break;
		    else {			/* if line was illegal */
		    	parnum = 0;		/* no parameters */
		    	marked = 0;		/* next line might be ok */
			firstchar = 1;		/* but it may start as '\n' */
		    	continue; 
		    }
		else {				/* first char was '\n' */
		   firstchar = 1;		/* next line may be '\n' too */
		   continue;
		}

	    if (check_char(ch) == -1) {		/* -1 illegal char */
		marked = 1; 			/* so it's illegal line */
		firstchar = 0;			/* first char wasn't '\n' */
		continue; 
	    } else
		firstchar = 0;			/* first char wasn't '\n' */

	    if (ch == ' ')
		if (marked != 1)
		    parnum++;
	}

	if (ch == EOF)
	    return -1;
	return parnum;
}

int getword(FILE *fd, char *opt)
{
	int ch;
	int i = 0;
	int marked = 0;			/* we'll assume line is legal */
	int firstchar = 1;		/* we'll assume first char is '\n' */

	while((ch = getc(fd)) != EOF) {
	    if (ch == '\n')		/* end of line ? */
		if (firstchar != 1)
		    if (marked != 1)
		    	break;
		    else {		/* if line was illegal */
		    	i = 0;		/* we don't want it */
		    	marked = 0;	/* next line might be ok */
		   	firstchar = 1;	/* but it may start as '\n' */
		    	continue; 
		    }
		else {			/* first char was '\n' */
		   firstchar = 1;	/* next line may be '\n' too */
		   continue;
		}

	    if (check_char(ch) == -1) {	/* -1 illegal char */
		marked = 1; 		/* so it's illegal line */
		firstchar = 0;		/* first char wasn't '\n' */
		continue; 
	    } else
		firstchar = 0; 		/* first char wasn't '\n' */

	    if (ch == ' ')
		if (marked != 1)
		    break;
		else 
		    continue;

	    if (marked != 1) {
	    	opt[i] = ch;
	    	i++;
	    }
	}

	if (ch == EOF)
	    return -1;
	return 0;
}

int check_char(int ch)		/* these characters are illegal */
{
	if (ch == '#') return -1;
	if (ch == '@') return -1;
	if (ch == '&') return -1;
	if (ch == '$') return -1;
	if (ch == '%') return -1;
	if (ch == '\'') return -1;
	if (ch == '\\') return -1;
	if (ch == '\t') return -1;
	if (ch == '\r') return -1;
	if (ch == '\a') return -1;
	if (ch == '\b') return -1;
	if (ch == '\f') return -1;
	if (ch == '"') return -1;
	return 0;		/* no illegal characters found */
}
