/*
 * options.c - option handling functions for ttc.
 * 
 * Copyright (C) 26.5.1997 Pekka Riikonen, priikone@fenix.pspt.fi.
 * Distributable under the terms of GNU GPL, version 2 or later.
 *
 * This code comes 'as is' and gives no warranty to work. You use this
 * software at your own risk. You can freely modify this code, but remember
 * to give me the credit for original code.
 *
 */

/*
 * Revision 1.1  26.5.1997  pekka
 *	Added -l option
 *	Added login count options
 *
 * Revision 1.0  21.2.1997  pekka
 *	First released version
 *
 */

#include <stdio.h>
#include <errno.h>

/* options */
static struct opt {
	char *name;		/* option name */
	int minpar;		/* min parameter required */
	char *cases;		/* cases, used with switch() */
} opts[] = {			/* options allowed: */
	{"-d", 1, "d"},
	{"deny", 1, "d"},
	{"-t", 1, "t"},
	{"timing", 1, "t"},
	{"-s", 0, "s"},
	{"sep", 0, "s"},
	{"-l", 0, "l"},
	{"loglimit", 0, "l"},
	{NULL}
};

/* login count database options */
static struct lopt {
	char *name;		/* option name */
	int minpar;		/* min parameter required */
	char *cases;		/* cases, used with switch() */
} lopts[] = {			/* options allowed: */
	{"-a", 1, "a"},
	{"all", 1, "a"},
	{"All", 1, "a"},
	{"ALL", 1, "a"},
	{"-u", 1, "u"},
	{"user", 1, "u"},
	{"User", 1, "u"},
	{"USER", 1, "u"},
	{NULL}
};

read_options(char *filename, char *options[], 
char *argv[][1024], int *parnum[], int opt_type)
{	
	FILE *fd;			/* file handler */
	char opt[100][1024];		/* options */
	struct opt *optp;		/* pointer to options */
	char lopt[500][1024];		/* login count options */
	struct lopt *loptp;		/* pointer to options */
	int i = 0, a = 0, h = 0;	/* counters */
	int parn;			/* parameters num */

	/* find out number of parameters in options */
	if ((fd = fopen(filename, "r")) == 0 ) {
	    printf("ttc: %s\n", strerror(errno));
	    exit(1); }
	while ((parn = find_parnum(fd, parn)) != -1) {
    	    parnum[a] = (int *)parn;
     	    parn = 0;
	    a++; }
	fclose(fd);
	a = 1;

	/* get option and see if it's legal */
	fd = fopen(filename, "r");
	if (!opt_type) {
	  while(getword(fd, opt[h]) != -1) {	
	    for (optp = opts; optp->name; optp++)
	    	if (!strcmp(opt[h], optp->name)) {	/* is there a match */
		    if ((int)parnum[h] < optp->minpar) {
			printf("ttc: Too few parameters in %s option.\n", opt[h]);
			exit(1); }

		    options[h] = optp->cases;		/* options case */

		    if ((int)parnum[h] != 0) {

		    	/* get parameters for option */
		    	for (i = 0; i < (int)parnum[h]; i++) {
		    	    getword(fd, argv[a]);
		    	    a++; }
		    }
		}
 	    	h++;
	  }
	} else {
	  while(getword(fd, lopt[h]) != -1) {	
	    for (loptp = lopts; loptp->name; loptp++)
	    	if (!strcmp(lopt[h], loptp->name)) {	/* is there a match */
		    if ((int)parnum[h] < loptp->minpar) {
			printf("log_limit: Too few parameters in %s option.\n", opt[h]);
			exit(1); }

		    options[h] = loptp->cases;		/* options case */

		    if ((int)parnum[h] != 0) {

		    	/* get parameters for option */
		    	for (i = 0; i < (int)parnum[h]; i++) {
		    	    getword(fd, argv[a]);
		    	    a++; }
		    }
		}
 	    	h++;
	  }
	}
	fclose(fd);
	return h;			/* return number of options */
}

find_parnum(FILE *fd, int parnum)	/* find out number of parameters */
{
	int ch;
	int marked = 0;			/* we'll assume line is legal */
	int firstchar = 1;		/* we'll assume first char is '\n' */

	while((ch = getc(fd)) != EOF) {
	    if (ch == '\n')			/* end of line ? */
		if (firstchar != 1) {
		    if (marked != 1) {
		    	break;
		    } else {			/* if line was illegal */
		    	parnum = 0;		/* no parameters */
		    	marked = 0;		/* next line might be ok */
			firstchar = 1;		/* but it may start as '\n' */
		    	continue; }
		} else {			/* first char was '\n' */
		   firstchar = 1;		/* next line may be '\n' too */
		   continue; }
	    if (check_char(ch) == -1) {		/* -1 illegal char */
		marked = 1; 			/* so it's illegal line */
		firstchar = 0;			/* first char wasn't '\n' */
		continue; 
	    } else {
		firstchar = 0; }		/* first char wasn't '\n' */
	    if (ch == ' ')
		if (marked != 1)
		    parnum++;
	}
	if (ch == EOF)
	    return -1;
	return parnum;
}

getword(FILE *fd, char *opt)
{
	int ch;
	int i = 0;
	int marked = 0;			/* we'll assume line is legal */
	int firstchar = 1;		/* we'll assume first char is '\n' */

	while((ch = getc(fd)) != EOF) {
	    if (ch == '\n')			/* end of line ? */
		if (firstchar != 1) {
		    if (marked != 1) {
		    	break;
		    } else {			/* if line was illegal */
		    	i = 0;			/* we don't want it */
		    	marked = 0;		/* next line might be ok */
		   	firstchar = 1;		/* but it may start as '\n' */
		    	continue; }
		} else {			/* first char was '\n' */
		   firstchar = 1;		/* next line may be '\n' too */
		   continue; }
	    if (check_char(ch) == -1) {		/* -1 illegal char */
		marked = 1; 			/* so it's illegal line */
		firstchar = 0;			/* first char wasn't '\n' */
		continue; 
	    } else {
		firstchar = 0; }		/* first char wasn't '\n' */
	    if (ch == ' ')
		if (marked != 1)
		    break;
		else 
		    continue;
	    if (marked != 1) {
	    	opt[i] = ch;			/* option */
	    	i++; }
	}
	if (ch == EOF)
	    return -1;
	return 0;
}

check_char(int ch)		/* these characters are illegal */
{
	if (ch == '#') return -1;
	if (ch == '*') return -1;
	if (ch == '@') return -1;
	if (ch == '&') return -1;
	if (ch == '$') return -1;
	if (ch == '%') return -1;
	if (ch == '\'') return -1;
	if (ch == '\\') return -1;
	if (ch == '\t') return -1;
	if (ch == '\r') return -1;
	if (ch == '\a') return -1;
	if (ch == '\b') return -1;
	if (ch == '\f') return -1;
	if (ch == '"') return -1;
	return 0;		/* no illegal characters found */
}
